/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.providers;

import java.util.HashMap;
import java.util.Map;
import ru.softlogic.rma.providers.ServiceProvider;
import ru.softlogic.rma.providers.advanced.AdvancedProvider;
import ru.softlogic.rma.providers.hyperkassa.HyperKassaProvider;
import ru.softlogic.rma.providers.mobile.MobileProvider;
import ru.softlogic.rma.providers.universal.UniversalProvider;
import ru.softlogic.rma.providers.yandex.YandexProvider;

public class ServiceProviderFactory {
    private static ServiceProviderFactory instance = new ServiceProviderFactory();
    private Map<String, ServiceProvider> providers = new HashMap<String, ServiceProvider>();
    private Map<Short, String> adapter = new HashMap<Short, String>();

    private ServiceProviderFactory() {
        this.adapter.put((short)1, "Mobile");
        this.adapter.put((short)2, "Yandex");
        this.adapter.put((short)6, "UniversalProvider");
        this.adapter.put((short)11, "HyperkassaProvider");
    }

    public static ServiceProviderFactory getInstance() {
        return instance;
    }

    public synchronized ServiceProvider getProvider(short type) {
        ServiceProvider sp = this.providers.get(this.adapter.get(type));
        if (sp != null) {
            return sp;
        }
        switch (type) {
            case 1: {
                sp = new MobileProvider();
                break;
            }
            case 2: {
                sp = new YandexProvider();
                break;
            }
            case 6: {
                sp = new UniversalProvider();
                break;
            }
            case 11: {
                sp = new HyperKassaProvider();
            }
        }
        if (sp != null) {
            this.providers.put(this.adapter.get(type), sp);
        }
        return sp;
    }

    public synchronized ServiceProvider getProvider(String type) {
        ServiceProvider sp = this.providers.get(type);
        if (sp != null) {
            return sp;
        }
        if ("Mobile".equals(type)) {
            sp = new MobileProvider();
        } else if ("Yandex".equals(type)) {
            sp = new YandexProvider();
        } else if ("UniversalProvider".equals(type)) {
            sp = new UniversalProvider();
        } else if ("HyperkassaProvider".equals(type)) {
            sp = new HyperKassaProvider();
        } else if ("AdvancedProvider".equals(type)) {
            sp = new AdvancedProvider();
        }
        if (sp != null) {
            this.providers.put(type, sp);
        }
        return sp;
    }
}

