/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.scanner;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.PortId;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.rma.print.kkm.ApiFactory;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.NoSuchDeviceException;
import ru.softlogic.rma.print.kkm.SerialDeviceApi;
import ru.softlogic.rma.print.scanner.ConnectedDevice;

public class Scanner {
    private List<ConnectedDevice> result = Collections.synchronizedList(new LinkedList());
    private Logger log = Logger.getLogger((String)"scanner");

    public Scanner() {
        this.log.setAdditivity(false);
    }

    public List<ConnectedDevice> scan() throws InterruptedException {
        Date begin = new Date();
        LinkedList<Thread> listThread = new LinkedList<Thread>();
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.stscan"));
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.chkanypar"));
        PortId[] ports = PortScanner.scan();
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.sysports") + " " + Arrays.asList(ports)));
        for (PortId portId : ports) {
            if (portId.getType() != PortType.SerialPort) continue;
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.fndport"), new Object[]{portId.getName(), portId.getType()}));
            ScannerThread scannerThread = new ScannerThread(new SerialPort(portId.getName()), true);
            Thread thread = new Thread((Runnable)scannerThread, "Scanner-" + portId.getName());
            listThread.add(thread);
        }
        for (Thread thread : listThread) {
            thread.start();
        }
        for (Thread thread : listThread) {
            thread.join();
        }
        Date end = new Date();
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.scancomd") + " " + (end.getTime() - begin.getTime()) / 1000L));
        if (this.result.isEmpty()) {
            listThread.clear();
            for (PortId portId : ports) {
                if (portId.getType() != PortType.SerialPort) continue;
                boolean use = false;
                for (ConnectedDevice cd : this.result) {
                    if (!cd.getPort().getName().equals(portId.getName())) continue;
                    use = true;
                    break;
                }
                if (use) continue;
                ScannerThread scannerThread = new ScannerThread(new SerialPort(portId.getName()), false);
                Thread thread = new Thread((Runnable)scannerThread, "Scanner-" + portId.getName());
                listThread.add(thread);
            }
            for (Thread thread : listThread) {
                thread.start();
            }
            for (Thread thread : listThread) {
                thread.join();
            }
            Date end2 = new Date();
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.scansomparcomd") + " " + (end2.getTime() - end.getTime()) / 1000L));
        }
        return this.result;
    }

    private class ScannerThread
    implements Runnable {
        private SerialPort port;
        private boolean preferred;

        public ScannerThread(SerialPort port, boolean preferred) {
            this.port = port;
            this.preferred = preferred;
        }

        @Override
        public void run() {
            Scanner.this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.print.stscanth") + " " + this.port.getName()));
            for (KkmType type : KkmType.values()) {
                if (Scanner.this.result.size() > 0) break;
                SerialDeviceApi api = ApiFactory.create(type, this.port);
                if (api != null) {
                    Scanner.this.log.debug((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.schdevon"), new Object[]{type, this.port.getName()}));
                    try {
                        api.look(this.preferred);
                        Scanner.this.result.add(new ConnectedDevice(this.port, type));
                        Scanner.this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.fnddev"), new Object[]{type, this.port.getName()}));
                        break;
                    }
                    catch (NoSuchDeviceException ex) {
                        Scanner.this.log.debug((Object)LocBundle.getMessageLog((String)"rma.print.devntfnd"));
                        continue;
                    }
                }
                Scanner.this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.noapi"));
            }
            Scanner.this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.print.stopscon") + " " + this.port.getName()));
        }
    }
}

