/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.queue;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.RmaPaymentJob;
import ru.softlogic.rma.connector.ReferencesListener;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.print.PrintMode;
import ru.softlogic.rma.print.Printer;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.Kkm;
import ru.softlogic.rma.print.kkm.KkmOperation;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ReportResult;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.DocumentData;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.PrinterQueueListener;
import ru.softlogic.rma.print.queue.ReportData;
import ru.softlogic.rma.print.queue.RequestData;
import ru.softlogic.rma.utils.ReferenceUtil;

public class PrinterQueue
implements Runnable,
ReferencesListener {
    private LinkedBlockingDeque<Object> queue = new LinkedBlockingDeque();
    private Kkm kkm;
    private Printer printer;
    private Logger log;
    private Set<PrinterQueueListener> listeners = new HashSet<PrinterQueueListener>();
    private Set<PrinterQueueListener> remoteListeners = new HashSet<PrinterQueueListener>();
    private References references = new References();
    private static PrinterQueue printerQueue = new PrinterQueue();

    private PrinterQueue() {
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public static PrinterQueue getInstance() {
        return printerQueue;
    }

    public void addListener(PrinterQueueListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void addRemoteListener(PrinterQueueListener listener) {
        if (this.remoteListeners != null) {
            this.remoteListeners.add(listener);
        }
    }

    public void setKkm(Kkm kkm) {
        this.kkm = kkm;
    }

    public Kkm getKkm() {
        return this.kkm;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public void addRequest(RequestData requestData) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.addreqprnt") + ", rec=" + requestData));
        try {
            this.queue.put(requestData);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void addOperation(OperationData operationData) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.addopprnt") + " " + operationData));
        try {
            this.queue.put(operationData);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void addCustom(CustomData customData) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.addcustprnt") + " " + customData));
        try {
            this.queue.put(customData);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void addDocument(DocumentData documentData) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.adddocprnt") + " " + documentData));
        try {
            this.queue.put(documentData);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void addXReport() {
        try {
            this.queue.put(new ReportData(KkmOperation.FormReportX));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void addZReport(Object object) {
        try {
            this.queue.put(new ReportData(KkmOperation.FormReportZ, object));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void addInfoReport() {
        try {
            this.queue.put(new Integer(0));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void addReset() {
        try {
            this.queue.put(new Integer(1));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void addShiftReports(Object shTask) {
        try {
            this.queue.put(shTask);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.stthque"));
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Object or;
                Object operation;
                Object obj = this.queue.take();
                if (obj == null) continue;
                if (obj instanceof ShiftOperatingPrintRequest) {
                    ShiftOperatingPrintRequest shOper = (ShiftOperatingPrintRequest)obj;
                    if (this.printer != null) {
                        try {
                            this.printer.printShiftInfoResult(shOper);
                            this.notifyShiftReportResult("\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u0430");
                        }
                        catch (Exception ex) {
                            this.notifyShiftReportException(ex, ex.getMessage());
                        }
                    } else {
                        this.notifyShiftReportResult("\u041d\u0435\u0442 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                    }
                }
                if (obj instanceof OperationData) {
                    operation = (OperationData)obj;
                    if (this.kkm != null) {
                        try {
                            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.gendoc") + " " + ((OperationData)operation).getJob()));
                            this.kkm.open();
                            or = null;
                            or = PrintMode.PrintCopy.equals((Object)((OperationData)operation).getJob().getPrintMode()) && (((OperationData)operation).getJob().getRecord().getPrintInfo() & 2) != 0 ? this.kkm.printDocumentNotFiscalMode((OperationData)operation) : this.kkm.printDocument((OperationData)operation);
                            ((OperationResult)or).setJob(((OperationData)operation).getJob());
                            this.notifyOperationResult((OperationResult)or);
                        }
                        catch (Exception ex) {
                            this.notifyOperationException(ex, ((OperationData)operation).getJob());
                        }
                        finally {
                            this.kkm.close();
                        }
                    } else if (this.printer != null) {
                        if (((OperationData)operation).getJob().getSocket() != null) {
                            this.notifyRequestException(new IOException(LocBundle.getMessage((String)"rma.print.remotenotfiscal")), ((OperationData)operation).getJob());
                        } else {
                            try {
                                or = null;
                                or = PrintMode.PrintCopy.equals((Object)((OperationData)operation).getJob().getPrintMode()) && (((OperationData)operation).getJob().getRecord().getPrintInfo() & 2) != 0 ? this.printer.printDocumentNotFiscalMode((OperationData)operation) : this.printer.printDocument((OperationData)operation);
                                ((OperationResult)or).setJob(((OperationData)operation).getJob());
                                this.notifyOperationResult((OperationResult)or);
                            }
                            catch (IOException ex) {
                                this.notifyOperationException(ex, ((OperationData)operation).getJob());
                            }
                        }
                    } else {
                        this.notifyOperationResult(new OperationResult(-1, true, LocBundle.getMessage((String)"rma.print.noprntdev"), ((OperationData)operation).getJob()));
                    }
                }
                if (obj instanceof DocumentData) {
                    try {
                        operation = (DocumentData)obj;
                        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.gendoc") + " " + operation));
                        this.kkm.open();
                        this.notifyOperationResult(this.kkm.printDocument((DocumentData)operation));
                    }
                    catch (Exception ex) {
                        this.notifyOperationException(ex, null);
                    }
                    finally {
                        this.kkm.close();
                    }
                }
                if (obj instanceof RequestData) {
                    operation = (RequestData)obj;
                    if (this.kkm != null) {
                        try {
                            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.gendoc") + " " + ((RequestData)operation).getJob()));
                            this.kkm.open();
                            or = this.kkm.printRequest((RequestData)operation);
                            ((OperationResult)or).setJob(((RequestData)operation).getJob());
                            this.notifyRequestResult((OperationResult)or);
                        }
                        catch (Exception ex) {
                            this.notifyRequestException(ex, ((RequestData)operation).getJob());
                        }
                        finally {
                            this.kkm.close();
                        }
                    } else if (this.printer != null) {
                        try {
                            or = this.printer.printRequest((RequestData)operation);
                            ((OperationResult)or).setJob(((RequestData)operation).getJob());
                            this.notifyRequestResult((OperationResult)or);
                        }
                        catch (IOException ex) {
                            this.notifyRequestException(ex, ((RequestData)operation).getJob());
                        }
                    } else {
                        this.notifyRequestResult(new OperationResult(-1, true, LocBundle.getMessage((String)"rma.print.noprntdev"), ((RequestData)operation).getJob()));
                    }
                }
                if (obj instanceof CustomData) {
                    operation = (CustomData)obj;
                    if (this.kkm != null) {
                        try {
                            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.gencustdoc") + " " + operation));
                            this.kkm.open();
                            or = this.kkm.printCustomNotFiscalMode((CustomData)operation);
                            this.notifyCustomResult((CustomOperationResult)or);
                        }
                        catch (Exception ex) {
                            this.notifyCustomException(ex, (CustomData)operation);
                        }
                        finally {
                            this.kkm.close();
                        }
                    } else if (this.printer != null) {
                        try {
                            or = this.printer.printCustomNotFiscalMode((CustomData)operation);
                            this.notifyCustomResult((CustomOperationResult)or);
                        }
                        catch (IOException ex) {
                            this.notifyCustomException(ex, (CustomData)operation);
                        }
                    } else {
                        this.notifyCustomResult(new CustomOperationResult(-1, true, LocBundle.getMessage((String)"rma.print.noprntdev"), (CustomData)operation));
                    }
                }
                if (!(obj instanceof Integer)) continue;
                Integer val = (Integer)obj;
                if (val == 0) {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.askinfo"));
                    try {
                        this.kkm.open();
                        this.notifyInfoResult(this.kkm.getInfo());
                        continue;
                    }
                    catch (Exception ex) {
                        this.notifyInfoException(ex);
                        continue;
                    }
                    finally {
                        this.kkm.close();
                        continue;
                    }
                }
                if (val != 1) continue;
                this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.resetkkm"));
                try {
                    this.kkm.open();
                    this.notifyResetResult(this.kkm.reset());
                }
                catch (Exception ex) {
                    this.notifyResetException(ex);
                }
                finally {
                    this.kkm.close();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.spthque"));
    }

    public void notifyShiftReportResult(String res) {
        this.log.info((Object)("\u041f\u0435\u0440\u0430\u0434\u0430\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0435\u0447\u0430\u0442\u0438 " + res));
        for (PrinterQueueListener l : this.listeners) {
            l.onShiftReportResult(res);
        }
    }

    public void notifyShiftReportException(Exception ex, String res) {
        this.log.info((Object)("\u041f\u0435\u0440\u0430\u0434\u0430\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0435\u0447\u0430\u0442\u0438 " + res));
        for (PrinterQueueListener l : this.listeners) {
            l.onShiftException(ex, res);
        }
    }

    private void notifyReportResult(ReportResult reportResult) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.repfdres") + " " + reportResult));
        for (PrinterQueueListener l : this.listeners) {
            l.onReportResult(reportResult);
        }
    }

    private void notifyReportException(Exception exception) {
        this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.repex"), (Throwable)exception);
        for (PrinterQueueListener l : this.listeners) {
            l.onReportException(exception);
        }
    }

    private void notifyOperationResult(OperationResult operationResult) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.docfdres") + " " + operationResult));
        if (operationResult.getJob() != null && operationResult.getJob().getSocket() != null) {
            for (PrinterQueueListener l : this.remoteListeners) {
                l.onOperationResult(operationResult);
            }
        } else {
            for (PrinterQueueListener l : this.listeners) {
                l.onOperationResult(operationResult);
            }
        }
    }

    private void notifyOperationException(Exception exception, RmaPaymentJob job) {
        this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.docex"), (Throwable)exception);
        if (job != null && job.getSocket() != null) {
            for (PrinterQueueListener l : this.remoteListeners) {
                l.onOperationException(exception, job);
            }
        } else {
            for (PrinterQueueListener l : this.listeners) {
                l.onOperationException(exception, job);
            }
        }
    }

    private void notifyRequestResult(OperationResult operationResult) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.reqfdres") + " " + operationResult));
        if (operationResult.getJob().getSocket() != null) {
            for (PrinterQueueListener l : this.remoteListeners) {
                l.onRequestResult(operationResult);
            }
        } else {
            for (PrinterQueueListener l : this.listeners) {
                l.onRequestResult(operationResult);
            }
        }
    }

    private void notifyRequestException(Exception exception, RmaPaymentJob job) {
        this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.reqex"), (Throwable)exception);
        if (job.getSocket() != null) {
            for (PrinterQueueListener l : this.remoteListeners) {
                l.onRequestException(exception, job);
            }
        } else {
            for (PrinterQueueListener l : this.listeners) {
                l.onRequestException(exception, job);
            }
        }
    }

    private void notifyInfoResult(String string) {
        for (PrinterQueueListener l : this.listeners) {
            l.onInfoResult(string);
        }
    }

    private void notifyInfoException(Exception exception) {
        this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.infoex"), (Throwable)exception);
        for (PrinterQueueListener l : this.listeners) {
            l.onInfoException(exception);
        }
    }

    private void notifyResetResult(ReportResult reportResult) {
        for (PrinterQueueListener l : this.listeners) {
            l.onResetResult(reportResult);
        }
    }

    private void notifyResetException(Exception exception) {
        this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.resetex"), (Throwable)exception);
        for (PrinterQueueListener l : this.listeners) {
            l.onResetException(exception);
        }
    }

    @Override
    public void onReferences(References newReferences) {
        this.references = ReferenceUtil.update(this.references, newReferences);
    }

    private void notifyCustomResult(CustomOperationResult or) {
        if (or.getData().getSocket() != null) {
            for (PrinterQueueListener l : this.remoteListeners) {
                l.onCustomResult(or);
            }
        } else {
            for (PrinterQueueListener l : this.listeners) {
                l.onCustomResult(or);
            }
        }
    }

    private void notifyCustomException(Exception ex, CustomData operation) {
        this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.resetex"), (Throwable)ex);
        if (operation.getSocket() != null) {
            for (PrinterQueueListener l : this.remoteListeners) {
                l.onCustomException(ex, operation);
            }
        } else {
            for (PrinterQueueListener l : this.listeners) {
                l.onCustomException(ex, operation);
            }
        }
    }
}

