/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.shtrih;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.print.PrintMode;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.Kkm;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ReportResult;
import ru.softlogic.rma.print.kkm.ShiftInfoResult;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.kkm.render.RenderFactory;
import ru.softlogic.rma.print.kkm.shtrih.Info;
import ru.softlogic.rma.print.kkm.shtrih.LongStatus;
import ru.softlogic.rma.print.kkm.shtrih.Result;
import ru.softlogic.rma.print.kkm.shtrih.ShortStatus;
import ru.softlogic.rma.print.kkm.shtrih.ShtrihApi;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.DocumentData;
import ru.softlogic.rma.print.queue.DocumentType;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;

public class ShtrihKkm
implements Kkm {
    private ShtrihApi api;
    private Logger log;
    private ResourceBundle bundle;
    private Info kkmInfo;
    private LongStatus longStatus;
    private Boolean supportMemory;
    private int scroll;
    private int purchaseSection;
    private int interestSection;

    public ShtrihKkm(SerialPort port) {
        this.api = new ShtrihApi(port);
        this.bundle = ResourceBundle.getBundle("ru.softlogic.rma.print.kkm.kkm");
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.setScroll(0);
        this.setPurchaseSection(1);
        this.setInterestSection(2);
    }

    @Override
    public OperationResult printRequest(RequestData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        this.log.info((Object)"==================== \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0437\u0430\u044f\u043a\u0443 ====================");
        this.validate();
        Result res = null;
        Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.ShtrihM);
        String image = render.process(data, this.api.getPrintWidth()).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            res = prn.startsWith("<b>") ? this.api.printString(prn.replace("<b>", ""), true) : this.api.printString(prn, false);
            this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            if (res.getCode() == 0) continue;
            return this.getOperationResult(res);
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            res = this.api.feedCheck(this.scroll);
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
            if (res.getCode() != 0) {
                return this.getOperationResult(res);
            }
        }
        if (this.api.isCutSupport()) {
            this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u043a\u0430 \u0447\u0435\u043a\u0430");
            res = this.api.cut(true);
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
        }
        return this.getOperationResult(new Result(0, null));
    }

    @Override
    public OperationResult printDocument(OperationData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        if (data.getJob().getRecord() == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Record");
        }
        Record record = data.getJob().getRecord();
        this.log.info((Object)"Begin------------------------------------------------------");
        this.validate();
        Result res = null;
        if (data.getJob().getPrintMode() == PrintMode.PrintCheckBack) {
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430, \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
            res = this.api.openCheck(2);
            this.addRes(res);
            if (res.getCode() != 0) {
                return this.getOperationResult(res);
            }
            if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0440\u0435\u043a\u043b\u0430\u043c\u0443: " + data.getJob().getBeginAdvText()));
                String image = data.getJob().getBeginAdvText().trim();
                Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
                while (m.find()) {
                    String prn = m.group(0);
                    res = prn.startsWith("<b>") ? this.api.printString(prn.replace("<b>", ""), true) : this.api.printString(prn, false);
                    this.addRes(res);
                }
            }
            if (record.getSumIncome() > 0) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0442\u043e\u0432\u0430\u0440\u0430");
                res = this.api.addOperation(130, record.getServiceName(), record.getSumIncome(), 1000, this.purchaseSection);
                this.addRes(res);
                if (res.getCode() != 0) {
                    return this.getOperationResult(res);
                }
            }
            Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.ShtrihM);
            String image = render.process(data, this.api.getPrintWidth()).replace("<br>", "\n");
            if (data.getJob().getEndAdvText() != null && data.getJob().getEndAdvText().isEmpty()) {
                image = image + data.getJob().getEndAdvText().trim();
            }
            Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                res = prn.startsWith("<b>") ? this.api.printString(prn.replace("<b>", ""), true) : this.api.printString(prn, false);
                if (res.getCode() == 0) continue;
                return this.getOperationResult(res);
            }
        } else {
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a \u043f\u0440\u043e\u0434\u0430\u0436\u0438,\u043e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
            res = this.api.openCheck(0);
            this.addRes(res);
            if (res.getCode() != 0) {
                return this.getOperationResult(res);
            }
            if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0440\u0435\u043a\u043b\u0430\u043c\u0443: " + data.getJob().getBeginAdvText()));
                String image = data.getJob().getBeginAdvText().trim();
                Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
                while (m.find()) {
                    String prn = m.group(0);
                    res = prn.startsWith("<b>") ? this.api.printString(prn.replace("<b>", ""), true) : this.api.printString(prn, false);
                    this.addRes(res);
                }
            }
            if (record.getSumOutcome() > 0) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430");
                res = this.api.addOperation(128, record.getServiceName(), record.getSumOutcome(), 1000, this.purchaseSection);
                this.addRes(res);
                if (res.getCode() != 0) {
                    return this.getOperationResult(res);
                }
            }
            if (record.getSumComm() > 0) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438");
                res = this.api.addOperation(128, this.bundle.getString("comission"), record.getSumComm(), 1000, this.interestSection);
                this.addRes(res);
                if (res.getCode() != 0) {
                    return this.getOperationResult(res);
                }
            }
            Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.ShtrihM);
            String image = render.process(data, this.api.getPrintWidth()).replace("<br>", "\n");
            if (data.getJob().getEndAdvText() != null && data.getJob().getEndAdvText().isEmpty()) {
                image = image + data.getJob().getEndAdvText().trim();
            }
            Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                res = prn.startsWith("<b>") ? this.api.printString(prn.replace("<b>", ""), true) : this.api.printString(prn, false);
                if (res.getCode() == 0) continue;
                return this.getOperationResult(res);
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
        res = this.api.closeCheck(record.getSumIncome(), 0);
        this.addRes(res);
        return this.getOperationResult(res);
    }

    @Override
    public OperationResult printDocument(DocumentData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        if (data.getType() == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DocumentType");
        }
        if (data.getSum() <= 0) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u0441\u0443\u043c\u043c\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
        }
        if (data.getCount() <= 0) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435");
        }
        this.log.info((Object)"Begin------------------------------------------------------");
        this.validate();
        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a: " + data));
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        Result res = this.api.openCheck(data.getType() == DocumentType.Sale ? 0 : 2);
        this.addRes(res);
        if (res.getCode() != 0) {
            return this.getOperationResult(res);
        }
        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430");
        res = this.api.addOperation(data.getType() == DocumentType.Sale ? 128 : 130, data.getName() != null ? data.getName() : "\u0422\u043e\u0432\u0430\u0440", data.getSum(), data.getCount() * 1000, this.purchaseSection);
        this.addRes(res);
        if (res.getCode() != 0) {
            return this.getOperationResult(res);
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
        res = this.api.closeCheck(data.getSum(), 0);
        this.addRes(res);
        return this.getOperationResult(res);
    }

    @Override
    public ReportResult formReportX() throws IOException {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c X-\u043e\u0442\u0447\u0435\u0442");
        Result resX = this.api.reportX();
        this.addRes(resX);
        if (resX.getCode() == 0 && this.getKkmInfo().getModel() == Info.SHTRIH_KIOSK_FR_K) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u0440\u0435\u0437\u0430\u0442\u044c \u0447\u0435\u043a");
            Result res = this.api.cut(true);
            this.addRes(res);
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0432\u044b\u0434\u0430\u0442\u044c \u0447\u0435\u043a");
            res = this.api.outCheck(false);
            this.addRes(res);
        }
        return new ReportResult(resX.getCode(), resX.getCode() != 0, this.getMessage(resX));
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        Result res;
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442");
        Result resZ = this.api.reportZ();
        this.addRes(resZ);
        if (resZ.getCode() == 0 && this.getKkmInfo().getModel() == Info.SHTRIH_KIOSK_FR_K) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u0440\u0435\u0437\u0430\u0442\u044c \u0447\u0435\u043a");
            res = this.api.cut(true);
            this.addRes(res);
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0432\u044b\u0434\u0430\u0442\u044c \u0447\u0435\u043a");
            res = this.api.outCheck(false);
            this.addRes(res);
        }
        if (resZ.getCode() == 0 || resZ.getCode() == 22) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u043e\u0432\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443");
            res = this.api.openSession();
            this.addRes(res);
        }
        return new ReportResult(resZ.getCode(), resZ.getCode() != 0, this.getMessage(resZ));
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }

    private OperationResult getOperationResult(Result res) {
        return new OperationResult(res.getCode(), res.getCode() != 0, res.getCode() == 78, this.getMessage(res));
    }

    private CustomOperationResult getCustomOperationResult(Result res) {
        return new CustomOperationResult(res.getCode(), res.getCode() != 0, res.getCode() == 78, this.getMessage(res));
    }

    private void addRes(Result result) {
        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result + ", message=" + this.getMessage(result)));
    }

    private String getMessage(Result result) {
        return this.getMessage(result.getCode());
    }

    private String getMessage(int error) {
        ResourceBundle b = ResourceBundle.getBundle("ru.softlogic.rma.print.kkm.shtrih.messages");
        try {
            return b.getString(String.format("%d", error));
        }
        catch (Throwable ex) {
            return b.getString("undefined");
        }
    }

    private Info getKkmInfo() throws IOException {
        if (this.kkmInfo == null) {
            this.kkmInfo = this.api.getInfo();
            this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u041a\u041a\u041c:");
            this.log.info((Object)("\t\u041c\u043e\u0434\u0435\u043b\u044c: " + this.kkmInfo.getModel()));
            this.log.info((Object)("\t\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: " + this.kkmInfo.getName()));
            this.log.info((Object)("\t\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b: " + this.kkmInfo.getProto() + "." + this.kkmInfo.getSubproto()));
            this.log.info((Object)("\t\u0422\u0438\u043f: " + this.kkmInfo.getType() + "." + this.kkmInfo.getSubtype()));
        }
        return this.kkmInfo;
    }

    private LongStatus getLongStatus() throws IOException {
        if (this.longStatus == null) {
            this.longStatus = this.api.getLongStatus();
            this.log.info((Object)"\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441:");
            this.log.info((Object)("\t\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438: " + this.longStatus.getSoftwareVersionFm()));
            this.log.info((Object)("\t\u0421\u0431\u043e\u0440\u043a\u0430 \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438: " + this.longStatus.getSoftwareBuildFm()));
            this.log.info((Object)("\t\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430: " + this.longStatus.getSoftwareVersionFr()));
            this.log.info((Object)("\t\u0421\u0431\u043e\u0440\u043a\u0430 \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430: " + this.longStatus.getSoftwareBuildFr()));
            this.log.info((Object)("\t\u0418\u041d\u041d: " + this.longStatus.getInn()));
            this.log.info((Object)("\t\u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440: " + this.longStatus.getNumber()));
            this.log.info((Object)("\t\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0432 \u0424\u041f: " + this.longStatus.getAvaliableRecordsFm()));
        }
        return this.longStatus;
    }

    private void validate() throws IOException {
        ShortStatus ss = this.api.getShortStatus();
        if (ss.getSubMode() == 3) {
            this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0438");
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 '\u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0447\u0430\u0442\u0438': " + this.api.continuePrint()));
        }
        if ((ss.getMode() & 0xFF) == 8) {
            this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442. \u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e");
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 '\u043e\u0442\u043c\u0435\u043d\u044b \u0447\u0435\u043a\u0430': " + this.api.cancelCheck()));
        }
    }

    @Override
    public String getInfo() throws IOException {
        StringBuilder sb = new StringBuilder();
        Info info = this.api.getInfo();
        sb.append("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u041a\u041a\u041c:").append("\n");
        sb.append("    \u041c\u043e\u0434\u0435\u043b\u044c: ").append(info.getModel()).append("\n");
        sb.append("    \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: ").append(info.getName()).append("\n");
        sb.append("    \u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b: ").append(info.getProto()).append(".").append(info.getSubproto()).append("\n");
        sb.append("    \u0422\u0438\u043f: ").append(info.getType()).append(".").append(info.getSubtype()).append("\n");
        sb.append("\n");
        ShortStatus ss = this.api.getShortStatus();
        sb.append("\u041a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441:").append("\n");
        sb.append("    \u0420\u0435\u0436\u0438\u043c: ").append(ss.getMode()).append(".").append(ss.getSubMode()).append("\n");
        sb.append("\n");
        LongStatus ls = this.api.getLongStatus();
        sb.append("\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441:").append("\n");
        sb.append("    \u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438: ").append(ls.getSoftwareVersionFm()).append("\n");
        sb.append("    \u0421\u0431\u043e\u0440\u043a\u0430 \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0430\u043c\u044f\u0442\u0438: ").append(ls.getSoftwareBuildFm()).append("\n");
        sb.append("    \u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430: ").append(ls.getSoftwareVersionFr()).append("\n");
        sb.append("    \u0421\u0431\u043e\u0440\u043a\u0430 \u041f\u041e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430: ").append(ls.getSoftwareBuildFr()).append("\n");
        sb.append("    \u0418\u041d\u041d: ").append(ls.getInn()).append("\n");
        sb.append("    \u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440: ").append(ls.getNumber()).append("\n");
        sb.append("    \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0432 \u0424\u041f: ").append(ls.getAvaliableRecordsFm()).append("\n");
        return sb.toString();
    }

    @Override
    public ReportResult reset() throws IOException {
        Result result = this.api.reset();
        return new ReportResult(result.getCode(), result.getCode() != 0, this.getMessage(result));
    }

    @Override
    public void setScroll(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Wrog scroll value");
        }
        this.scroll = 5 + value;
    }

    @Override
    public void setPurchaseSection(int section) {
        this.purchaseSection = section;
    }

    @Override
    public void setInterestSection(int section) {
        this.interestSection = section;
    }

    @Override
    public OperationResult printDocumentNotFiscalMode(OperationData data) throws IOException {
        this.log.info((Object)"==================== \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0432 \u043d\u0435 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u043c \u0440\u0435\u0436\u0438\u043c\u0435 ====================");
        this.validate();
        Result res = null;
        if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
            this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0440\u0435\u043a\u043b\u0430\u043c\u0443: " + data.getJob().getBeginAdvText()));
            String image = data.getJob().getBeginAdvText().trim();
            Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                res = prn.startsWith("<b>") ? this.api.printString(prn.replace("<b>", ""), true) : this.api.printString(prn, false);
                this.addRes(res);
            }
        }
        Render render = RenderFactory.createRenderCopy(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() + ".copy" : null, KkmType.ShtrihM);
        String image = render.process(data, this.api.getPrintWidth()).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            res = prn.startsWith("<b>") ? this.api.printString(prn.replace("<b>", ""), true) : this.api.printString(prn, false);
            this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            if (res.getCode() == 0) continue;
            return this.getOperationResult(res);
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            res = this.api.feedCheck(this.scroll);
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
            if (res.getCode() != 0) {
                return this.getOperationResult(res);
            }
        }
        if (this.api.isCutSupport()) {
            this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u043a\u0430 \u0447\u0435\u043a\u0430");
            res = this.api.cut(true);
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
        }
        return this.getOperationResult(new Result(0, null));
    }

    @Override
    public CustomOperationResult printCustomNotFiscalMode(CustomData data) throws IOException {
        if (data == null) {
            return new CustomOperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        this.log.info((Object)"==================== \u041f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u0430\u044f \u043f\u0435\u0447\u0430\u0442\u044c ====================");
        this.validate();
        Result res = null;
        Render render = RenderFactory.createRender(data.getTemplate(), KkmType.ShtrihM);
        String image = render.process(data, this.api.getPrintWidth()).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            res = prn.startsWith("<b>") ? this.api.printString(prn.replace("<b>", ""), true) : this.api.printString(prn, false);
            this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            if (res.getCode() == 0) continue;
            return this.getCustomOperationResult(res);
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            res = this.api.feedCheck(this.scroll);
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
            if (res.getCode() != 0) {
                return this.getCustomOperationResult(res);
            }
        }
        if (this.api.isCutSupport()) {
            this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u043a\u0430 \u0447\u0435\u043a\u0430");
            res = this.api.cut(true);
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
        }
        return this.getCustomOperationResult(new Result(0, null));
    }

    @Override
    public ShiftInfoResult printShiftInfoResult(ShiftOperatingPrintRequest req) throws IOException {
        this.log.error((Object)"\u043f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0447\u0435\u0440\u0435\u0437 \u0424\u0420 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        throw new IllegalStateException("\u041f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0447\u0435\u0440\u0435\u0437 \u0424\u0420 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }
}

