/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.shtrih;

import java.io.IOException;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.rma.print.kkm.shtrih.Result;
import ru.softlogic.rma.utils.ByteUtils;

public class ShtrihConnection {
    private final byte ENQ = (byte)5;
    private final byte STX = (byte)2;
    private final byte ACK = (byte)6;
    private final byte NAK = (byte)21;
    private SerialPort port;
    private Logger log;
    private int attempts = 5;

    public ShtrihConnection(SerialPort port) {
        this.port = port;
        this.log = Logger.getLogger((String)"print");
    }

    public void setAttempts(int attempts) {
        if (attempts < 1 || attempts > 20) {
            throw new IllegalArgumentException("Number of attempts should be in the range from 1 to 20");
        }
        this.attempts = attempts;
    }

    public Result sendCommand(int cmd, byte[] password, byte[] data) throws IOException {
        return this.sendCommand(cmd, password, data, 1500);
    }

    public Result sendCommand(int cmd, byte[] password, byte[] data, int timeout) throws IOException {
        Result last = null;
        for (int i = 0; i < 20; ++i) {
            Result res = this._sendCommand(cmd, password, data, timeout);
            switch (res.getCode()) {
                case 80: {
                    this.log.info((Object)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430. \u041e\u0436\u0438\u0434\u0430\u044e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f...");
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    break;
                }
                case 88: {
                    this.log.info((Object)"\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0438");
                    this._sendCommand(176, password, null, timeout);
                    break;
                }
                default: {
                    return res;
                }
            }
            last = res;
        }
        return last;
    }

    private Result _sendCommand(int cmd, byte[] password, byte[] data, int timeout) throws IOException {
        IOException last = null;
        byte[] message = this.formMessage(cmd, password, data);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.log.debug((Object)"\u0412\u044b\u044f\u0441\u043d\u044f\u0435\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0424\u0420");
                this.port.setTimeout(timeout);
                this.log.debug((Object)">> ENQ");
                this.port.write((byte)5);
                int res = this.port.readByte();
                switch (res) {
                    case 21: {
                        this.log.debug((Object)"<< NAK");
                        this.log.debug((Object)"\u0413\u043e\u0442\u043e\u0432 \u043a \u0440\u0430\u0431\u043e\u0442\u0435, \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u0443");
                        this.log.debug((Object)(">> " + ByteUtils.toString(message)));
                        this.port.write(message);
                        this.log.debug((Object)"\u041a\u043e\u043c\u043c\u0430\u043d\u0434\u0430 \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u0430, \u0447\u0438\u0442\u0430\u044e \u0431\u0430\u0439\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0435\u043d\u0438\u044f");
                        int ans = this.port.readByte();
                        this.log.debug((Object)("<< " + String.format("%02x", res)));
                        if (ans != 6) {
                            throw new IOException("FR failing to take command");
                        }
                        return this.readMessage(cmd, timeout);
                    }
                    case 6: {
                        this.log.debug((Object)"<< ACK");
                        this.log.info((Object)"Performs the previous command");
                        this.readMessage(null, timeout);
                        break;
                    }
                    default: {
                        this.log.debug((Object)("<< " + String.format("0x%02X", res) + ", cleaning trash"));
                        this.port.setTimeout(3);
                        this.log.debug((Object)("<< Trash=" + ByteUtils.toString(this.port.tryRead())));
                        break;
                    }
                }
                continue;
            }
            catch (IOException ex) {
                last = ex;
                this.log.error((Object)("Error when working with FR, an attempt " + (i + 1)), (Throwable)ex);
            }
        }
        throw new IOException(LocBundle.getMessageEx((String)"rma.print.cntsndpacket"), last);
    }

    private Result readMessage(Integer cmd, int timeout) throws IOException {
        this.log.debug((Object)"Reading answer:");
        this.port.setTimeout(timeout);
        int cnt = 0;
        int start = this.port.readByte();
        while (start != 2) {
            this.log.debug((Object)("<< " + String.format("%02x", start)));
            if (++cnt != 150) continue;
            throw new IOException("too long");
        }
        this.log.debug((Object)"<< STX");
        int len = this.port.readByte();
        this.log.debug((Object)("<< LEN = " + len));
        byte[] answer = new byte[len + 3];
        answer[0] = 2;
        answer[1] = (byte)len;
        this.port.setTimeout(len * 25 + 500);
        byte[] oth = this.port.read(len + 1);
        this.log.debug((Object)("<< " + ByteUtils.toString(oth)));
        System.arraycopy(oth, 0, answer, 2, oth.length);
        this.port.setTimeout(200);
        if (answer.length < 4) {
            this.log.debug((Object)">> NAK");
            this.port.write((byte)21);
            throw new IOException("Answer length must be at least 4 bytes");
        }
        if (answer[answer.length - 1] != this.getLrc(answer)) {
            this.log.debug((Object)">> NAK");
            this.port.write((byte)21);
            throw new IOException("Wrong CRC of answer");
        }
        if (cmd != null && (answer[2] & 0xFF) != cmd) {
            this.log.debug((Object)">> NAK");
            this.port.write((byte)21);
            throw new IOException("Response from the other command");
        }
        this.log.debug((Object)">> ACK");
        this.port.write((byte)6);
        byte[] result = null;
        if (answer.length > 4) {
            result = new byte[answer.length - 5];
            for (int i = 0; i < answer.length - 5; ++i) {
                result[i] = answer[i + 4];
            }
        }
        return new Result(answer[3] & 0xFF, result);
    }

    private byte[] formMessage(int cmd, byte[] password, byte[] data) {
        if (password != null && password.length != 4) {
            throw new IllegalArgumentException("Wrong FR password");
        }
        byte[] message = new byte[4 + (password == null ? 0 : password.length) + (data == null ? 0 : data.length)];
        message[0] = 2;
        message[1] = (byte)(message.length - 3);
        message[2] = (byte)cmd;
        int i = 0;
        if (password != null) {
            for (i = 0; i < password.length; ++i) {
                message[3 + i] = password[i];
            }
        }
        if (data != null && data.length > 0) {
            for (int j = 0; j < data.length; ++j) {
                message[3 + i + j] = data[j];
            }
        }
        message[message.length - 1] = this.getLrc(message);
        return message;
    }

    private byte getLrc(byte[] data) {
        byte result = 0;
        if (data == null || data.length < 2) {
            throw new IllegalArgumentException("Wrong data for LRC");
        }
        for (int i = 1; i < data.length - 1; ++i) {
            result = (byte)(result ^ data[i]);
        }
        return result;
    }

    private void logDataFlow(String name, byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        StringBuilder result = new StringBuilder();
        if (name != null && !name.isEmpty()) {
            result.append(name).append(": ");
        }
        for (int i = 0; i < data.length; ++i) {
            result.append(String.format("0x%02x ", data[i]));
        }
        this.log.debug((Object)result.toString());
    }
}

