/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.shtrih;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.NoSuchDeviceException;
import ru.softlogic.rma.print.kkm.SerialDeviceApi;
import ru.softlogic.rma.print.kkm.shtrih.Info;
import ru.softlogic.rma.print.kkm.shtrih.LongStatus;
import ru.softlogic.rma.print.kkm.shtrih.Result;
import ru.softlogic.rma.print.kkm.shtrih.ShortStatus;
import ru.softlogic.rma.print.kkm.shtrih.ShtrihConnection;
import ru.softlogic.rma.utils.ArrayUtils;

public class ShtrihApi
implements SerialDeviceApi {
    private SerialPort serialPort;
    private Map<Boolean, SerialParams[]> serialParams;
    private ShtrihConnection conn;
    private byte[] oPassword;
    private byte[] aPassword;
    private Logger log;
    private Boolean cutSupport;
    private List<Integer> cutUnsupportModels;
    private Integer printWidth;
    private Map<Integer, Integer> printWidthModels;

    public ShtrihApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("Need SerialPort");
        }
        this.serialPort = port;
        this.conn = new ShtrihConnection(port);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(4800, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(2400, DataBits.Eight, StopBits.One, Parity.None)});
        this.setAdminastratorPassword(30);
        this.setOperatorPassword(30);
        this.cutUnsupportModels = new LinkedList<Integer>();
        this.cutUnsupportModels.add(Info.ELVES_FR_K);
        this.printWidthModels = new HashMap<Integer, Integer>();
        this.printWidthModels.put(Info.ELVES_FR_K, 32);
        this.printWidthModels.put(Info.SHTRIH_MINI_FR_K, 40);
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public void setOperatorPassword(int password) {
        byte[] pass = new byte[]{(byte)(password & 0xFF), (byte)(password >> 8 & 0xFF), (byte)(password >> 16 & 0xFF), (byte)(password >> 24 & 0xFF)};
        this.oPassword = pass;
    }

    public void setAdminastratorPassword(int password) {
        byte[] pass = new byte[]{(byte)(password & 0xFF), (byte)(password >> 8 & 0xFF), (byte)(password >> 16 & 0xFF), (byte)(password >> 24 & 0xFF)};
        this.aPassword = pass;
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return ArrayUtils.arrayMerge(this.serialParams.get(true), this.serialParams.get(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void look(boolean preferred) throws NoSuchDeviceException {
        this.conn.setAttempts(3);
        for (SerialParams params : this.serialParams.get(preferred)) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            try {
                this.serialPort.putParams(params);
                this.open();
                this.getInfo();
                return;
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
            }
        }
        throw new NoSuchDeviceException(MessageFormat.format(LocBundle.getMessageEx((String)"rma.kkm.noshtrih"), this.serialPort.getName()));
    }

    public SerialPort getPort() {
        return this.serialPort;
    }

    @Override
    public void open() throws IOException {
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public Info getInfo() throws IOException {
        Result res = this.conn.sendCommand(252, null, null);
        if (res.getCode() != 0) {
            throw new IOException("Can not get device information, err=" + res.getCode());
        }
        byte[] data = res.getData();
        if (data == null || data.length < 8) {
            throw new IOException("No device description");
        }
        Info si = new Info();
        si.setType(data[0] & 0xFF);
        si.setSubtype(data[1] & 0xFF);
        si.setProto(data[2] & 0xFF);
        si.setSubproto(data[3] & 0xFF);
        si.setModel(data[4] & 0xFF);
        si.setLang(data[5] & 0xFF);
        try {
            si.setName(new String(data, 6, data.length - 6, "cp1251"));
        }
        catch (UnsupportedEncodingException ex) {
            si.setName("n/a");
        }
        return si;
    }

    public ShortStatus getShortStatus() throws IOException {
        Result res = this.conn.sendCommand(16, this.oPassword, null);
        ShortStatus result = new ShortStatus();
        if (res.getCode() != 0) {
            throw new IOException("Can not get short status, err=" + res.getCode());
        }
        if (res.getData() == null || res.getData().length < 14) {
            throw new IOException("Wrong data answer");
        }
        byte[] data = res.getData();
        result.setFlags((data[1] & 0xFF) + (data[2] << 8 & 0xFF00));
        result.setMode(data[3] & 0xFF);
        result.setSubMode(data[4] & 0xFF);
        result.setErrFp(data[8] & 0xFF);
        result.setErrEklz(data[9] & 0xFF);
        return result;
    }

    public LongStatus getLongStatus() throws IOException {
        Result res = this.conn.sendCommand(17, this.oPassword, null);
        if (res.getCode() != 0) {
            throw new IOException("Can not get long status, err=" + res.getCode());
        }
        if (res.getData() == null || res.getData().length < 46) {
            throw new IOException("\u0414\u0430\u043d\u043d\u044b\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u044b");
        }
        byte[] data = res.getData();
        LongStatus result = new LongStatus();
        try {
            result.setSoftwareVersionFr(new String(data, 1, 1, "cp1251") + "." + new String(data, 2, 1, "cp1251"));
        }
        catch (UnsupportedEncodingException ex) {
            result.setSoftwareVersionFr("n/a");
        }
        result.setSoftwareBuildFr((data[3] & 0xFF) + ((data[4] & 0xFF) << 8));
        try {
            result.setSoftwareVersionFm(new String(data, 16, 1, "cp1251") + "." + new String(data, 17, 1, "cp1251"));
        }
        catch (UnsupportedEncodingException ex) {
            result.setSoftwareVersionFm("n/a");
        }
        result.setSoftwareBuildFm((data[18] & 0xFF) + ((data[19] & 0xFF) << 8));
        result.setCheckNumber((data[9] & 0xFF) + ((data[10] & 0xFF) << 8));
        result.setNumber((data[30] & 0xFF) + ((data[31] & 0xFF) << 8) + ((data[32] & 0xFF) << 16) + ((data[33] & 0xFF) << 24));
        result.setAvaliableRecordsFm((data[36] & 0xFF) + ((data[37] & 0xFF) << 8));
        ShortStatus ss = new ShortStatus();
        ss.setFlags((data[11] & 0xFF) + (data[12] << 8 & 0xFF00));
        ss.setMode(data[13] & 0xFF);
        ss.setSubMode(data[14] & 0xFF);
        result.setShortStatus(ss);
        return result;
    }

    public Result reportX() throws IOException {
        return this.conn.sendCommand(64, this.aPassword, null, 7500);
    }

    public Result reportZ() throws IOException {
        return this.conn.sendCommand(65, this.aPassword, null, 7500);
    }

    public Result putReportToMemory() throws IOException {
        return this.conn.sendCommand(198, this.aPassword, null, 7500);
    }

    public Result printReportsFromMemory() throws IOException {
        return this.conn.sendCommand(199, this.aPassword, null, 7500);
    }

    public Result beep() throws IOException {
        return this.conn.sendCommand(19, this.oPassword, null);
    }

    public boolean isCutSupport() throws IOException {
        if (this.cutSupport == null) {
            this.requestPrinterAbilities();
        }
        return this.cutSupport;
    }

    public Result cut(boolean fullCut) throws IOException {
        byte data = (byte)(!fullCut ? 1 : 0);
        return this.conn.sendCommand(37, this.oPassword, new byte[]{data});
    }

    public int getPrintWidth() throws IOException {
        if (this.printWidth == null) {
            this.requestPrinterAbilities();
        }
        return this.printWidth;
    }

    public Result openSession() throws IOException {
        return this.conn.sendCommand(224, this.aPassword, null);
    }

    public Result trap(boolean open) throws IOException {
        byte data = (byte)(open ? 1 : 0);
        return this.conn.sendCommand(240, this.oPassword, new byte[]{data});
    }

    public Result outCheck(boolean lock) throws IOException {
        if (lock) {
            return this.conn.sendCommand(241, this.oPassword, new byte[]{1});
        }
        Result res = this.conn.sendCommand(241, this.oPassword, new byte[]{2});
        if (res.getCode() != 0) {
            return this.conn.sendCommand(241, this.oPassword, new byte[]{0});
        }
        return res;
    }

    public Result feedCheck(int count) throws IOException {
        if (count < 0 || count > 255) {
            throw new IllegalArgumentException("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u043e\u0442 0 \u0434\u043e 255");
        }
        return this.conn.sendCommand(41, this.oPassword, new byte[]{2, (byte)count});
    }

    public Result printString(String str, boolean bold) throws IOException {
        if (str == null) {
            return new Result(0, null);
        }
        if (bold) {
            str = this.getString(str, 20);
            byte[] data = new byte[1 + str.length()];
            data[0] = 2;
            byte[] bytes = str.getBytes("cp1251");
            System.arraycopy(bytes, 0, data, 1, bytes.length);
            return this.conn.sendCommand(18, this.oPassword, data);
        }
        str = this.getString(str, 40);
        byte[] data = new byte[1 + str.length()];
        data[0] = 2;
        byte[] bytes = str.getBytes("cp1251");
        System.arraycopy(bytes, 0, data, 1, bytes.length);
        return this.conn.sendCommand(23, this.oPassword, data);
    }

    public Result continuePrint() throws IOException {
        return this.conn.sendCommand(176, this.oPassword, null);
    }

    public Result cancelCheck() throws IOException {
        return this.conn.sendCommand(136, this.oPassword, null);
    }

    public Result reset() throws IOException {
        return this.conn.sendCommand(22, null, null);
    }

    public Short checkNumber() throws IOException {
        byte[] data;
        Result res = this.getOperationRegistry(152);
        if (res.getCode() == 0 && (data = res.getData()) != null && data.length == 3) {
            return (short)((data[1] & 0xFF) + (data[2] << 8 & 0xFF00) + 1);
        }
        return null;
    }

    public Result getOperationRegistry(int number) throws IOException {
        if (number < 0 || number > 255) {
            throw new IllegalArgumentException("Value of register number must be 0..255");
        }
        return this.conn.sendCommand(27, this.oPassword, new byte[]{(byte)number});
    }

    public Result readTable(int idTable, int idRow, int idField) throws IOException {
        if (idTable < 0 || idTable > 255) {
            throw new IllegalArgumentException("Value of table id must be from 0 to 255");
        }
        if (idRow < 0 || idRow > 65536) {
            throw new IllegalArgumentException("Value of column id must be from 0 to 65536");
        }
        if (idField < 0 || idField > 255) {
            throw new IllegalArgumentException("Value of field id must be from 0 to 255");
        }
        byte[] data = new byte[]{(byte)(idTable & 0xFF), (byte)(idRow & 0xFF), (byte)(idRow >> 8 & 0xFF), (byte)(idField & 0xFF)};
        return this.conn.sendCommand(31, this.aPassword, data);
    }

    public Result writeTable(int idTable, int idRow, int idField, byte[] value) throws IOException {
        if (value == null || value.length == 0 || value.length > 40) {
            throw new IllegalArgumentException("Written value must be from 1 to 40 bytes");
        }
        if (idTable < 0 || idTable > 255) {
            throw new IllegalArgumentException("Value of table id must be from 0 to 255");
        }
        if (idRow < 0 || idRow > 65536) {
            throw new IllegalArgumentException("Value of column id must be from 0 to 65536");
        }
        if (idField < 0 || idField > 255) {
            throw new IllegalArgumentException("Value of field id must be from 0 to 255");
        }
        byte[] data = new byte[value.length + 4];
        data[0] = (byte)(idTable & 0xFF);
        data[1] = (byte)(idRow & 0xFF);
        data[2] = (byte)(idRow >> 8 & 0xFF);
        data[3] = (byte)(idField & 0xFF);
        for (int i = 0; i < value.length; ++i) {
            data[4 + i] = value[i];
        }
        return this.conn.sendCommand(30, this.aPassword, data);
    }

    public Result writeTable(int idTable, int idRow, int idField, int value) throws IOException {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Value of field must be from 0 to 255");
        }
        return this.writeTable(idTable, idRow, idField, new byte[]{(byte)value});
    }

    public Result openCheck(int type) throws IOException {
        if (type < 0 || type > 4) {
            throw new IllegalArgumentException("Wrong document type");
        }
        return this.conn.sendCommand(141, this.oPassword, new byte[]{(byte)type}, 2000);
    }

    public Result closeCheck(int cash, int cashbackcard) throws IOException {
        byte[] data = new byte[66];
        data[0] = (byte)(cash & 0xFF);
        data[1] = (byte)(cash >> 8 & 0xFF);
        data[2] = (byte)(cash >> 16 & 0xFF);
        data[3] = (byte)(cash >> 24 & 0xFF);
        data[4] = 0;
        data[5] = (byte)(cashbackcard & 0xFF);
        data[6] = (byte)(cashbackcard >> 8 & 0xFF);
        data[7] = (byte)(cashbackcard >> 16 & 0xFF);
        data[8] = (byte)(cashbackcard >> 24 & 0xFF);
        data[9] = 0;
        data[10] = 0;
        data[11] = 0;
        data[12] = 0;
        data[13] = 0;
        data[14] = 0;
        data[15] = 0;
        data[16] = 0;
        data[17] = 0;
        data[18] = 0;
        data[19] = 0;
        data[20] = 0;
        data[21] = 0;
        data[22] = 0;
        data[23] = 0;
        data[24] = 0;
        data[25] = 0;
        byte[] str = this.getString("", 40).getBytes("cp1251");
        System.arraycopy(str, 0, data, 26, 40);
        return this.conn.sendCommand(133, this.oPassword, data, 5000);
    }

    public Result addOperation(int type, String name, int price, int count, int section) throws IOException {
        if (type < 128 || type > 131) {
            throw new IllegalArgumentException("Wrong operation type");
        }
        if (section < 0 || section > 16) {
            throw new IllegalArgumentException("Wrong unit number");
        }
        if (name == null) {
            name = "\u043d/\u0443";
        }
        name = this.getString(name, 40);
        byte[] bname = null;
        try {
            bname = name.getBytes("cp1251");
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] data = new byte[15 + (bname == null ? 0 : bname.length)];
        data[0] = (byte)(count & 0xFF);
        data[1] = (byte)(count >> 8 & 0xFF);
        data[2] = (byte)(count >> 16 & 0xFF);
        data[3] = (byte)(count >> 24 & 0xFF);
        data[4] = 0;
        data[5] = (byte)(price & 0xFF);
        data[6] = (byte)(price >> 8 & 0xFF);
        data[7] = (byte)(price >> 16 & 0xFF);
        data[8] = (byte)(price >> 24 & 0xFF);
        data[9] = 0;
        data[10] = (byte)section;
        data[11] = 0;
        data[12] = 0;
        data[13] = 0;
        data[14] = 0;
        if (bname != null) {
            for (int i = 0; i < bname.length; ++i) {
                data[15 + i] = bname[i];
            }
        }
        return this.conn.sendCommand(type, this.oPassword, data);
    }

    private void requestPrinterAbilities() throws IOException {
        Info i = this.getInfo();
        this.cutSupport = !this.cutUnsupportModels.contains(i.getModel());
        this.printWidth = this.printWidthModels.get(i.getModel());
        if (this.printWidth == null) {
            this.printWidth = 40;
        }
    }

    @Override
    public KkmType getKkmType() {
        return KkmType.ShtrihM;
    }

    private String getString(String str, int len) {
        if (str == null) {
            str = "";
        }
        if (str.length() > len) {
            str = str.substring(0, len - 2) + "..";
        } else if (str.length() < len) {
            while (str.length() < len) {
                str = str + " ";
            }
        }
        return str;
    }
}

