/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.render;

import java.io.File;
import org.apache.log4j.Logger;
import ru.softlogic.rma.persistence.DocType;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.render.BaseIppRender;
import ru.softlogic.rma.print.kkm.render.BaseKkmCopyRender;
import ru.softlogic.rma.print.kkm.render.BaseKkmRender;
import ru.softlogic.rma.print.kkm.render.BaseLPTRender;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.kkm.render.TemplateRender;
import ru.softlogic.rma.utils.PathUtils;

public class RenderFactory {
    public static Render createRender(String template, KkmType type) {
        Logger.getLogger((String)"print").info((Object)("\u0421\u043e\u0437\u0434\u0430\u044e \u0440\u0435\u043d\u0434\u0435\u0440 \u0434\u043b\u044f \u043a\u043a\u043c=" + (Object)((Object)type) + ",template=" + template));
        if (template == null || template.isEmpty()) {
            if (type == null) {
                return new BaseIppRender();
            }
            return new BaseKkmRender();
        }
        return new TemplateRender(PathUtils.getAppHome() + "/templates/default/", template, type);
    }

    public static Render createRenderCopy(String template, KkmType type) {
        Logger.getLogger((String)"print").info((Object)("\u0421\u043e\u0437\u0434\u0430\u044e \u0440\u0435\u043d\u0434\u0435\u0440 \u043a\u043e\u043f\u0438\u0438 \u0434\u043b\u044f \u043a\u043a\u043c=" + (Object)((Object)type) + ",template=" + template));
        if (template == null || template.isEmpty()) {
            if (type == null) {
                return new BaseIppRender();
            }
            return new BaseKkmCopyRender();
        }
        return new TemplateRender(PathUtils.getAppHome() + "/templates/default/", template, type);
    }

    public static Render createRender(String template, DocType docType) {
        Logger.getLogger((String)"print").info((Object)("\u0421\u043e\u0437\u0434\u0430\u044e \u0440\u0435\u043d\u0434\u0435\u0440 \u0434\u043b\u044f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u041e\u0421,template=" + template + "; docType=" + (Object)((Object)docType)));
        File tmplFile = new File(PathUtils.getAppHome() + "/templates/" + (Object)((Object)docType) + File.separator + "" + (docType == null ? "" : (Object)((Object)docType) + "_") + template);
        if (template == null || template.isEmpty() || !tmplFile.exists()) {
            tmplFile = new File(PathUtils.getAppHome() + "/templates/default/" + (docType == null ? "" : (Object)((Object)docType) + "_default"));
            if (tmplFile.exists() && tmplFile.canRead() && docType != null) {
                return new TemplateRender(tmplFile.getParent(), tmplFile.getName(), null);
            }
            return new BaseIppRender();
        }
        return new TemplateRender(PathUtils.getAppHome() + "/templates/" + (Object)((Object)docType), (docType == null ? "" : (Object)((Object)docType) + "_") + template, null);
    }

    public static Render createShiftResultRender() {
        String tempPath = PathUtils.getAppHome() + "/templates/shifts/shift";
        Logger.getLogger((String)"print").info((Object)("\u0421\u043e\u0437\u0434\u0430\u044e \u0440\u0435\u043d\u0434\u0435\u0440 \u0434\u043b\u044f \u043f\u0435\u0447\u0430\u0442\u0438 \u0441\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0447\u0451\u0442\u0430, \u0448\u0430\u0431\u043b\u043e\u043d=" + tempPath));
        File tmpFile = new File(tempPath);
        if (tmpFile.exists() && tmpFile.canRead()) {
            return new TemplateRender(tmpFile.getParent(), tmpFile.getName(), null);
        }
        return null;
    }

    public static Render createLPTRender(String template, DocType docType, boolean isReverse) {
        Logger.getLogger((String)"print").info((Object)("\u0421\u043e\u0437\u0434\u0430\u044e \u0440\u0435\u043d\u0434\u0435\u0440 \u0434\u043b\u044f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 LPT,template=" + template + "; docType=" + (Object)((Object)docType)));
        if (template == null || template.isEmpty()) {
            File tmplFile = new File(PathUtils.getAppHome() + "/templates/default/" + "lpt_" + (docType == null ? "" : (Object)((Object)docType) + "_") + "default" + (isReverse ? "_r" : ""));
            if (tmplFile.exists() && tmplFile.canRead()) {
                return new TemplateRender(tmplFile.getParent(), tmplFile.getName(), null);
            }
            return new BaseLPTRender();
        }
        return new TemplateRender(PathUtils.getAppHome() + "/templates/default/", "lpt_" + (docType == null ? "" : (Object)((Object)docType) + "_") + template + (isReverse ? "_r" : ""), null);
    }
}

