/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.render;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.rma.connector.model.Dealer;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.Operator;
import ru.softlogic.rma.connector.model.Point;
import ru.softlogic.rma.connector.model.Service;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;
import ru.softlogic.rma.utils.StateUtil;
import ru.softlogic.rma.utils.SumFormatter;
import ru.softlogic.rma.utils.TableStringUtil;

class BaseLPTRender
implements Render {
    private SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH::mm:ss");

    @Override
    public String process(RequestData requestData, int printWidth) {
        if (requestData == null || requestData.getJob().getRecord() == null) {
            return null;
        }
        Record rec = requestData.getJob().getRecord();
        MenuItem mi = requestData.getJob().getMenuItem();
        StringBuilder sb = new StringBuilder();
        sb.append("\u041f\u041e\u041b\u0423\u0427\u0410\u0422\u0415\u041b\u042c: ").append(rec.getServiceName()).append("\n");
        if (mi != null && mi.getService() != null) {
            sb.append(mi.getService().getLegalName()).append("\n");
        }
        sb.append("\u0421\u0423\u041c\u041c\u0410 \u0421 \u041a\u041b\u0418\u0415\u041d\u0422\u0410: ").append(SumFormatter.format(rec.getSumIncome())).append("\n");
        sb.append("\u0421\u0423\u041c\u041c\u0410 \u041d\u0410 \u0421\u0427\u0415\u0422: ").append(SumFormatter.format(rec.getSumOutcome())).append("\n");
        sb.append(rec.getAccountTitle() + ":").append("\n");
        sb.append(rec.getAccountValueTitle()).append("\n");
        sb.append("\n");
        if (rec.getAccount2() != null) {
            sb.append(rec.getAccount2Title() + ":").append("\n");
            sb.append(rec.getAccount2ValueTitle()).append("\n");
            sb.append("\n");
        }
        if (rec.getAttributes() != null) {
            for (String key : rec.getAttributes().keySet()) {
                RmaAttribute atr = rec.getAttributes().get(key);
                String title = atr.getKeyTitle();
                String value = atr.getValueTitle();
                sb.append(title == null ? key : title.toUpperCase()).append(": ").append(value).append("\n");
            }
        }
        sb.append("\n");
        sb.append("C \u0420\u0415\u041a\u0412\u0418\u0417\u0418\u0422\u0410\u041c\u0418 \u041f\u041b\u0410\u0422\u0415\u0416\u0410 \u0421\u041e\u0413\u041b\u0410\u0421\u0415\u041d").append("\n\n\n");
        String sign = "\u041f\u043e\u0434\u043f\u0438\u0441\u044c_____________";
        int len = printWidth - sign.length();
        for (int i = 0; i < len - 2; ++i) {
            sign = sign + "_";
        }
        sb.append(sign).append("\n");
        return sb.toString();
    }

    @Override
    public String process(OperationData operationData, int printWidth) {
        if (operationData == null || operationData.getJob().getRecord() == null) {
            return null;
        }
        Record record = operationData.getJob().getRecord();
        MenuItem mi = operationData.getJob().getMenuItem();
        Service s = null;
        if (mi != null) {
            s = mi.getService();
        }
        Point p = null;
        Operator o = null;
        Dealer d = null;
        if (operationData.getReferences() != null) {
            p = operationData.getReferences().getPoint();
            o = operationData.getReferences().getOperator();
            d = operationData.getReferences().getDealer();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        if (StateUtil.isCancelled(record.getState(), record.getSubstate())) {
            sb.append("\u0410\u041d\u041d\u0423\u041b\u0418\u0420\u041e\u0412\u0410\u041d\n");
        } else {
            sb.append("\n");
        }
        String[] bank = TableStringUtil.split2CellEmpty(d.getBank(), 25);
        sb.append(bank[0]).append("\n");
        if (!bank[1].isEmpty()) {
            sb.append(bank[1]).append("\n");
        }
        sb.append("\u0418\u041d\u041d ").append(d.getInn()).append("\n");
        String[] agent = TableStringUtil.split2CellEmpty(d.getName(), 25);
        sb.append(agent[0]).append("\n");
        if (!agent[1].isEmpty()) {
            sb.append(agent[1]).append("\n");
        }
        sb.append(this.sdf.format(record.getCreated())).append(" \u2116").append(p == null ? "" : Short.valueOf(p.getId())).append(TableStringUtil.formatInt(record.getDoc(), 5)).append("\n");
        if (s != null && s.getShortName() != null && !s.getShortName().trim().isEmpty()) {
            sb.append(s.getShortName()).append("\n");
        }
        sb.append("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: ").append(SumFormatter.format(record.getSumOutcome())).append("\n");
        sb.append("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0431\u0430\u043d\u043a\u0430: ").append(SumFormatter.format(record.getSumComm())).append("\n");
        sb.append("\u0418\u0442\u043e\u0433\u043e: ").append(SumFormatter.format(record.getSumIncome())).append("\n");
        sb.append("\u041a\u0430\u0441\u0441\u0438\u0440: ").append(operationData.getJob().getOperatorName()).append("\n");
        sb.append("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c: ").append(TableStringUtil.formatLong(record.getCrc(), 10)).append("\n");
        sb.append("\n\n\n\n\n\n");
        if (StateUtil.isCancelled(record.getState(), record.getSubstate())) {
            sb.append("\u0410\u041d\u041d\u0423\u041b\u0418\u0420\u041e\u0412\u0410\u041d\n");
        } else {
            sb.append("\n");
        }
        sb.append(bank[0]).append("\n");
        if (!bank[1].isEmpty()) {
            sb.append(bank[1]).append("\n");
        }
        sb.append("\u0418\u041d\u041d ").append(d.getInn()).append("\n");
        sb.append(agent[0]).append("\n");
        if (!agent[1].isEmpty()) {
            sb.append(agent[1]).append("\n");
        }
        sb.append(this.sdf.format(record.getCreated())).append(" \u2116").append(p == null ? "" : Short.valueOf(p.getId())).append(TableStringUtil.formatInt(record.getDoc(), 5)).append("\n");
        if (s != null && s.getShortName() != null && !s.getShortName().trim().isEmpty()) {
            sb.append(s.getShortName()).append("\n");
        }
        sb.append("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: ").append(SumFormatter.format(record.getSumOutcome())).append("\n");
        sb.append("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0431\u0430\u043d\u043a\u0430: ").append(SumFormatter.format(record.getSumComm())).append("\n");
        sb.append("\u0418\u0442\u043e\u0433\u043e: ").append(SumFormatter.format(record.getSumIncome())).append("\n");
        sb.append("\u041a\u0430\u0441\u0441\u0438\u0440: ").append(operationData.getJob().getOperatorName()).append("\n");
        sb.append("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c: ").append(TableStringUtil.formatLong(record.getCrc(), 10)).append("\n");
        return sb.toString();
    }

    @Override
    public String process(CustomData operationData, int printWidth) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u041d\u0415\u041e\u0411\u0425\u041e\u0414\u0418\u041c\u0410\u042f \u0418\u041d\u0424\u041e\u0420\u041c\u0410\u0426\u0418\u042f\n");
        sb.append("\u0412\u0420\u0415\u041c\u042f: ").append(this.sdf.format(new Date())).append("\n");
        sb.append("\u0421\u0415\u0420\u0412\u0418\u0421: ").append(operationData.getMenuItem().getService().getName()).append("\n");
        sb.append("\n");
        Map<String, Object> items = operationData.getItems();
        for (String key : items.keySet()) {
            if (!(items.get(key) instanceof InputElement)) continue;
            InputElement ie = (InputElement)items.get(key);
            sb.append(ie.getKeyTitle()).append(": ").append(ie.getValueTitle());
        }
        return sb.toString();
    }
}

