/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.render;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.rma.connector.model.Dealer;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.Operator;
import ru.softlogic.rma.connector.model.Point;
import ru.softlogic.rma.connector.model.Service;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;
import ru.softlogic.rma.utils.SumFormatter;

public class BaseKkmRender
implements Render {
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);

    @Override
    public String process(RequestData requestData, int printWidth) {
        if (requestData == null || requestData.getJob().getRecord() == null) {
            return null;
        }
        Record rec = requestData.getJob().getRecord();
        MenuItem mi = requestData.getJob().getMenuItem();
        StringBuilder sb = new StringBuilder();
        sb.append("\u0417\u0410\u042f\u0412\u041a\u0410 \u041d\u0410 \u041e\u0421\u0423\u0429\u0415\u0421\u0422\u0412\u041b\u0415\u041d\u0418\u0415 \u041f\u041b\u0410\u0422\u0415\u0416\u0410").append("\n");
        sb.append("\u0414\u0410\u0422\u0410 \u041e\u041f\u0415\u0420\u0410\u0426\u0418\u0418: ").append(this.dateFormat.format(rec.getCreated())).append("\n");
        sb.append("\u041f\u041e\u041b\u0423\u0427\u0410\u0422\u0415\u041b\u042c: ").append(rec.getServiceName()).append("\n");
        if (mi != null && mi.getService() != null && mi.getService().getLegalName() != null) {
            sb.append(mi.getService().getLegalName()).append("\n");
        }
        sb.append("\u0421\u0423\u041c\u041c\u0410 \u0421 \u041a\u041b\u0418\u0415\u041d\u0422\u0410: ").append(SumFormatter.format(rec.getSumIncome())).append("\n");
        sb.append("\u0421\u0423\u041c\u041c\u0410 \u041d\u0410 \u0421\u0427\u0415\u0422: ").append(SumFormatter.format(rec.getSumOutcome())).append("\n");
        sb.append(rec.getAccountTitle() + ":").append("\n");
        if (rec.getAccountValueTitle().length() <= 15) {
            sb.append("<b>");
        }
        sb.append(rec.getAccountValueTitle()).append("\n");
        sb.append("\n");
        if (rec.getAccount2() != null) {
            sb.append(rec.getAccount2Title() + ":").append("\n");
            if (rec.getAccount2ValueTitle().length() <= 15) {
                sb.append("<b>");
            }
            sb.append(rec.getAccount2ValueTitle()).append("\n");
            sb.append("\n");
        }
        if (rec.getAttributes() != null) {
            for (String key : rec.getAttributes().keySet()) {
                RmaAttribute atr = rec.getAttributes().get(key);
                String title = atr.getKeyTitle();
                String value = atr.getValueTitle();
                sb.append(title == null ? key : title.toUpperCase()).append(": ").append(value).append("\n");
            }
        }
        sb.append("\n");
        sb.append("C \u0420\u0415\u041a\u0412\u0418\u0417\u0418\u0422\u0410\u041c\u0418 \u041f\u041b\u0410\u0422\u0415\u0416\u0410 \u0421\u041e\u0413\u041b\u0410\u0421\u0415\u041d").append("\n").append(" \n").append(" \n").append(" \n");
        String sign = "\u041f\u043e\u0434\u043f\u0438\u0441\u044c_____________";
        int len = printWidth - sign.length();
        for (int i = 0; i < len - 2; ++i) {
            sign = sign + "_";
        }
        sb.append(sign).append("\n");
        return sb.toString();
    }

    @Override
    public String process(OperationData operationData, int printWidth) {
        if (operationData == null || operationData.getJob().getRecord() == null) {
            return null;
        }
        Record rec = operationData.getJob().getRecord();
        MenuItem mi = operationData.getJob().getMenuItem();
        Service s = null;
        if (mi != null) {
            s = mi.getService();
        }
        Point p = null;
        Operator o = null;
        Dealer d = null;
        if (operationData.getReferences() != null) {
            p = operationData.getReferences().getPoint();
            o = operationData.getReferences().getOperator();
            d = operationData.getReferences().getDealer();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u0422\u041e\u0427\u041a\u0410 \u041f\u0420\u0418\u0415\u041c\u0410 \u041f\u041b\u0410\u0422\u0415\u0416\u0415\u0419: ").append(p == null ? "-" : Short.valueOf(p.getId())).append("\n");
        sb.append("\u0410\u0414\u0420\u0415\u0421: ").append(p == null || p.getCityName() == null ? "" : p.getCityName()).append(", ").append(p == null || p.getAddress() == null ? "" : p.getAddress()).append("\n");
        sb.append("\u041d\u041e\u041c\u0415\u0420 \u0414\u041e\u041a\u0423\u041c\u0415\u041d\u0422\u0410: ").append(rec.getDoc()).append("\n");
        sb.append("<b>\u041f\u041e\u0421\u0422\u0410\u0412\u0429\u0418\u041a \u0423\u0421\u041b\u0423\u0413\u0418").append("\n");
        sb.append(s == null || s.getLegalName() == null ? "<\u041d\u0415 \u0423\u041a\u0410\u0417\u0410\u041d>" : s.getLegalName()).append("\n");
        sb.append("\u0418\u041d\u041d: ").append(s == null || s.getInn() == null ? "<\u041d\u0415 \u0423\u041a\u0410\u0417\u0410\u041d>" : s.getInn()).append("\n");
        sb.append("\u0421\u041f\u0420\u0410\u0412\u041e\u0427\u041d\u0410\u042f: ").append(s == null || s.getSupport() == null || s.getSupport().isEmpty() ? "<\u041d\u0415 \u0423\u041a\u0410\u0417\u0410\u041d>" : s.getSupport()).append("\n");
        sb.append("\u0414\u041e\u0413\u041e\u0412\u041e\u0420: ").append(s == null || s.getContractNo() == null || s.getContractNo().isEmpty() ? "<\u041d\u0415 \u0423\u041a\u0410\u0417\u0410\u041d>" : s.getContractNo()).append("\n");
        sb.append("<b>\u041e\u041f\u0415\u0420\u0410\u0422\u041e\u0420").append("\n");
        sb.append(o == null || o.getLegalName() == null || o.getLegalName().isEmpty() ? "<\u041d\u0415 \u0423\u041a\u0410\u0417\u0410\u041d>" : o.getLegalName()).append("\n");
        sb.append("\u0421\u041f\u0420\u0410\u0412\u041e\u0427\u041d\u0410\u042f \u0410\u0413\u0415\u041d\u0422\u0410 \u041f\u041e \u041f\u0420\u0418\u0415\u041c\u0423 \u041f\u041b\u0410\u0422\u0415\u0416\u0415\u0419: \n");
        sb.append("  ").append(d == null || d.getSupport() == null || d.getSupport().isEmpty() ? "<\u041d\u0415 \u0423\u041a\u0410\u0417\u0410\u041d>" : d.getSupport()).append("\n");
        sb.append("  \u0420\u0415\u0416\u0418\u041c \u0420\u0410\u0411\u041e\u0422\u042b: ").append(d == null || d.getSupportWorkTime() == null || d.getSupportWorkTime().isEmpty() ? "<\u041d\u0415 \u0423\u041a\u0410\u0417\u0410\u041d>" : d.getSupportWorkTime()).append("\n");
        sb.append("\u0421\u041f\u0420\u0410\u0412\u041e\u0427\u041d\u0410\u042f \u041f\u041b\u0410\u0422\u0415\u0416\u041d\u041e\u0419 \u0421\u0418\u0421\u0422\u0415\u041c\u042b: \n");
        sb.append("  ").append(o == null || o.getSupport() == null || o.getSupport().isEmpty() ? "<\u041d\u0415 \u0423\u041a\u0410\u0417\u0410\u041d>" : o.getSupport()).append("\n");
        sb.append(rec.getAccountTitle().toUpperCase() + ": ").append(rec.getAccountValueTitle()).append("\n");
        if (rec.getAccount2() != null) {
            sb.append(rec.getAccount2Title().toUpperCase() + ": ").append(rec.getAccount2ValueTitle()).append("\n");
        }
        if (rec.getAttributes() != null) {
            for (String key : rec.getAttributes().keySet()) {
                RmaAttribute atr = rec.getAttributes().get(key);
                String title = atr.getKeyTitle();
                String value = atr.getValueTitle();
                sb.append(title == null ? key : title.toUpperCase()).append(": ").append(value).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String process(CustomData operationData, int printWidth) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u041d\u0415\u041e\u0411\u0425\u041e\u0414\u0418\u041c\u0410\u042f \u0418\u041d\u0424\u041e\u0420\u041c\u0410\u0426\u0418\u042f<br>");
        sb.append("\u0412\u0420\u0415\u041c\u042f: ").append(this.dateFormat.format(new Date())).append("<br>");
        sb.append("\u0421\u0415\u0420\u0412\u0418\u0421: ").append(operationData.getMenuItem().getService().getName()).append("<br>");
        sb.append("<br>");
        Map<String, Object> items = operationData.getItems();
        for (String key : items.keySet()) {
            if (!(items.get(key) instanceof InputElement)) continue;
            InputElement ie = (InputElement)items.get(key);
            sb.append(ie.getKeyTitle()).append(": ").append(ie.getValueTitle()).append("<br>");
        }
        return sb.toString();
    }
}

