/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.render;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.rma.connector.model.Dealer;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.Operator;
import ru.softlogic.rma.connector.model.Point;
import ru.softlogic.rma.connector.model.Service;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;
import ru.softlogic.rma.utils.StateUtil;
import ru.softlogic.rma.utils.SumFormatter;
import ru.softlogic.rma.utils.TableStringUtil;

public class BaseIppRender
implements Render {
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);

    @Override
    public String process(RequestData requestData, int printWidth) {
        if (requestData == null || requestData.getJob().getRecord() == null) {
            return null;
        }
        Record rec = requestData.getJob().getRecord();
        MenuItem mi = requestData.getJob().getMenuItem();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("    <META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"text/html; charset=utf-8\"/>\n");
        sb.append("    <STYLE TYPE=\"text/css\">\n");
        sb.append("    <!--\n");
        sb.append("        @page { size: A4;margin-right: 0.44in; margin-top: 1in; margin-bottom: 0.5in }\n");
        sb.append("                .main{width: 630mm;height:891mm;}\n");
        sb.append("                .stamp {font-size: 34pt;margin:0;}\n");
        sb.append("                #stamp1{width:345mm;position:absolute;top:100px;left:18mm;}\n");
        sb.append("    -->\n");
        sb.append("    </STYLE>\n");
        sb.append("</head>\n");
        sb.append("<body TEXT=\"#000000\">\n");
        sb.append("<div class=\"main\">\n");
        sb.append("<div id=\"stamp1\">\n");
        sb.append("  <p class=\"stamp\">\u0417\u0410\u042f\u0412\u041a\u0410 \u041d\u0410 \u041e\u0421\u0423\u0429\u0415\u0421\u0422\u0412\u041b\u0415\u041d\u0418\u0415 \u041f\u041b\u0410\u0422\u0415\u0416\u0410</p>\n");
        sb.append("  <p class=\"stamp\">\u0414\u0410\u0422\u0410 \u041e\u041f\u0415\u0420\u0410\u0426\u0418\u0418: ").append(this.dateFormat.format(rec.getCreated())).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u041f\u041e\u041b\u0423\u0427\u0410\u0422\u0415\u041b\u042c: ").append(rec.getServiceName()).append("</p>\n");
        if (mi != null && mi.getService() != null) {
            sb.append("  <p class=\"stamp\">").append(mi.getService().getLegalName()).append("</p>\n");
        }
        sb.append("  <p class=\"stamp\">\u0421\u0423\u041c\u041c\u0410 \u0421 \u041a\u041b\u0418\u0415\u041d\u0422\u0410: ").append(SumFormatter.format(rec.getSumIncome())).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u0421\u0423\u041c\u041c\u0410 \u041d\u0410 \u0421\u0427\u0415\u0422: ").append(SumFormatter.format(rec.getSumOutcome())).append("</p>\n");
        sb.append("  <p class=\"stamp\">").append(rec.getAccountTitle()).append(" : ").append(rec.getAccountValueTitle()).append("</p>\n");
        if (rec.getAccount2() != null) {
            sb.append("  <p class=\"stamp\">").append(rec.getAccount2Title()).append(" : ").append(rec.getAccount2ValueTitle()).append("</p>\n");
        }
        if (rec.getAttributes() != null) {
            for (String key : rec.getAttributes().keySet()) {
                RmaAttribute atr = rec.getAttributes().get(key);
                String title = atr.getKeyTitle();
                String value = atr.getValueTitle();
                sb.append("  <p class=\"stamp\">").append(title == null ? key : title.toUpperCase()).append(" : ").append(value).append("</p>\n");
            }
        }
        sb.append("<br>\n");
        sb.append("  <p class=\"stamp\">C \u0420\u0415\u041a\u0412\u0418\u0417\u0418\u0422\u0410\u041c\u0418 \u041f\u041b\u0410\u0422\u0415\u0416\u0410 \u0421\u041e\u0413\u041b\u0410\u0421\u0415\u041d").append("<br>").append(" <br>").append(" <br>").append(" <br>");
        String sign = "\u041f\u043e\u0434\u043f\u0438\u0441\u044c_____________";
        int len = printWidth - sign.length();
        for (int i = 0; i < len - 2; ++i) {
            sign = sign + "_";
        }
        sb.append(sign).append("</p>\n");
        sb.append("</div>\n");
        sb.append("</div>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }

    @Override
    public String process(OperationData operationData, int printWidth) {
        String value;
        String title;
        RmaAttribute atr;
        if (operationData == null || operationData.getJob().getRecord() == null) {
            return null;
        }
        Record record = operationData.getJob().getRecord();
        MenuItem mi = operationData.getJob().getMenuItem();
        Service s = null;
        if (mi != null) {
            s = mi.getService();
        }
        Point p = null;
        Operator o = null;
        Dealer d = null;
        if (operationData.getReferences() != null) {
            p = operationData.getReferences().getPoint();
            o = operationData.getReferences().getOperator();
            d = operationData.getReferences().getDealer();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("    <META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"text/html; charset=utf-8\"/>\n");
        sb.append("    <STYLE TYPE=\"text/css\">\n");
        sb.append("    <!--\n");
        sb.append("        @page { size: A4;margin-right: 0.44in; margin-top: 1in; margin-bottom: 0.5in }\n");
        sb.append("        .main{width: 630mm;height:891mm;}\n");
        sb.append("        .stamp {font-family: Liberation Sans, Arial;font-size: 24pt;margin:0;}\n");
        sb.append("        #stamp1{width:145mm;position:absolute;overflow:hidden;top:140px;left:18mm;}\n");
        sb.append("        #stamp2{width:145mm;position:absolute;overflow:hidden;top:1800px;left:18mm;}\n");
        sb.append("    -->\n");
        sb.append("    </STYLE>\n");
        sb.append("</head>\n");
        sb.append("<body TEXT=\"#000000\">\n");
        sb.append("<div class=\"main\">\n");
        sb.append("<div id=\"stamp1\">\n");
        if (StateUtil.isCancelled(record.getState(), record.getSubstate())) {
            sb.append("  <p class=\"stamp\">\u0410\u041d\u041d\u0423\u041b\u0418\u0420\u041e\u0412\u0410\u041d</p>\n");
        }
        sb.append("  <p class=\"stamp\">").append(d.getBank()).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u0418\u041d\u041d ").append(d.getInn()).append("</p>\n");
        sb.append("  <p class=\"stamp\">").append(d.getName()).append("</p>\n");
        sb.append("  <p class=\"stamp\">").append(this.dateFormat.format(record.getCreated())).append(" \u2116");
        if (p != null) {
            sb.append(p.getId());
        }
        sb.append(TableStringUtil.formatInt(record.getDoc(), 5)).append("</p>\n");
        if (s != null && s.getShortName() != null && !s.getShortName().trim().isEmpty()) {
            sb.append("  <p class=\"stamp\">").append(s.getShortName()).append("</p>\n");
        }
        sb.append("  <p class=\"stamp\">C\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: ").append(SumFormatter.format(record.getSumOutcome())).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0431\u0430\u043d\u043a\u0430: ").append(SumFormatter.format(record.getSumComm())).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u0418\u0442\u043e\u0433\u043e: ").append(SumFormatter.format(record.getSumIncome())).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u041a\u0430\u0441\u0441\u0438\u0440: ").append(operationData.getJob().getOperatorName()).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c: ").append(TableStringUtil.formatLong(record.getCrc(), 10)).append("</p>\n");
        if (record.getAttributes() != null) {
            for (String key : record.getAttributes().keySet()) {
                atr = record.getAttributes().get(key);
                title = atr.getKeyTitle();
                value = atr.getValueTitle();
                sb.append("  <p class=\"stamp\">").append(title == null ? key : title.toUpperCase()).append(" : ").append(value).append("</p>\n");
            }
        }
        sb.append("</div>\n");
        sb.append("<div id=\"stamp2\">\n");
        if (StateUtil.isCancelled(record.getState(), record.getSubstate())) {
            sb.append("  <p class=\"stamp\">\u0410\u041d\u041d\u0423\u041b\u0418\u0420\u041e\u0412\u0410\u041d</p>\n");
        }
        sb.append("  <p class=\"stamp\">").append(d.getBank()).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u0418\u041d\u041d ").append(d.getInn()).append("</p>\n");
        sb.append("  <p class=\"stamp\">").append(d.getName()).append("</p>\n");
        sb.append("  <p class=\"stamp\">").append(this.dateFormat.format(record.getCreated())).append(" \u2116");
        if (p != null) {
            sb.append(p.getId());
        }
        sb.append(TableStringUtil.formatInt(record.getDoc(), 5)).append("</p>\n");
        if (s != null && s.getShortName() != null && !s.getShortName().trim().isEmpty()) {
            sb.append("  <p class=\"stamp\">").append(s.getShortName()).append("</p>\n");
        }
        sb.append("  <p class=\"stamp\">C\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: ").append(SumFormatter.format(record.getSumOutcome())).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0431\u0430\u043d\u043a\u0430: ").append(SumFormatter.format(record.getSumComm())).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u0418\u0442\u043e\u0433\u043e: ").append(SumFormatter.format(record.getSumIncome())).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u041a\u0430\u0441\u0441\u0438\u0440: ").append(operationData.getJob().getOperatorName()).append("</p>\n");
        sb.append("  <p class=\"stamp\">\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c: ").append(TableStringUtil.formatLong(record.getCrc(), 10)).append("</p>\n");
        if (record.getAttributes() != null) {
            for (String key : record.getAttributes().keySet()) {
                atr = record.getAttributes().get(key);
                title = atr.getKeyTitle();
                value = atr.getValueTitle();
                sb.append("  <p class=\"stamp\">").append(title == null ? key : title.toUpperCase()).append(" : ").append(value).append("</p>\n");
            }
        }
        sb.append("</div>\n");
        sb.append("</div>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }

    @Override
    public String process(CustomData operationData, int printWidth) {
        if (operationData == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("    <META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"text/html; charset=utf-8\"/>\n");
        sb.append("    <STYLE TYPE=\"text/css\">\n");
        sb.append("    <!--\n");
        sb.append("        @page { size: A4;margin-right: 0.44in; margin-top: 1in; margin-bottom: 0.5in }\n");
        sb.append("                .main{width: 630mm;height:891mm;}\n");
        sb.append("                .stamp {font-size: 38pt;margin:0;}\n");
        sb.append("                #stamp1{width:145mm;position:absolute;overflow:hidden;top:140px;left:18mm;}\n");
        sb.append("    -->\n");
        sb.append("    </STYLE>\n");
        sb.append("</head>\n");
        sb.append("<body TEXT=\"#000000\">\n");
        sb.append("<div class=\"main\">\n");
        sb.append("<div id=\"stamp1\">\n");
        sb.append("  <p class=\"stamp\">$dealer.getName()</p>\n");
        sb.append("<b>\u041d\u0415\u041e\u0411\u0425\u041e\u0414\u0418\u041c\u0410\u042f \u0418\u041d\u0424\u041e\u0420\u041c\u0410\u0426\u0418\u042f</b><br>");
        sb.append("\u0412\u0420\u0415\u041c\u042f: ").append(this.dateFormat.format(new Date())).append("<br>");
        sb.append("\u0421\u0415\u0420\u0412\u0418\u0421: ").append(operationData.getMenuItem().getService().getName()).append("<br>");
        sb.append("<hr>");
        Map<String, Object> items = operationData.getItems();
        for (String key : items.keySet()) {
            if (!(items.get(key) instanceof InputElement)) continue;
            InputElement ie = (InputElement)items.get(key);
            sb.append(ie.getKeyTitle()).append(": ").append(ie.getValueTitle());
        }
        sb.append("</div>\n");
        sb.append("</div>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return sb.toString();
    }
}

