/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.mercury;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.print.PrintMode;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.Kkm;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ReportResult;
import ru.softlogic.rma.print.kkm.ShiftInfoResult;
import ru.softlogic.rma.print.kkm.mercury.ExResult;
import ru.softlogic.rma.print.kkm.mercury.MercuryApi;
import ru.softlogic.rma.print.kkm.mercury.Operation;
import ru.softlogic.rma.print.kkm.mercury.resources.MercuryBundle;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.kkm.render.RenderFactory;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.DocumentData;
import ru.softlogic.rma.print.queue.DocumentType;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;

public class MercuryKkm
implements Kkm {
    private Logger log;
    MercuryApi api;
    private int scroll;
    private int purchaseSection;
    private int interestSection;
    private ResourceBundle bundle;

    public MercuryKkm(SerialPort port) {
        this.api = new MercuryApi(port);
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.setScroll(0);
        this.setPurchaseSection(1);
        this.setInterestSection(2);
        this.bundle = ResourceBundle.getBundle("ru.softlogic.rma.print.kkm.kkm");
    }

    @Override
    public String getInfo() throws IOException {
        String info;
        ExResult exres = this.api.requestInfo();
        System.out.println("->" + exres);
        StringBuilder sb = new StringBuilder();
        if (exres.getParams().size() > 1) {
            sb.append("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: ").append(exres.getParams().get(1)).append("\n");
        }
        if (exres.getParams().size() > 0) {
            sb.append("\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440: ").append(exres.getParams().get(0)).append("\n");
        }
        if (exres.getParams().size() > 2) {
            sb.append("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c: ").append(exres.getParams().get(2)).append("\n");
        }
        if (exres.getParams().size() > 3) {
            sb.append("\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e: ").append(exres.getParams().get(3)).append("\n");
        }
        return (info = sb.toString()).isEmpty() ? "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430" : info;
    }

    @Override
    public ReportResult formReportX() throws IOException {
        ExResult res = this.api.reportX();
        this.log.info((Object)("ReportX: " + res));
        if ("0000".equals(res.getExresult())) {
            return new ReportResult(0, false, "");
        }
        return new ReportResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()));
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        ExResult res = this.api.reportZ();
        this.log.info((Object)("ReportZ: " + res));
        if ("0000".equals(res.getExresult())) {
            return new ReportResult(0, false, "");
        }
        return new ReportResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()));
    }

    @Override
    public ReportResult reset() throws IOException {
        return new ReportResult(0, false, "");
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public void setScroll(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Wrog scroll value");
        }
        this.scroll = 5 + value;
    }

    @Override
    public void setPurchaseSection(int section) {
        this.purchaseSection = section;
    }

    @Override
    public void setInterestSection(int section) {
        this.interestSection = section;
    }

    @Override
    public OperationResult printRequest(RequestData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        this.log.info((Object)"==================== \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0437\u0430\u044f\u043a\u0443 ====================");
        ExResult res = null;
        Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.Mercury);
        String image = render.process(data, this.api.getPrintWidth()).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String prn = m.group(0);
            if (prn.startsWith("<b>")) {
                sb.append(prn.replace("<b>", ""));
            } else {
                sb.append(prn);
            }
            sb.append('\n');
        }
        this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + sb.toString()));
        res = this.api.printNotFiscal(sb.toString());
        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
        if (!"0000".equals(res.getExresult())) {
            return new OperationResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()), data.getJob());
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            res = this.api.feedCheck(this.scroll);
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
            if ("0000".equals(res.getExresult())) {
                return new OperationResult(0, false, "", data.getJob());
            }
            return new OperationResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()), data.getJob());
        }
        return new OperationResult(0, false, "", data.getJob());
    }

    @Override
    public OperationResult printDocument(OperationData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        if (data.getJob().getRecord() == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Record");
        }
        Record record = data.getJob().getRecord();
        this.log.info((Object)"Begin------------------------------------------------------");
        ExResult res = null;
        StringBuilder sbpre = new StringBuilder();
        if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
            this.log.info((Object)("\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e \u0440\u0435\u043a\u043b\u0430\u043c\u0443: " + data.getJob().getBeginAdvText()));
            String image = data.getJob().getBeginAdvText().trim();
            Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                if (prn.startsWith("<b>")) {
                    sbpre.append(prn.replace("<b>", ""));
                } else {
                    sbpre.append(prn);
                }
                sbpre.append("\n");
            }
        }
        StringBuilder sbpost = new StringBuilder();
        Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.ShtrihM);
        String image = render.process(data, this.api.getPrintWidth()).replace("<br>", "\n");
        if (data.getJob().getEndAdvText() != null && data.getJob().getEndAdvText().isEmpty()) {
            image = image + data.getJob().getEndAdvText().trim();
        }
        Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            if (prn.startsWith("<b>")) {
                sbpost.append(prn.replace("<b>", ""));
            } else {
                sbpost.append(prn);
            }
            sbpost.append("\n");
        }
        if (data.getJob().getPrintMode() == PrintMode.PrintCheckBack) {
            if (record.getSumIncome() > 0) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0442\u043e\u0432\u0430\u0440\u0430");
                res = this.api.printFiscal(Operation.Return, record.getServiceName(), record.getSumIncome(), 1, this.purchaseSection, null, 0, this.interestSection, sbpre.toString(), sbpost.toString());
                this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
                if ("0000".equals(res.getExresult())) {
                    return new OperationResult(0, false, "", data.getJob());
                }
                if ("0002".equals(res.getExresult())) {
                    return new OperationResult(1, true, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()));
                }
                return new OperationResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()), data.getJob());
            }
        } else {
            if (record.getSumComm() > 0) {
                String comm = this.bundle.getString("comission");
                if (comm == null) {
                    comm = "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f";
                }
                res = this.api.printFiscal(Operation.Sale, record.getServiceName(), record.getSumOutcome(), 1, this.purchaseSection, comm, record.getSumComm(), this.interestSection, sbpre.toString(), sbpost.toString());
            } else {
                res = this.api.printFiscal(Operation.Sale, record.getServiceName(), record.getSumOutcome(), 1, this.purchaseSection, null, 0, this.interestSection, sbpre.toString(), sbpost.toString());
            }
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
            if ("0000".equals(res.getExresult())) {
                return new OperationResult(0, false, "", data.getJob());
            }
            if ("0002".equals(res.getExresult())) {
                return new OperationResult(1, true, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()));
            }
            return new OperationResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()), data.getJob());
        }
        return new OperationResult(0, false, false, "");
    }

    @Override
    public OperationResult printDocument(DocumentData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        if (data.getType() == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DocumentType");
        }
        if (data.getSum() <= 0) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u0441\u0443\u043c\u043c\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
        }
        if (data.getCount() <= 0) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435");
        }
        this.log.info((Object)"Begin------------------------------------------------------");
        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a: " + data));
        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430");
        ExResult res = this.api.printFiscal(data.getType() == DocumentType.Sale ? Operation.Sale : Operation.Return, data.getName() != null ? data.getName() : "\u0422\u043e\u0432\u0430\u0440", data.getSum(), data.getCount(), this.purchaseSection, null, 0, this.interestSection, "", "");
        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
        if ("0000".equals(res.getExresult())) {
            return new OperationResult(0, false, false, "");
        }
        if ("0002".equals(res.getExresult())) {
            return new OperationResult(1, true, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()));
        }
        return new OperationResult(1, true, false, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()));
    }

    @Override
    public OperationResult printDocumentNotFiscalMode(OperationData data) throws IOException {
        this.log.info((Object)"==================== \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0432 \u043d\u0435 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u043c \u0440\u0435\u0436\u0438\u043c\u0435 ====================");
        ExResult res = null;
        StringBuilder sb = new StringBuilder();
        if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
            this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0440\u0435\u043a\u043b\u0430\u043c\u0443: " + data.getJob().getBeginAdvText()));
            String image = data.getJob().getBeginAdvText().trim();
            Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                if (prn.startsWith("<b>")) {
                    sb.append(prn.replace("<b>", ""));
                } else {
                    sb.append(prn);
                }
                sb.append('\n');
            }
        }
        Render render = RenderFactory.createRenderCopy(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() + ".copy" : null, KkmType.ShtrihM);
        String image = render.process(data, this.api.getPrintWidth()).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            if (prn.startsWith("<b>")) {
                sb.append(prn.replace("<b>", ""));
            } else {
                sb.append(prn);
            }
            sb.append('\n');
        }
        this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + sb.toString()));
        res = this.api.printNotFiscal(sb.toString());
        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
        if (!"0000".equals(res.getExresult())) {
            return new OperationResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()), data.getJob());
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            res = this.api.feedCheck(this.scroll);
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
            if ("0000".equals(res.getExresult())) {
                return new OperationResult(0, false, "", data.getJob());
            }
            return new OperationResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()), data.getJob());
        }
        return new OperationResult(0, false, "", data.getJob());
    }

    @Override
    public CustomOperationResult printCustomNotFiscalMode(CustomData data) throws IOException {
        if (data == null) {
            return new CustomOperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        this.log.info((Object)"==================== \u041f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u0430\u044f \u043f\u0435\u0447\u0430\u0442\u044c ====================");
        ExResult res = null;
        StringBuilder sb = new StringBuilder();
        Render render = RenderFactory.createRender(data.getTemplate(), KkmType.ShtrihM);
        String image = render.process(data, this.api.getPrintWidth()).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1," + this.api.getPrintWidth() + "}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            if (prn.startsWith("<b>")) {
                sb.append(prn.replace("<b>", ""));
            } else {
                sb.append(prn);
            }
            this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
        }
        this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + sb.toString()));
        res = this.api.printNotFiscal(sb.toString());
        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
        if (!"0000".equals(res.getExresult())) {
            return new CustomOperationResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()), data);
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            res = this.api.feedCheck(this.scroll);
            this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + res));
            if ("0000".equals(res.getExresult())) {
                return new CustomOperationResult(0, false, "", data);
            }
            return new CustomOperationResult(1, true, "\u041e\u0448\u0438\u0431\u043a\u0430: " + MercuryBundle.getMessage(res.getExresult()), data);
        }
        return new CustomOperationResult(0, false, "", data);
    }

    @Override
    public ShiftInfoResult printShiftInfoResult(ShiftOperatingPrintRequest req) throws IOException {
        this.log.error((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        throw new IllegalStateException("\u041f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }
}

