/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.mercury;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.rma.print.kkm.mercury.Result;
import ru.softlogic.rma.utils.ByteUtils;

public class MercuryConnection {
    private final byte STX = (byte)2;
    private final byte ETX = (byte)3;
    private final int TIMEOUT_T1 = 1500;
    private final int TIMEOUT_T3 = 500;
    private final int MAX_LEN = 2048;
    private int readAttempts = 5;
    private int attempts = 3;
    private SerialPort port;
    private Logger log;

    public MercuryConnection(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("Need com-port");
        }
        this.port = port;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public void open() throws IOException {
        this.port.open();
    }

    public void \u0441lose() throws IOException {
        this.port.close();
    }

    public Result sendComand(byte com, byte[] pass, byte[] data) throws IOException {
        if (pass == null || pass.length != 4) {
            throw new IllegalArgumentException("Password incorrect");
        }
        IOException last = null;
        byte[] message = this.getMessage(com, pass, data);
        for (int i = 0; i < this.readAttempts; ++i) {
            try {
                this.port.setTimeout(1500);
                this.log.debug((Object)(">>" + ByteUtils.toString(message)));
                this.port.write(message);
                Result res = this.readData(com);
                if (res.getResult() == 1) {
                    throw new IOException("\u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u041a\u041a\u041c: " + res);
                }
                return res;
            }
            catch (IOException ex) {
                this.log.error((Object)ex, (Throwable)ex);
                last = ex;
                continue;
            }
        }
        throw last;
    }

    private byte[] verifyData(byte[] src) {
        this.log.info((Object)("Ver: " + Arrays.toString(src)));
        if (src == null || src.length < 3) {
            return null;
        }
        byte b = 0;
        for (int i = 0; i < src.length - 2; ++i) {
            b = (byte)(b + src[i]);
        }
        String crc = String.format("%1$2h", b).replace(' ', '0');
        if ((crc = crc.substring(crc.length() - 2)).charAt(0) == src[src.length - 2] && crc.charAt(1) == src[src.length - 1]) {
            return Arrays.copyOf(src, src.length - 2);
        }
        this.log.error((Object)("CRC incorrect. In Mess: " + src[src.length - 2] + " " + src[src.length - 1] + ". Must be:  " + (byte)crc.charAt(0) + " " + (byte)crc.charAt(1)));
        return null;
    }

    private Result readData(byte b) {
        try {
            int rb;
            int count;
            this.port.setTimeout(500);
            for (count = 0; (rb = this.port.readByte()) != 2 && count < 2048; ++count) {
            }
            if (rb == 2) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((rb = this.port.readByte()) != 3 && count < 2048) {
                    ++count;
                    baos.write(rb);
                }
                baos.close();
                if (rb == 3) {
                    byte[] data = this.verifyData(baos.toByteArray());
                    if (data == null || data.length < 2) {
                        throw new IOException("Error response");
                    }
                    if (data[0] != b) {
                        throw new IOException("Error command response" + Arrays.toString(data));
                    }
                    return new Result(0, data);
                }
                throw new IOException("ETX not readed");
            }
            throw new IOException("STX not readed");
        }
        catch (IOException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return new Result(1);
        }
    }

    private byte[] getMessage(byte cmd, byte[] pass, byte[] data) {
        int size = 9;
        if (data != null) {
            size += data.length;
        }
        byte[] mess = new byte[size];
        mess[0] = 2;
        mess[1] = cmd;
        System.arraycopy(pass, 0, mess, 2, pass.length);
        if (data != null) {
            System.arraycopy(data, 0, mess, 6, data.length);
        }
        byte b = 0;
        for (int i = 1; i < size - 3; ++i) {
            b = (byte)(b + mess[i]);
        }
        String crc = String.format("%1$2h", b).replace(' ', '0');
        crc = crc.substring(crc.length() - 2);
        this.log.info((Object)("CRC: " + crc));
        mess[size - 3] = (byte)crc.charAt(0);
        mess[size - 2] = (byte)crc.charAt(1);
        mess[size - 1] = 3;
        this.log.info((Object)("Mess: " + Arrays.toString(mess)));
        return mess;
    }

    void sendDataByte(byte[] data) throws IOException {
        this.port.write(data);
    }

    void readtrash() throws IOException {
        for (int count = 0; this.port.avaliable() > 0 && count < 2048; ++count) {
            this.port.read();
        }
        if (this.port.avaliable() > 0) {
            throw new IOException("Max limit");
        }
    }
}

