/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.mercury;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.NoSuchDeviceException;
import ru.softlogic.rma.print.kkm.SerialDeviceApi;
import ru.softlogic.rma.print.kkm.mercury.ExResult;
import ru.softlogic.rma.print.kkm.mercury.MercuryConnection;
import ru.softlogic.rma.print.kkm.mercury.Operation;
import ru.softlogic.rma.utils.SumFormatter;

public class MercuryApi
implements SerialDeviceApi {
    private SerialPort serialPort;
    private Map<Boolean, SerialParams[]> serialParams;
    private Logger log;
    private MercuryConnection conn;
    private byte[] pass = new byte[]{48, 48, 48, 48};

    public MercuryApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("Need SerialPort");
        }
        this.serialPort = port;
        this.conn = new MercuryConnection(port);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(4800, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(2400, DataBits.Eight, StopBits.One, Parity.None)});
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void look(boolean preferred) throws NoSuchDeviceException {
        for (SerialParams params : this.serialParams.get(preferred)) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            try {
                this.serialPort.putParams(params);
                this.open();
                this.requestInfo();
                return;
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
            }
        }
        throw new NoSuchDeviceException("\u041c\u0435\u0440\u043a\u0443\u0440\u0438\u0439 MS-K \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d \u043d\u0430 " + this.serialPort.getName());
    }

    @Override
    public KkmType getKkmType() {
        return KkmType.Mercury;
    }

    @Override
    public void open() throws IOException {
        this.conn.open();
    }

    @Override
    public void close() {
        try {
            this.conn.\u0441lose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ExResult reportX() throws IOException {
        ExResult result = new ExResult(this.conn.sendComand((byte)95, this.pass, this.params2Bytes("1", "03", "00")));
        if ("000d".equals(result.getExresult())) {
            result = this.regKass();
            if ("0000".equals(result.getExresult())) {
                return new ExResult(this.conn.sendComand((byte)95, this.pass, this.params2Bytes("1", "03", "00")));
            }
            return result;
        }
        return result;
    }

    public ExResult reportZ() throws IOException {
        ExResult result = new ExResult(this.conn.sendComand((byte)95, this.pass, this.params2Bytes("0", "03", "00")));
        if ("000d".equals(result.getExresult())) {
            result = this.regKass();
            if ("0000".equals(result.getExresult())) {
                return new ExResult(this.conn.sendComand((byte)95, this.pass, this.params2Bytes("0", "03", "00")));
            }
            return result;
        }
        return result;
    }

    public ExResult regKass() throws IOException {
        return new ExResult(this.conn.sendComand((byte)49, this.pass, this.params2Bytes("00", "\u041a\u0430\u0441\u0441\u0438\u0440 1")));
    }

    public ExResult printNotFiscal(String src) throws IOException {
        byte[] bts = src.getBytes("Cp866");
        ExResult result = new ExResult(this.conn.sendComand((byte)54, this.pass, this.params2Bytes(new String[0])));
        if (!"0000".equals(result.getExresult())) {
            return result;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(bts);
        baos.write(13);
        baos.write(10);
        baos.write(27);
        baos.write(27);
        baos.close();
        this.conn.sendDataByte(baos.toByteArray());
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn.readtrash();
        return result;
    }

    public byte[] params2Bytes(String ... params) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(0);
        for (String s : params) {
            baos.write(s.getBytes("Cp866"));
            baos.write(0);
        }
        baos.close();
        return baos.toByteArray();
    }

    public byte[] params2Bytes(List<String> params) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(0);
        for (String s : params) {
            baos.write(s.getBytes("Cp866"));
            baos.write(0);
        }
        baos.close();
        return baos.toByteArray();
    }

    public ExResult requestInfo() throws IOException {
        ExResult result = new ExResult(this.conn.sendComand((byte)69, this.pass, this.params2Bytes("0")));
        if ("000d".equals(result.getExresult())) {
            result = this.regKass();
            if ("0000".equals(result.getExresult())) {
                return new ExResult(this.conn.sendComand((byte)69, this.pass, this.params2Bytes("0")));
            }
            return result;
        }
        return result;
    }

    int getPrintWidth() {
        return 40;
    }

    ExResult feedCheck(int scroll) throws IOException {
        return new ExResult(new ExResult(this.conn.sendComand((byte)82, this.pass, this.params2Bytes("03", "01"))));
    }

    ExResult printFiscal(Operation operation, String serviceName, int sumOut, int count, int ps, String comm, int sumCom, int is, String prefText, String postText) throws IOException {
        byte[] data = this.params2Bytes(this.getFiscalParams(operation, serviceName, sumOut, count, ps, comm, sumCom, is, prefText, postText));
        ExResult result = new ExResult(new ExResult(this.conn.sendComand((byte)83, this.pass, data)));
        if ("000d".equals(result.getExresult())) {
            result = this.regKass();
            if ("0000".equals(result.getExresult())) {
                return new ExResult(new ExResult(this.conn.sendComand((byte)83, this.pass, data)));
            }
            return result;
        }
        return result;
    }

    List<String> getFiscalParams(Operation operation, String serviceName, int sumOut, int count, int ps, String comm, int sumCom, int is, String prefText, String postText) {
        LinkedList<String> list = new LinkedList<String>();
        list.add("" + (char)operation.getType());
        list.add("14");
        String[] split1 = prefText.split("\n");
        String[] split2 = postText.split("\n");
        int countRec = operation == Operation.Sale ? 16 : 14;
        list.add(this.formatToLen("" + (countRec + split1.length + split2.length), 3));
        int pos = 0;
        for (String s : split1) {
            list.add("99");
            list.add("0020");
            list.add("0\u0000");
            list.add(this.formatToLen("" + pos, 3));
            list.add("\u0000\u0000\u0000\u0000\u0000" + this.formatToLen(s, 40));
            ++pos;
        }
        list.add("01");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ++pos;
        list.add("02");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ++pos;
        list.add("03");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ++pos;
        list.add("04");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ++pos;
        list.add("99");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000========================================");
        ++pos;
        list.add("00");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        list.add("10");
        list.add("0020");
        list.add(this.formatToLen("" + this.getPrintWidth() / 2, 2));
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ++pos;
        list.add("05");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ++pos;
        list.add("07");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        list.add("08");
        list.add("0020");
        list.add(this.formatToLen("" + this.getPrintWidth() / 2, 2));
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u000011\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ++pos;
        list.add("06");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ++pos;
        list.add("99");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000" + this.formatToLen(serviceName, 40));
        ++pos;
        list.add("11");
        list.add("0022");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add(this.formatToLen("" + ps, 3) + this.formatToLen("0", 13) + this.formatToLen("1.00", 12) + this.formatToLen(SumFormatter.format(sumOut), 12) + this.formatToLen("", 5));
        ++pos;
        if (comm != null) {
            list.add("99");
            list.add("0020");
            list.add("0\u0000");
            list.add(this.formatToLen("" + pos, 3));
            list.add("\u0000\u0000\u0000\u0000\u0000" + this.formatToLen(comm, 40));
            ++pos;
            list.add("11");
            list.add("0022");
            list.add("0\u0000");
            list.add(this.formatToLen("" + pos, 3));
            list.add(this.formatToLen("" + is, 3) + this.formatToLen("0", 13) + this.formatToLen(SumFormatter.format((double)count), 12) + this.formatToLen(SumFormatter.format(sumCom), 12) + this.formatToLen("", 5));
            ++pos;
        }
        list.add("12");
        list.add("0020");
        list.add("0\u0000");
        list.add(this.formatToLen("" + pos, 3));
        list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        ++pos;
        if (operation == Operation.Sale) {
            list.add("13");
            list.add("0020");
            list.add("0\u0000");
            list.add(this.formatToLen("" + pos, 3));
            list.add("\u0000\u0000\u0000\u0000\u0000" + this.formatToLen(SumFormatter.format(sumOut + sumCom), 40));
            ++pos;
            list.add("14");
            list.add("0020");
            list.add("0\u0000");
            list.add(this.formatToLen("" + pos, 3));
            list.add("\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
            ++pos;
        }
        for (String s : split2) {
            list.add("99");
            list.add("0020");
            list.add("0\u0000");
            list.add(this.formatToLen("" + pos, 3));
            list.add("\u0000\u0000\u0000\u0000\u0000" + this.formatToLen(s, 40));
            ++pos;
        }
        return list;
    }

    String formatToLen(String s, int len) {
        if (s.length() >= len) {
            return s.substring(0, len);
        }
        return s + String.format("%1$" + (len - s.length()) + "s", " ").replace(' ', '\u0000');
    }
}

