/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.mercury;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import ru.softlogic.rma.print.kkm.mercury.Result;

public class ExResult
extends Result {
    private String status;
    private String exresult;
    private String statusprn;
    private List<String> params;

    public ExResult(Result res) {
        super(res.getResult(), res.getData());
        this.parseParams(res.getData());
    }

    public ExResult(int result, byte[] data) {
        super(result, data);
        this.parseParams(data);
    }

    public ExResult(int result) {
        super(result);
        this.params = new LinkedList<String>();
    }

    private void parseParams(byte[] data) {
        this.params = new LinkedList<String>();
        if (data.length < 14) {
            throw new IllegalArgumentException("Data length must be > 14");
        }
        try {
            this.status = new String(Arrays.copyOfRange(data, 2, 6), "Cp866");
            this.exresult = new String(Arrays.copyOfRange(data, 7, 11), "Cp866");
            this.statusprn = new String(Arrays.copyOfRange(data, 12, 14), "Cp866");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Data length must be > 14");
        }
        if (data.length > 15) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean flag = false;
            for (int i = 15; i < data.length; ++i) {
                if (data[i] != 0) {
                    baos.write(data[i]);
                    flag = true;
                    continue;
                }
                if (!flag) continue;
                try {
                    baos.close();
                    this.params.add(new String(baos.toByteArray(), "Cp866"));
                    flag = false;
                    baos = new ByteArrayOutputStream();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                baos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getExresult() {
        return this.exresult;
    }

    public List<String> getParams() {
        return this.params;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusprn() {
        return this.statusprn;
    }

    public void setExresult(String exresult) {
        this.exresult = exresult;
    }

    public void setParams(List<String> params) {
        this.params = params;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStatusprn(String statusprn) {
        this.statusprn = statusprn;
    }

    @Override
    public String toString() {
        return "ExResult{status=" + this.status + ", exresult=" + this.exresult + ", statusprn=" + this.statusprn + ", params={" + StringUtils.join(this.params, (String)", ") + "} }";
    }
}

