/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.iskra;

import java.io.IOException;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.print.PrintMode;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.Kkm;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ReportResult;
import ru.softlogic.rma.print.kkm.ShiftInfoResult;
import ru.softlogic.rma.print.kkm.iskra.Information;
import ru.softlogic.rma.print.kkm.iskra.IskraApi;
import ru.softlogic.rma.print.kkm.iskra.IskraApiListener;
import ru.softlogic.rma.print.kkm.iskra.Resources;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.kkm.render.RenderFactory;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.DocumentData;
import ru.softlogic.rma.print.queue.DocumentType;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;

public class IskraKkm
implements Kkm {
    private SerialPort port;
    private IskraApi api;
    private Logger log;
    private int purchaseSection = 1;
    private int interestSection = 2;
    private int scroll;
    private ResourceBundle bundle;
    private int constantStatus;
    private int currentStatus;
    private byte[] printerStatus;

    public IskraKkm(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("Need com port");
        }
        this.port = port;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.api = new IskraApi(port);
        this.api.addListener(new LocalApiListener());
        this.bundle = ResourceBundle.getBundle("ru.softlogic.rma.print.kkm.kkm");
    }

    @Override
    public String getInfo() throws IOException {
        StringBuilder sb = new StringBuilder();
        Information information = this.api.getInformation();
        sb.append("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u041a\u041a\u041c:").append("\n");
        sb.append("    \u041c\u043e\u0434\u0435\u043b\u044c: ").append(information.getModel()).append("\n");
        sb.append("    \u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e: ").append(information.getSoftware()).append("\n");
        sb.append("    \u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440: ").append(information.getRegisrationNumber()).append("\n");
        sb.append("    \u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u041a\u041a\u041c: ").append(information.getKkmSerial()).append("\n");
        sb.append("    \u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0424\u041f: ").append(information.getMemSerial()).append("\n");
        sb.append("    \u0418\u041d\u041d: ").append(information.getInn()).append("\n");
        sb.append("\n");
        Resources resources = this.api.getResources();
        if (resources.getError() == 0) {
            sb.append("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u0445:").append("\n");
            sb.append("    \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0441\u0442\u0430\u0432\u0448\u0438\u0445\u0441\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0439: ").append(resources.getRegistrationRest()).append("\n");
            sb.append("    \u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e Z-\u043e\u0442\u0447\u0435\u0442\u0430: ").append(resources.getzReportLastNumber()).append("\n");
            sb.append("    \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432: ").append(resources.getzReportRest()).append("\n");
        } else {
            this.log.error((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u0445");
            this.addRes(resources.getError());
        }
        return sb.toString();
    }

    @Override
    public OperationResult printRequest(RequestData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        this.log.info((Object)"==================== \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0437\u0430\u044f\u043a\u0443 ====================");
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        int res = this.api.openTextDocument();
        this.addRes(res);
        if (res != 0) {
            return this.getOperationResult(res);
        }
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0438");
        Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.Iskra);
        String image = render.process(data, 40).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1,40}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            res = this.api.printString(prn.replace("<b>", ""));
            this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            if (res == 0) continue;
            return this.getOperationResult(res);
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            for (int i = 0; i < this.scroll; ++i) {
                this.api.printString("");
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        res = this.api.closeTextDocument();
        this.addRes(res);
        if (res != 0) {
            return this.getOperationResult(res);
        }
        return this.getOperationResult(0);
    }

    @Override
    public OperationResult printDocument(OperationData data) throws IOException {
        int res;
        if (data == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        if (data.getJob().getRecord() == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Record");
        }
        Record record = data.getJob().getRecord();
        this.log.info((Object)"Begin------------------------------------------------------");
        this.validateState();
        if (data.getJob().getPrintMode() == PrintMode.PrintCheckBack) {
            res = this.api.openCheck((byte)1);
            this.addRes(res);
            if (res != 0) {
                return this.getOperationResult(res);
            }
            if (record.getSumIncome() > 0) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0442\u043e\u0432\u0430\u0440\u0430");
                res = this.api.addOperation(record.getServiceName(), record.getServiceId(), record.getSumIncome(), 1000, (byte)this.purchaseSection);
                this.addRes(res);
                if (res != 0) {
                    return this.getOperationResult(res);
                }
            }
            this.log.info((Object)"\u0420\u0430\u0441\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u044e \u0438\u0442\u043e\u0433 \u0447\u0435\u043a\u0430");
            res = this.api.calcTotal();
            this.addRes(res);
            if (res != 0) {
                return this.getOperationResult(res);
            }
            this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438 \u0434\u043b\u044f \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: " + record.getSumIncome()));
            res = this.api.addCash((byte)0, record.getSumIncome(), "");
            this.addRes(res);
            if (res != 0) {
                return this.getOperationResult(res);
            }
            Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.Iskra);
            String image = render.process(data, 40).replace("<br>", "\n");
            Matcher m = Pattern.compile(".{1,40}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                res = this.api.addString(prn.replace("<b>", ""));
                this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            }
        } else {
            res = this.api.openCheck((byte)0);
            this.addRes(res);
            if (res != 0) {
                return this.getOperationResult(res);
            }
            if (record.getSumOutcome() > 0) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
                res = this.api.addOperation(record.getServiceName(), record.getServiceId(), record.getSumOutcome(), 1000, (byte)this.purchaseSection);
                this.addRes(res);
                if (res != 0) {
                    return this.getOperationResult(res);
                }
            }
            if (record.getSumComm() > 0) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f)");
                res = this.api.addOperation(this.bundle.getString("comission"), 0, record.getSumComm(), 1000, (byte)this.interestSection);
                this.addRes(res);
                if (res != 0) {
                    return this.getOperationResult(res);
                }
            }
            this.log.info((Object)"\u0420\u0430\u0441\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u044e \u0438\u0442\u043e\u0433 \u0447\u0435\u043a\u0430");
            res = this.api.calcTotal();
            this.addRes(res);
            if (res != 0) {
                return this.getOperationResult(res);
            }
            this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + record.getSumIncome()));
            res = this.api.addCash((byte)0, record.getSumIncome(), "");
            this.addRes(res);
            if (res != 0) {
                return this.getOperationResult(res);
            }
            Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.Iskra);
            String image = render.process(data, 40).replace("<br>", "\n");
            Matcher m = Pattern.compile(".{1,40}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                res = this.api.addString(prn.replace("<b>", ""));
                this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        res = this.api.closeCheck();
        this.addRes(res);
        return this.getOperationResult(res);
    }

    @Override
    public OperationResult printDocument(DocumentData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 RequestData");
        }
        if (data.getType() == null) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 DocumentType");
        }
        if (data.getSum() <= 0) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u0441\u0443\u043c\u043c\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
        }
        if (data.getCount() <= 0) {
            return new OperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435");
        }
        this.log.info((Object)"Begin------------------------------------------------------");
        this.validateState();
        int res = this.api.openCheck(data.getType() == DocumentType.Sale ? (byte)0 : 1);
        this.addRes(res);
        if (res != 0) {
            return this.getOperationResult(res);
        }
        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
        res = this.api.addOperation(data.getName() != null ? data.getName() : "\u0422\u043e\u0432\u0430\u0440", 1, data.getSum(), data.getCount() * 1000, (byte)this.purchaseSection);
        this.addRes(res);
        if (res != 0) {
            return this.getOperationResult(res);
        }
        this.log.info((Object)"\u0420\u0430\u0441\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u044e \u0438\u0442\u043e\u0433 \u0447\u0435\u043a\u0430");
        res = this.api.calcTotal();
        this.addRes(res);
        if (res != 0) {
            return this.getOperationResult(res);
        }
        this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + data.getSum()));
        res = this.api.addCash((byte)0, data.getSum(), "");
        this.addRes(res);
        if (res != 0) {
            return this.getOperationResult(res);
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        res = this.api.closeCheck();
        this.addRes(res);
        return this.getOperationResult(res);
    }

    @Override
    public ReportResult formReportX() throws IOException {
        int res;
        return new ReportResult(res, (res = this.api.reportX()) != 0, this.getMessage(res));
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        int res;
        return new ReportResult(res, (res = this.api.reportZ()) != 0, this.getMessage(res));
    }

    @Override
    public ReportResult reset() throws IOException {
        return new ReportResult(0, false, "\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public void setScroll(int value) {
        this.scroll = value;
    }

    @Override
    public void setPurchaseSection(int section) {
        this.purchaseSection = section;
    }

    @Override
    public void setInterestSection(int section) {
        this.interestSection = section;
    }

    private OperationResult getOperationResult(int res) {
        return new OperationResult(res, res != 0, res == 21, this.getMessage(res));
    }

    private CustomOperationResult getCustomOperationResult(int res) {
        return new CustomOperationResult(res, res != 0, res == 21, this.getMessage(res));
    }

    private void addRes(int result) {
        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result + ", message=" + this.getMessage(result)));
    }

    private String getMessage(int error) {
        ResourceBundle b = ResourceBundle.getBundle("ru.softlogic.rma.print.kkm.iskra.messages");
        try {
            return b.getString(String.format("%d", error));
        }
        catch (Throwable ex) {
            return b.getString("undefined");
        }
    }

    private void validateState() throws IOException {
        this.api.ping();
        if ((this.currentStatus & 7) > 0) {
            this.api.cancelCheck();
        }
    }

    @Override
    public OperationResult printDocumentNotFiscalMode(OperationData data) throws IOException {
        this.log.info((Object)"==================== \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043a\u043e\u043f\u0438\u044e \u0447\u0435\u043a\u0430 ====================");
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        int res = this.api.openTextDocument();
        this.addRes(res);
        if (res != 0) {
            return this.getOperationResult(res);
        }
        this.validateState();
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0438");
        Render render = RenderFactory.createRenderCopy(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() + ".copy" : null, KkmType.Iskra);
        String image = render.process(data, 40).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1,40}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            res = this.api.printString(prn.replace("<b>", ""));
            this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            if (res == 0) continue;
            return this.getOperationResult(res);
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            for (int i = 0; i < this.scroll; ++i) {
                this.api.printString("");
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        res = this.api.closeTextDocument();
        this.addRes(res);
        if (res != 0) {
            return this.getOperationResult(res);
        }
        return this.getOperationResult(0);
    }

    @Override
    public CustomOperationResult printCustomNotFiscalMode(CustomData data) throws IOException {
        if (data == null) {
            return new CustomOperationResult(-1, true, false, "\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 CustomData");
        }
        this.log.info((Object)"==================== \u041f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u0430\u044f \u043f\u0435\u0447\u0430\u0442\u044c ====================");
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        int res = this.api.openTextDocument();
        this.addRes(res);
        if (res != 0) {
            return this.getCustomOperationResult(res);
        }
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0438");
        Render render = RenderFactory.createRender(data.getTemplate(), KkmType.Iskra);
        String image = render.process(data, 40).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1,40}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            res = this.api.printString(prn.replace("<b>", ""));
            this.log.info((Object)("\u0412\u044b\u0432\u043e\u0436\u0443 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            if (res == 0) continue;
            return this.getCustomOperationResult(res);
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0430 \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            for (int i = 0; i < this.scroll; ++i) {
                this.api.printString("");
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        res = this.api.closeTextDocument();
        this.addRes(res);
        if (res != 0) {
            return this.getCustomOperationResult(res);
        }
        return this.getCustomOperationResult(0);
    }

    @Override
    public ShiftInfoResult printShiftInfoResult(ShiftOperatingPrintRequest req) throws IOException {
        this.log.error((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        throw new IllegalStateException("\u041f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    static /* synthetic */ byte[] access$402(IskraKkm x0, byte[] x1) {
        x0.printerStatus = x1;
        return x1;
    }

    private class LocalApiListener
    implements IskraApiListener {
        private LocalApiListener() {
        }

        @Override
        public void onStatus(int constantStatus, int currentStatus, byte[] printerStatus) {
            if (IskraKkm.this.constantStatus != constantStatus) {
                IskraKkm.this.log.info((Object)("\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u041a\u041a\u041c =" + constantStatus));
                IskraKkm.this.constantStatus = constantStatus;
            }
            if (IskraKkm.this.currentStatus != currentStatus) {
                IskraKkm.this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u041a\u041a\u041c =" + currentStatus));
                IskraKkm.this.currentStatus = currentStatus;
            }
            if (!Arrays.equals(printerStatus, IskraKkm.this.printerStatus)) {
                IskraKkm.this.log.info((Object)("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 =" + Arrays.toString(printerStatus)));
                IskraKkm.access$402(IskraKkm.this, printerStatus);
            }
        }
    }
}

