/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.iskra;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class IskraFieldFormatter {
    public static byte[] getStringField(String str, int maxLen) {
        if (str == null) {
            return "".getBytes();
        }
        if (maxLen <= 0) {
            throw new IllegalArgumentException("Wrong length");
        }
        if (str.length() > maxLen) {
            str = str.substring(0, maxLen - 2) + "..";
        }
        try {
            return str.getBytes("866");
        }
        catch (UnsupportedEncodingException ex) {
            return "unsupported encoding".getBytes();
        }
    }

    public static byte[] getMoneyField(int sum) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format((double)sum / 100.0).getBytes();
    }

    public static byte[] getCountField(int count) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format((double)count / 1000.0).getBytes();
    }

    public static byte[] getHexField(short data) {
        return String.format("%02X%02X", data & 0xFF, data >> 8 & 0xFF).getBytes();
    }

    public static String getString(byte[] data) {
        try {
            return new String(data, "866");
        }
        catch (UnsupportedEncodingException ex) {
            return "undef";
        }
    }
}

