/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.iskra;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.rma.print.kkm.iskra.IskraFieldFormatter;
import ru.softlogic.rma.utils.ByteUtils;

public class IskraConnection {
    private final byte STX = (byte)2;
    private final byte ETX = (byte)3;
    private final byte ACK = (byte)6;
    private final byte CAN = (byte)24;
    private final byte NAK = (byte)21;
    private final byte SPL = (byte)28;
    private final int MAX_LEN = 512;
    private final int DEFAULT_TIMEOUT = 800;
    private SerialPort port;
    private byte nextByte = (byte)33;
    private int attempts = 5;
    private SimpleDateFormat date;
    private SimpleDateFormat time;
    private Logger log;
    private boolean debugIO;

    public IskraConnection(SerialPort port) {
        this.port = port;
        this.date = new SimpleDateFormat("ddMMyy");
        this.time = new SimpleDateFormat("HHmm");
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public void setAttempts(int attempts) {
        if (attempts < 1 || attempts > 20) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.cntatt"));
        }
        this.attempts = attempts;
    }

    public void setDebugIO(boolean debugIO) {
        this.debugIO = debugIO;
    }

    public List<byte[]> execute(int cmd, List<byte[]> fields, boolean addTimeStamp, Integer readTimeout) throws IOException {
        Object last = null;
        byte[] message = this.formMessage((byte)(cmd & 0xFF), fields, addTimeStamp);
        this.debugIO(">>message", message);
        this.writeData(message);
        List<Byte> data = this.readData(message, readTimeout != null ? readTimeout : 800);
        LinkedList<byte[]> result = new LinkedList<byte[]>();
        int lastIndex = -1;
        for (int i = 0; i < data.size(); ++i) {
            if (data.get(i) != 28) continue;
            if (lastIndex > 0) {
                result.add(ByteUtils.convert(data.subList(lastIndex + 1, i)));
            }
            lastIndex = i;
        }
        return result;
    }

    private void writeData(byte[] data) throws IOException {
        IOException last = null;
        this.port.setTimeout(500);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.port.write(data);
                return;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                last = ex;
                continue;
            }
        }
        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.cntputcmd"), last);
    }

    private List<Byte> readData(byte[] data, int timeout) throws IOException {
        IOException last = null;
        for (int i = 0; i < this.attempts; ++i) {
            try {
                int rb;
                int cnt;
                block12: {
                    this.port.setTimeout(timeout);
                    cnt = 0;
                    do {
                        try {
                            if (this.port.readByte() != 2) continue;
                            break block12;
                        }
                        catch (IOException ex) {
                            if (this.commandExec()) {
                                this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.waitcom"));
                                this.port.write((byte)21);
                                continue;
                            }
                            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.kkmnotans"));
                            throw ex;
                        }
                    } while (++cnt != 10);
                    throw new IOException(MessageFormat.format(LocBundle.getMessageEx((String)"rma.kkm.nostartmes"), cnt));
                }
                LinkedList<Byte> answer = new LinkedList<Byte>();
                answer.add((byte)2);
                cnt = 0;
                while ((rb = this.port.readByte()) != 3) {
                    answer.add((byte)(rb & 0xFF));
                    if (++cnt != 512) continue;
                    throw new IOException(MessageFormat.format(LocBundle.getMessageEx((String)"rma.kkm.noendmes"), cnt));
                }
                answer.add((byte)3);
                ByteUtils.add(answer, this.port.read(4));
                this.debugIO("rawout>>", answer);
                if (!this.checkCrc(answer)) {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.crceer"));
                    this.port.write((byte)21);
                    continue;
                }
                if (answer.size() < 9) {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.tooshotans"));
                    this.writeData(data);
                    continue;
                }
                if (data[5] != (Byte)answer.get(1)) {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.bytentcur"));
                    this.port.setTimeout(5);
                    this.port.read(1024);
                    this.writeData(data);
                    continue;
                }
                if ((Byte)answer.get(1) == 32 && (Byte)answer.get(2) == 48 && (Byte)answer.get(3) == 48) {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.csumntcur"));
                    this.writeData(data);
                    continue;
                }
                return answer;
            }
            catch (IOException ex) {
                last = ex;
            }
        }
        throw new IOException(MessageFormat.format(LocBundle.getMessageEx((String)"rma.kkm.cntreadans"), this.attempts), last);
    }

    public long parceHexField(String str) {
        if (str == null) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.strntset"));
        }
        if (str.length() > 10) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.strlenless"));
        }
        if (str.length() % 2 == 1) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.strleneven"));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = str.length(); i > 0; i -= 2) {
            sb.append(str.substring(i - 2, i));
        }
        return Long.parseLong(sb.toString(), 16);
    }

    public byte[] getBytesFromHexField(String str) {
        if (str == null) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.strntset"));
        }
        if (str.length() > 10) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.strlenless"));
        }
        if (str.length() % 2 == 1) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.strleneven"));
        }
        LinkedList<Byte> bytes = new LinkedList<Byte>();
        for (int i = 0; i < str.length(); i += 2) {
            bytes.add(Byte.parseByte(str.substring(i, i + 2), 16));
        }
        return ByteUtils.convert(bytes);
    }

    private boolean commandExec() throws IOException {
        this.port.write(new byte[]{16, 48});
        int res = this.port.readByte();
        if ((res & 0x93) == 18) {
            return (res & 8) > 0;
        }
        return false;
    }

    private void addCrc(List<Byte> data) {
        short bcc = 0;
        for (Byte b : data) {
            bcc = (short)(bcc + (b & 0xFF));
        }
        ByteUtils.add(data, IskraFieldFormatter.getHexField(bcc));
    }

    private boolean checkCrc(List<Byte> data) {
        short bcc = 0;
        for (int i = 0; i < data.size() - 4; ++i) {
            bcc = (short)(bcc + (data.get(i) & 0xFF));
        }
        byte[] bcc2 = IskraFieldFormatter.getHexField(bcc);
        int l = data.size();
        return data.get(l - 4) == bcc2[0] && data.get(l - 3) == bcc2[1] && data.get(l - 2) == bcc2[2] && data.get(l - 1) == bcc2[3];
    }

    private void debugIO(String name, byte[] message) {
        if (this.debugIO) {
            this.log.info((Object)"========================");
            this.log.info((Object)name);
            for (int i = 0; i < message.length; ++i) {
                this.log.info((Object)String.format("%02d   %02d   %c  0x%02x", i, message[i] & 0xFF, message[i] & 0xFF, message[i] & 0xFF));
            }
        }
    }

    private void debugIO(String name, List<Byte> message) {
        if (this.debugIO) {
            this.log.info((Object)"========================");
            this.log.info((Object)name);
            for (int i = 0; i < message.size(); ++i) {
                this.log.info((Object)String.format("%02d   %02d   %c  0x%02x", i, message.get(i) & 0xFF, message.get(i) & 0xFF, message.get(i) & 0xFF));
            }
        }
    }

    private byte getRandomByte() {
        this.nextByte = (this.nextByte & 0xFF) > 250 ? (byte)32 : (byte)(this.nextByte + 1);
        return this.nextByte;
    }

    private byte[] formMessage(byte cmd, List<byte[]> fields, boolean addTimeStamp) {
        LinkedList<Byte> bytes = new LinkedList<Byte>();
        bytes.add((byte)2);
        ByteUtils.add(bytes, "AERF".getBytes());
        bytes.add(this.getRandomByte());
        ByteUtils.add(bytes, String.format("%02X", cmd).getBytes());
        if (addTimeStamp) {
            Date d = new Date();
            bytes.add((byte)28);
            ByteUtils.add(bytes, this.date.format(d).getBytes());
            bytes.add((byte)28);
            ByteUtils.add(bytes, this.time.format(d).getBytes());
        }
        if (fields != null) {
            for (byte[] field : fields) {
                bytes.add((byte)28);
                ByteUtils.add(bytes, field);
            }
        }
        bytes.add((byte)28);
        bytes.add((byte)3);
        this.addCrc(bytes);
        return ByteUtils.convert(bytes);
    }
}

