/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.iskra;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rmai18n.LocBundle;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.NoSuchDeviceException;
import ru.softlogic.rma.print.kkm.SerialDeviceApi;
import ru.softlogic.rma.print.kkm.iskra.Documents;
import ru.softlogic.rma.print.kkm.iskra.Information;
import ru.softlogic.rma.print.kkm.iskra.IskraApiListener;
import ru.softlogic.rma.print.kkm.iskra.IskraConnection;
import ru.softlogic.rma.print.kkm.iskra.IskraFieldFormatter;
import ru.softlogic.rma.print.kkm.iskra.PaymentInstrument;
import ru.softlogic.rma.print.kkm.iskra.Resources;
import ru.softlogic.rma.utils.ArrayUtils;

public class IskraApi
implements SerialDeviceApi {
    private SerialPort port;
    private IskraConnection conn;
    private Map<Boolean, SerialParams[]> serialParams;
    private int extendedError;
    private Set<IskraApiListener> listeners;

    public IskraApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("Need SerialPort");
        }
        this.port = port;
        this.conn = new IskraConnection(port);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(4800, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)});
        this.listeners = new HashSet<IskraApiListener>();
    }

    public void addListener(IskraApiListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public int getExtendedError() {
        return this.extendedError;
    }

    public int beginSession() throws IOException {
        return this.getResult(this.conn.execute(1, null, true, null));
    }

    public int openShift() throws IOException {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add(IskraFieldFormatter.getStringField(LocBundle.getMessage((String)"rma.print.opench"), 255));
        return this.getResult(this.conn.execute(2, fields, true, null));
    }

    public PaymentInstrument getPaymentInstrument(int id) throws IOException {
        List<byte[]> fields = new LinkedList<byte[]>();
        fields.add(String.format("%02X", id).getBytes());
        fields = this.conn.execute(75, fields, false, null);
        int result = this.getResult(fields);
        if (result != 0 || fields == null || fields.size() < 11) {
            return null;
        }
        PaymentInstrument inst = new PaymentInstrument();
        inst.setId((int)this.conn.parceHexField(new String(fields.get(4))));
        inst.setName(IskraFieldFormatter.getString(fields.get(5)));
        inst.setTwoLines((int)this.conn.parceHexField(new String(fields.get(6))));
        inst.setSdacha((int)this.conn.parceHexField(new String(fields.get(7))));
        inst.setCurrency((int)this.conn.parceHexField(new String(fields.get(8))));
        inst.setMask((int)this.conn.parceHexField(new String(fields.get(9))));
        try {
            inst.setCourse((int)(Double.parseDouble(IskraFieldFormatter.getString(fields.get(10))) * 100.0));
        }
        catch (NumberFormatException ex) {
            inst.setCourse(100);
        }
        return inst;
    }

    public int setPaymentInstrument(PaymentInstrument pi) throws IOException {
        if (pi == null) {
            throw new IllegalArgumentException("Need PaymentInstrument");
        }
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add(String.format("%02X", pi.getId()).getBytes());
        fields.add(IskraFieldFormatter.getStringField(pi.getName(), 19));
        fields.add(String.format("%02X", pi.getTwoLines()).getBytes());
        fields.add(String.format("%02X", pi.getSdacha()).getBytes());
        fields.add(String.format("%02X", pi.getCurrency()).getBytes());
        fields.add(String.format("%02X", pi.getMask()).getBytes());
        fields.add(IskraFieldFormatter.getMoneyField(pi.getCourse()));
        return this.getResult(this.conn.execute(74, fields, false, 3000));
    }

    public Map<Integer, String> getSections() throws IOException {
        List<byte[]> fields = this.conn.execute(97, null, false, null);
        int result = this.getResult(fields);
        if (result != 0) {
            return null;
        }
        HashMap<Integer, String> sections = null;
        if (fields.size() % 2 == 0) {
            sections = new HashMap<Integer, String>();
            for (int i = 0; i < (fields.size() - 4) / 2; ++i) {
                int id = (int)this.conn.parceHexField(new String(fields.get(4 + i * 2)));
                String name = null;
                try {
                    name = new String(fields.get(5 + i * 2), "866");
                }
                catch (UnsupportedEncodingException ex) {
                    name = "undef";
                }
                sections.put(id, name);
            }
        }
        return sections;
    }

    public int setSections(Map<Integer, String> sections) throws IOException {
        if (sections == null || sections.isEmpty()) {
            throw new IllegalArgumentException("Need list of units");
        }
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        for (Integer key : sections.keySet()) {
            fields.add(String.format("%02X", key).getBytes());
            fields.add(sections.get(key).getBytes("866"));
        }
        return this.getResult(this.conn.execute(96, fields, false, 3000));
    }

    public Resources getResources() throws IOException {
        List<byte[]> fields = this.conn.execute(3, null, true, null);
        int res = this.getResult(fields);
        Resources resources = new Resources();
        resources.setError(res);
        if (res == 0) {
            resources.setRegistrationRest((int)this.conn.parceHexField(new String(fields.get(4))));
            resources.setzReportRest((int)this.conn.parceHexField(new String(fields.get(5))));
            resources.setzReportLastNumber((int)this.conn.parceHexField(new String(fields.get(6))));
        }
        return resources;
    }

    public Documents getDocuments() throws IOException {
        List<byte[]> fields = this.conn.execute(53, null, false, null);
        int res = this.getResult(fields);
        if (res != 0) {
            throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.errwlreq") + " err=" + res);
        }
        Documents documents = new Documents();
        documents.setDocumentNo((int)this.conn.parceHexField(new String(fields.get(4))));
        documents.setCheckNo((int)this.conn.parceHexField(new String(fields.get(5))));
        return documents;
    }

    public int ping() throws IOException {
        return this.getResult(this.conn.execute(53, null, false, 2000));
    }

    public String getSerialNumber() throws IOException {
        List<byte[]> fields = this.conn.execute(150, null, false, null);
        int res = this.getResult(fields);
        if (res != 0) {
            throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.errwlreq") + " err=" + res);
        }
        return new String(fields.get(4)).trim();
    }

    public Information getInformation() throws IOException {
        List<byte[]> fields = this.conn.execute(151, null, false, null);
        int res = this.getResult(fields);
        if (res != 0) {
            throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.errwlreq") + " err=" + res);
        }
        Information information = new Information();
        information.setModel(new String(fields.get(4), "866").trim());
        information.setSoftware(new String(fields.get(5), "866").trim());
        information.setKkmSerial(new String(fields.get(6), "866").trim());
        information.setRegisrationNumber(new String(fields.get(7), "866").trim());
        information.setInn(new String(fields.get(8), "866").trim());
        information.setMemSerial(new String(fields.get(9), "866").trim());
        return information;
    }

    public int openCheck(byte type) throws IOException {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add(String.format("%02X", type).getBytes());
        fields.add(IskraFieldFormatter.getStringField("pay-logic|01", 14));
        fields.add("".getBytes());
        fields.add("".getBytes());
        fields.add("01".getBytes());
        fields.add("".getBytes());
        return this.getResult(this.conn.execute(16, fields, true, null));
    }

    public int addOperation(String name, int code, int sum, int count, byte section) throws IOException {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add(IskraFieldFormatter.getStringField(name, 40));
        fields.add(Integer.toString(code).getBytes());
        fields.add(IskraFieldFormatter.getMoneyField(sum));
        fields.add(IskraFieldFormatter.getCountField(count));
        fields.add("   ".getBytes());
        fields.add(String.format("%02X", section).getBytes());
        fields.add("".getBytes());
        return this.getResult(this.conn.execute(17, fields, false, null));
    }

    public int calcTotal() throws IOException {
        return this.getResult(this.conn.execute(18, null, false, null));
    }

    public int addCash(byte type, int sum, String name) throws IOException {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add(String.format("%02X", type).getBytes());
        fields.add(IskraFieldFormatter.getMoneyField(sum));
        fields.add(IskraFieldFormatter.getStringField(name, 40));
        return this.getResult(this.conn.execute(19, fields, false, null));
    }

    public int closeCheck() throws IOException {
        return this.getResult(this.conn.execute(20, null, false, 5000));
    }

    public int cancelCheck() throws IOException {
        return this.getResult(this.conn.execute(23, null, true, null));
    }

    public int addString(String str) throws IOException {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add(IskraFieldFormatter.getStringField(str, 255));
        return this.getResult(this.conn.execute(28, fields, false, null));
    }

    public int setPrinterMode() throws IOException {
        return this.getResult(this.conn.execute(112, null, false, null));
    }

    public int openTextDocument() throws IOException {
        return this.getResult(this.conn.execute(80, null, true, null));
    }

    public int printString(String str) throws IOException {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add(IskraFieldFormatter.getStringField(str, 40));
        return this.getResult(this.conn.execute(81, fields, false, null));
    }

    public int printStrings(String[] strs) throws IOException {
        if (strs == null) {
            this.extendedError = 0;
            return 0;
        }
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        for (String str : strs) {
            fields.add(IskraFieldFormatter.getStringField(str, 40));
        }
        return this.getResult(this.conn.execute(86, fields, false, null));
    }

    public int closeTextDocument() throws IOException {
        return this.getResult(this.conn.execute(82, null, false, null));
    }

    public int reportX() throws IOException {
        return this.getResult(this.conn.execute(48, null, true, 10000));
    }

    public int reportZ() throws IOException {
        return this.getResult(this.conn.execute(49, null, true, 10000));
    }

    public short[] getDocumentParams() throws IOException {
        List<byte[]> fields = this.conn.execute(77, null, true, null);
        int res = this.getResult(fields);
        if (res != 0) {
            throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.errgetinfo") + " " + res);
        }
        short p1 = (short)this.conn.parceHexField(new String(fields.get(4)));
        short p2 = (short)this.conn.parceHexField(new String(fields.get(5)));
        short p3 = (short)this.conn.parceHexField(new String(fields.get(6)));
        return new short[]{p1, p2, p3};
    }

    public int setDocumentParams(short param1, short param2, short interval) throws IOException {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add(IskraFieldFormatter.getHexField(param1));
        fields.add(IskraFieldFormatter.getHexField(param2));
        fields.add(IskraFieldFormatter.getHexField(interval));
        return this.getResult(this.conn.execute(76, fields, false, 5000));
    }

    public int putReportToMemory() throws IOException {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add("00".getBytes());
        return this.getResult(this.conn.execute(49, fields, true, 10000));
    }

    public int printReportsFromMemory(short reportNumber) throws IOException {
        LinkedList<byte[]> fields = new LinkedList<byte[]>();
        fields.add(IskraFieldFormatter.getHexField(reportNumber));
        return this.getResult(this.conn.execute(124, fields, false, 10000));
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return ArrayUtils.arrayMerge(this.serialParams.get(true), this.serialParams.get(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void look(boolean preferred) throws NoSuchDeviceException {
        this.conn.setAttempts(2);
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.port.putParams(params);
                this.open();
                this.getInformation();
                return;
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
            }
        }
        throw new NoSuchDeviceException(MessageFormat.format(LocBundle.getMessageEx((String)"rma.kkm.noiskra"), this.port.getName()));
    }

    @Override
    public void open() throws IOException {
        this.port.open();
    }

    @Override
    public void close() {
        this.port.close();
    }

    private int getResult(List<byte[]> fields) {
        if (fields == null) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.ndlstflds"));
        }
        if (fields.size() < 4) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.min4fld"));
        }
        this.extendedError = Integer.parseInt(new String(fields.get(2), 2, 2), 16);
        for (IskraApiListener l : this.listeners) {
            l.onStatus((int)this.conn.parceHexField(new String(fields.get(0))), (int)this.conn.parceHexField(new String(fields.get(1))), this.conn.getBytesFromHexField(new String(fields.get(3))));
        }
        return Integer.parseInt(new String(fields.get(2), 0, 2), 16);
    }

    public SerialPort getPort() {
        return this.port;
    }

    public IskraConnection getConnection() {
        return this.conn;
    }

    @Override
    public KkmType getKkmType() {
        return KkmType.Iskra;
    }
}

