/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.atol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.print.PrintMode;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.Kkm;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ReportResult;
import ru.softlogic.rma.print.kkm.ShiftInfoResult;
import ru.softlogic.rma.print.kkm.atol.AtolApi;
import ru.softlogic.rma.print.kkm.atol.AtolLongState;
import ru.softlogic.rma.print.kkm.atol.AtolShortState;
import ru.softlogic.rma.print.kkm.atol.AtolType;
import ru.softlogic.rma.print.kkm.atol.AtolVersion;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.kkm.render.RenderFactory;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.DocumentData;
import ru.softlogic.rma.print.queue.DocumentType;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;

public class AtolKkm
implements Kkm {
    private AtolApi api;
    private Logger log;
    private ResourceBundle bundle;
    private int scroll;
    private int purchaseSection;
    private int interestSection;
    private AtolType type;
    private Integer printWidth;

    public AtolKkm(SerialPort port) {
        this.api = new AtolApi(port);
        this.bundle = ResourceBundle.getBundle("ru.softlogic.rma.print.kkm.kkm");
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.setScroll(0);
        this.setPurchaseSection(1);
        this.setInterestSection(2);
    }

    @Override
    public String getInfo() throws IOException {
        StringBuilder sb = new StringBuilder();
        AtolLongState longState = this.api.getLongState();
        sb.append(LocBundle.getMessage((String)"rma.print.cominfo")).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.softvers")).append(" ").append(longState.getSoftwareVersion()).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.fnumb")).append(" ").append(longState.getFactoryNumber()).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmnumb")).append(" ").append(longState.getKkmNumber()).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.flags")).append(" ").append(longState.getFlags()).append("\n");
        sb.append("\n");
        this.type = this.api.getAtolType();
        sb.append(LocBundle.getMessage((String)"rma.print.kkminfo")).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmmodel")).append(" ").append(this.type.getModel()).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmname")).append(" ").append(this.type.getName()).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmvers")).append(" ").append(this.type.getVersion()).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmtype")).append(" ").append(this.type.getType()).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmprot")).append(" ").append(this.type.getProto()).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmmode")).append(" ").append(this.type.getMode()).append("\n");
        sb.append("\n");
        sb.append(LocBundle.getMessage((String)"rma.print.softvers")).append("\n");
        AtolVersion softwareVersion = this.api.getVersion((byte)1);
        AtolVersion mem = this.api.getVersion((byte)2);
        AtolVersion boot = this.api.getVersion((byte)3);
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmproc")).append(" ").append(softwareVersion).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmprocfmem")).append(" ").append(mem).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmcprocb")).append(" ").append(boot).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmprocmem")).append(" ").append(this.api.getVersion((byte)4)).append("\n");
        sb.append("    ").append(LocBundle.getMessage((String)"rma.print.kkmprocbl")).append(" ").append(this.api.getVersion((byte)5)).append("\n");
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public OperationResult printRequest(RequestData data) throws IOException {
        int res;
        if (data == null) {
            return new OperationResult(-1, true, false, LocBundle.getMessage((String)"rma.print.ndrd"));
        }
        int width = this.getPrintWidth();
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.prntreq"));
        this.validate();
        Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.Atol);
        String image = render.process(data, width).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1," + width + "}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            prn = prn.replace("<b>", "");
            res = this.api.printText(prn);
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.outres"), prn, res));
            if (res == 0) continue;
            return this.getOperationResult(res);
        }
        if (this.scroll > 0) {
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.scrstr") + " " + this.scroll));
            for (int i = 0; i < this.scroll; ++i) {
                res = this.api.printText(" ");
                if (res == 0) continue;
                return this.getOperationResult(res);
            }
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.chkcut"));
        int res2 = this.api.cutPaper((byte)0);
        this.addRes(res2);
        return this.getOperationResult(0);
    }

    @Override
    public OperationResult printDocument(OperationData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, LocBundle.getMessage((String)"rma.print.ndrd"));
        }
        if (data.getJob().getRecord() == null) {
            return new OperationResult(-1, true, false, LocBundle.getMessage((String)"rma.print.ndrec"));
        }
        Record record = data.getJob().getRecord();
        int width = this.getPrintWidth();
        int res = this.validate();
        if (res != 0) {
            return this.getOperationResult(res);
        }
        if (data.getJob().getPrintMode() == PrintMode.PrintCheckBack) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.backchk"));
            res = this.openCheck((byte)0, (byte)2);
            this.addRes(res);
            if (res != 0 && res != 30) {
                return this.getOperationResult(res);
            }
            this.printAdv(data.getJob().getBeginAdvText(), width);
            if (record.getSumIncome() > 0) {
                this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.salename"));
                res = this.api.printText(record.getServiceName());
                this.addRes(res);
                this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.addbacksale"));
                res = this.api.addOperation((byte)0, record.getSumIncome(), 1000, (byte)this.purchaseSection);
                this.addRes(res);
                if (res != 0) {
                    return this.getOperationResult(res);
                }
            }
            Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.Atol);
            String image = render.process(data, width).replace("<br>", "\n");
            if (data.getJob().getEndAdvText() != null && !data.getJob().getEndAdvText().isEmpty()) {
                image = image + data.getJob().getEndAdvText().trim();
            }
            Matcher m = Pattern.compile(".{1," + width + "}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                res = this.api.printText(prn.replace("<b>", ""));
                if (res == 0) continue;
                return this.getOperationResult(res);
            }
        } else {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.prntsale"));
            res = this.openCheck((byte)0, (byte)1);
            this.addRes(res);
            if (res != 0 && res != 30) {
                return this.getOperationResult(res);
            }
            this.printAdv(data.getJob().getBeginAdvText(), width);
            if (record.getSumOutcome() > 0) {
                this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.salename"));
                res = this.api.printText(record.getServiceName());
                this.addRes(res);
                this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.addsale"));
                res = this.api.addOperation((byte)0, record.getSumOutcome(), 1000, (byte)this.purchaseSection);
                this.addRes(res);
                if (res != 0) {
                    return this.getOperationResult(res);
                }
            }
            if (record.getSumComm() > 0) {
                this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.comname"));
                res = this.api.printText(this.bundle.getString("comission"));
                if (res != 0) {
                    return this.getOperationResult(res);
                }
                this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.addcomsale"));
                res = this.api.addOperation((byte)0, record.getSumComm(), 1000, (byte)this.interestSection);
                this.addRes(res);
                if (res != 0) {
                    return this.getOperationResult(res);
                }
            }
            Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, KkmType.Atol);
            String image = render.process(data, width).replace("<br>", "\n");
            if (data.getJob().getEndAdvText() != null && !data.getJob().getEndAdvText().isEmpty()) {
                image = image + data.getJob().getEndAdvText().trim();
            }
            Matcher m = Pattern.compile(".{1," + width + "}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                res = this.api.printText(prn.replace("<b>", ""));
                if (res == 0) continue;
                return this.getOperationResult(res);
            }
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.closechk"));
        res = this.api.closeCheck((byte)0, (byte)1, record.getSumIncome());
        this.addRes(res);
        return this.getOperationResult(res);
    }

    @Override
    public OperationResult printDocument(DocumentData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, LocBundle.getMessage((String)"rma.print.ndrd"));
        }
        if (data.getType() == null) {
            return new OperationResult(-1, true, false, LocBundle.getMessage((String)"rma.print.nddt"));
        }
        if (data.getSum() <= 0) {
            return new OperationResult(-1, true, false, LocBundle.getMessage((String)"rma.print.ndsum"));
        }
        if (data.getCount() <= 0) {
            return new OperationResult(-1, true, false, LocBundle.getMessage((String)"rma.print.ndcount"));
        }
        int width = this.getPrintWidth();
        int res = this.validate();
        if (res != 0) {
            this.getOperationResult(res);
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.prntsale"));
        res = this.openCheck((byte)0, data.getType() == DocumentType.Sale ? (byte)1 : 2);
        this.addRes(res);
        if (res != 0 && res != 30) {
            return this.getOperationResult(res);
        }
        if (data.getName() != null && !data.getName().isEmpty()) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.salename"));
            res = this.api.printText(data.getName());
            this.addRes(res);
        }
        if (data.getType() == DocumentType.Sale) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.addsale"));
            res = this.api.addOperation((byte)0, data.getSum(), data.getCount() * 1000, (byte)this.purchaseSection);
        } else {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.addclsale"));
            res = this.api.addReturn((byte)0, data.getSum(), data.getCount() * 1000);
        }
        this.addRes(res);
        if (res != 0) {
            return this.getOperationResult(res);
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.closechk"));
        res = this.api.closeCheck((byte)0, (byte)1, data.getType() == DocumentType.Sale ? data.getSum() : 0);
        this.addRes(res);
        return this.getOperationResult(res);
    }

    @Override
    public ReportResult formReportX() throws IOException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.closex"));
        int res = this.api.exitMode();
        this.addRes(res);
        if (res != 0) {
            return new ReportResult(res, res != 0, this.getMessage(res));
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.switchtox"));
        res = this.api.selectMode((byte)2);
        this.addRes(res);
        if (res != 0) {
            return new ReportResult(res, res != 0, this.getMessage(res));
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.closingx"));
        res = this.api.reportX();
        this.addRes(res);
        return new ReportResult(res, res != 0, this.getMessage(res));
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.closez"));
        int res = this.api.exitMode();
        this.addRes(res);
        if (res != 0) {
            return new ReportResult(res, res != 0, this.getMessage(res));
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.switchtoz"));
        res = this.api.selectMode((byte)3);
        this.addRes(res);
        if (res != 0) {
            return new ReportResult(res, res != 0, this.getMessage(res));
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.closingz"));
        res = this.api.reportZ();
        this.addRes(res);
        return new ReportResult(res, res != 0, this.getMessage(res));
    }

    @Override
    public ReportResult reset() throws IOException {
        return null;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public void setScroll(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.wrongscrollcal"));
        }
        this.scroll = 5 + value;
    }

    private int getPrintWidth() throws IOException {
        if (this.printWidth == null) {
            if (this.type == null) {
                this.type = this.api.getAtolType();
            }
            switch (this.type.getModel()) {
                case 38: 
                case 45: {
                    return 42;
                }
                case 37: 
                case 41: {
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.exitfmmode"));
                    int res = this.api.exitMode();
                    this.addRes(res);
                    if (res != 0) {
                        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.workerr") + " " + this.getMessage(res));
                    }
                    this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.chkprogmode"));
                    res = this.api.selectMode((byte)4);
                    this.addRes(res);
                    if (res != 0) {
                        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.workerr") + " " + this.getMessage(res));
                    }
                    byte[] resTable = this.api.readTable(2, 1, 55);
                    int width = this.api.convertFromByte(resTable[0]);
                    this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.getwidthprnt") + " " + width));
                    return width;
                }
                case 39: 
                case 46: {
                    return 40;
                }
                case 30: 
                case 32: 
                case 33: {
                    return 50;
                }
                case 14: 
                case 15: {
                    return 20;
                }
            }
            return 30;
        }
        return this.printWidth;
    }

    private OperationResult getOperationResult(int res) {
        return new OperationResult(res, res != 0, res == 136, this.getMessage(res));
    }

    private CustomOperationResult getCustomOperationResult(int res) {
        return new CustomOperationResult(res, res != 0, res == 136, this.getMessage(res));
    }

    private void addRes(int result) {
        this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.resprnt"), result, this.getMessage(result)));
    }

    private String getMessage(int error) {
        ResourceBundle b = ResourceBundle.getBundle("ru.softlogic.rma.print.kkm.atol.messages");
        try {
            return b.getString(String.format("%d", error));
        }
        catch (Throwable ex) {
            return b.getString("undefined");
        }
    }

    private int validate() throws IOException {
        AtolShortState ass = this.api.getShortState();
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.curmode") + " " + ass));
        int res = 0;
        if (ass.getMode() != 1) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.exitfmmode"));
            for (int i = 0; i < 10; ++i) {
                res = this.api.exitMode();
                this.addRes(res);
                if (res == 102) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (res == 0 || res == 30) break;
                return res;
            }
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.switchreg"));
            res = this.api.selectMode((byte)1);
            if (res != 0 && res != 30) {
                return res;
            }
            this.addRes(res);
        } else if (ass.getSubmode() == 4) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.othdoc"));
            res = this.api.cancelCheck();
            this.addRes(res);
            if (res != 0 && res != 30) {
                return res;
            }
        }
        return 0;
    }

    @Override
    public void setPurchaseSection(int section) {
        this.purchaseSection = section;
    }

    @Override
    public void setInterestSection(int section) {
        this.interestSection = section;
    }

    private void printAdv(String adv, int width) throws IOException {
        if (adv != null && !adv.isEmpty()) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.avdprnt"));
            String image = adv.trim();
            Matcher m = Pattern.compile(".{1," + width + "}").matcher(image);
            while (m.find()) {
                String prn = m.group(0);
                int res = this.api.printText(prn.replace("<b>", ""));
                this.addRes(res);
            }
        }
    }

    private int openCheck(byte flag, byte type) throws IOException {
        int res = 0;
        for (int i = 0; i < 3; ++i) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.openchk"));
            res = this.api.openCheck(flag, type);
            this.addRes(res);
            if (res == 30) {
                return 0;
            }
            if (res != 0) {
                if (this.processError(res, true) == 0) continue;
                return res;
            }
            return res;
        }
        return res;
    }

    private int processError(int error, boolean logActions) throws IOException {
        if (logActions) {
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.trycancelerr") + " " + error));
        }
        if (error == 155) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.cancelchk"));
            int res = this.api.cancelCheck();
            this.addRes(res);
            return res;
        }
        if (error == 137 || error == 155) {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.cnlothdoc"));
            int res = this.api.cancelCheck();
            this.addRes(res);
            return res;
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.nohandler"));
        return -1;
    }

    @Override
    public OperationResult printDocumentNotFiscalMode(OperationData data) throws IOException {
        if (data == null) {
            return new OperationResult(-1, true, false, LocBundle.getMessage((String)"rma.print.ndrd"));
        }
        int width = this.getPrintWidth();
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.prntcopy"));
        int res = this.validate();
        if (res != 0) {
            return this.getOperationResult(res);
        }
        this.printAdv(data.getJob().getBeginAdvText(), width);
        Render render = RenderFactory.createRenderCopy(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() + ".copy" : null, KkmType.Atol);
        String image = render.process(data, width).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1," + width + "}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            prn = prn.replace("<b>", "");
            res = this.api.printText(prn);
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.outres"), prn, res));
            if (res == 0) continue;
            return this.getOperationResult(res);
        }
        if (this.scroll > 0) {
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.scrstr") + " " + this.scroll));
            for (int i = 0; i < this.scroll; ++i) {
                res = this.api.printText(" ");
                if (res == 0) continue;
                return this.getOperationResult(res);
            }
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.chkcut"));
        res = this.api.cutPaper((byte)0);
        this.addRes(res);
        return this.getOperationResult(0);
    }

    @Override
    public CustomOperationResult printCustomNotFiscalMode(CustomData data) throws IOException {
        if (data == null) {
            return new CustomOperationResult(-1, true, false, LocBundle.getMessage((String)"rma.print.ndrd"));
        }
        int width = this.getPrintWidth();
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        int res = this.validate();
        if (res != 0) {
            return this.getCustomOperationResult(res);
        }
        Render render = RenderFactory.createRender(data.getTemplate(), KkmType.Atol);
        String image = render.process(data, width).replace("<br>", "\n");
        Matcher m = Pattern.compile(".{1," + width + "}").matcher(image);
        while (m.find()) {
            String prn = m.group(0);
            prn = prn.replace("<b>", "");
            res = this.api.printText(prn);
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.outres"), prn, res));
            if (res == 0) continue;
            return this.getCustomOperationResult(res);
        }
        if (this.scroll > 0) {
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.scrstr") + " " + this.scroll));
            for (int i = 0; i < this.scroll; ++i) {
                res = this.api.printText(" ");
                if (res == 0) continue;
                return this.getCustomOperationResult(res);
            }
        }
        this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.chkcut"));
        res = this.api.cutPaper((byte)0);
        this.addRes(res);
        return this.getCustomOperationResult(0);
    }

    @Override
    public ShiftInfoResult printShiftInfoResult(ShiftOperatingPrintRequest req) throws IOException {
        this.log.error((Object)"\u043f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0447\u0435\u0440\u0435\u0437 \u0424\u0420 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        throw new IllegalStateException("\u041f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0447\u0435\u0440\u0435\u0437 \u0424\u0420 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }
}

