/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.atol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.rma.utils.ByteUtils;

public class AtolConnection {
    private final byte ENQ = (byte)5;
    private final byte ACK = (byte)6;
    private final byte STX = (byte)2;
    private final byte ETX = (byte)3;
    private final byte EOT = (byte)4;
    private final byte NAK = (byte)21;
    private final byte DLE = (byte)16;
    private final int TIMEOUT_T1 = 1500;
    private final int TIMEOUT_T2 = 2000;
    private final int TIMEOUT_T3 = 500;
    private final int TIMEOUT_T4 = 500;
    private final int TIMEOUT_T5 = 10000;
    private final int TIMEOUT_T6 = 500;
    private final int TIMEOUT_T7 = 1000;
    private final int TIMEOUT_T8 = 1000;
    private SerialPort port;
    private Logger log;
    private int readAttempts = 5;
    private int attempts = 3;

    public AtolConnection(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("Need com-port");
        }
        this.port = port;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public byte[] sendCommand(int cmd, byte[] password, byte[] data, Integer timeout) throws IOException {
        if (password == null || password.length != 2 && password.length != 0) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.pass2bytes"));
        }
        IOException last = null;
        byte[] message = this.getData((byte)(cmd & 0xFF), password, data);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.sendData(message);
                byte[] answer = this.readData(timeout == null ? 10000 : timeout);
                answer = Arrays.copyOfRange(answer, 1, answer.length - 2);
                answer = this.unpack(answer);
                return answer;
            }
            catch (IOException ex) {
                last = ex;
                continue;
            }
        }
        throw new IOException(last);
    }

    public void setReadAttempts(int readAttempts) {
        this.readAttempts = readAttempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    private byte[] unpack(byte[] data) {
        LinkedList<Byte> unmasked = new LinkedList<Byte>();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 16 && i < data.length - 1 && (data[i + 1] == 16 || data[i + 1] == 3)) {
                unmasked.add(data[i + 1]);
                ++i;
                continue;
            }
            unmasked.add(data[i]);
        }
        byte[] result = new byte[unmasked.size()];
        for (int i = 0; i < unmasked.size(); ++i) {
            result[i] = (Byte)unmasked.get(i);
        }
        return result;
    }

    private byte[] readData(int timeout) throws IOException {
        IOException last = null;
        this.log.debug((Object)LocBundle.getMessageLog((String)"rma.print.waitenq"));
        this.port.setTimeout(timeout);
        int ans = 0;
        long start = System.currentTimeMillis();
        for (int j = 0; j < 100; ++j) {
            ans = this.port.readByte();
            if (ans == 5) {
                this.log.debug((Object)"<<ENQ");
                break;
            }
            this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.print.trash") + String.format("0x%02x", ans)));
            if (System.currentTimeMillis() - start > (long)timeout) break;
        }
        if (ans != 5) {
            throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.noenq") + " " + ans);
        }
        this.log.debug((Object)">>ACK");
        this.port.write((byte)6);
        for (int i = 0; i < this.readAttempts; ++i) {
            try {
                this.port.setTimeout(2000);
                boolean cnt = false;
                for (int j = 0; j < 100 && (ans = this.port.readByte()) != 2; ++j) {
                    this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.print.trash") + String.format("0x%02x", ans)));
                    if (System.currentTimeMillis() - start > (long)timeout) break;
                }
                if (ans != 2) {
                    throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.nostx") + " " + ans);
                }
                LinkedList<Byte> answer = new LinkedList<Byte>();
                answer.add((byte)2);
                boolean mask = false;
                for (int j = 0; j < 100; ++j) {
                    byte[] part = this.port.read(1);
                    answer.add(part[0]);
                    if (part[0] == 3 && !mask) break;
                    if (mask) {
                        mask = false;
                        continue;
                    }
                    if (part[0] != 16) continue;
                    mask = true;
                }
                byte[] part = this.port.read(1);
                answer.add(part[0]);
                this.log.debug((Object)("<<" + ByteUtils.toString(answer)));
                byte[] result = new byte[answer.size()];
                for (int j = 0; j < answer.size(); ++j) {
                    result[j] = (Byte)answer.get(j);
                }
                if (result.length < 3) {
                    this.port.write((byte)21);
                    throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.shtans") + " " + result.length);
                }
                if (result[result.length - 1] != this.getCrc(result)) {
                    this.port.write((byte)21);
                    throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.wrongcrc"));
                }
                this.port.write((byte)6);
                this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.print.geteot") + "(0x04)"));
                part = this.port.read(1);
                if (part[0] == 4) {
                    this.log.debug((Object)LocBundle.getMessageLog((String)"rma.print.eotsucc"));
                } else {
                    this.log.debug((Object)("<<" + String.format("0x%02x", part[0])));
                }
                return result;
            }
            catch (IOException ex) {
                last = ex;
                this.log.debug((Object)(LocBundle.getMessageLog((String)"rma.print.excherr") + " " + i), (Throwable)ex);
                continue;
            }
        }
        throw new IOException(MessageFormat.format("rma.kkm.resnoreaded", this.readAttempts), last);
    }

    private void sendData(byte[] data) throws IOException {
        IOException last = null;
        try {
            int ans;
            int i;
            boolean flag = false;
            long t = System.currentTimeMillis();
            for (i = 0; i < 100; ++i) {
                try {
                    this.port.setTimeout(1500);
                    this.port.write((byte)5);
                    this.log.debug((Object)">>ENQ");
                    ans = this.port.readByte();
                    if (ans == 5) {
                        this.log.debug((Object)"<<ENQ");
                        Thread.sleep(1000L);
                        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.enqnoack"));
                    }
                    if (ans == 21) {
                        this.log.debug((Object)"<<NAK");
                        Thread.sleep(1500L);
                        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.naknoack"));
                    }
                    if (ans != 6) {
                        this.log.debug((Object)("<<" + String.format("0x%02x", ans)));
                        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.noack") + " " + ans);
                    }
                    this.log.debug((Object)"<<ASC");
                    flag = true;
                    break;
                }
                catch (IOException ex) {
                    this.port.setTimeout(3);
                    this.port.tryRead(100);
                    last = ex;
                    this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.excherrrg"), (Throwable)ex);
                    if (System.currentTimeMillis() - t > 3000L) break;
                    continue;
                }
            }
            if (!flag) {
                this.log.error((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.askcomerr"), this.readAttempts));
                throw new IOException(MessageFormat.format(LocBundle.getMessageEx((String)"rma.kkm.asknosended"), this.readAttempts), last);
            }
            flag = false;
            for (i = 0; i < this.readAttempts; ++i) {
                try {
                    this.port.setTimeout(1500);
                    this.log.debug((Object)(">>" + ByteUtils.toString(data)));
                    this.port.write(data);
                    this.port.setTimeout(500);
                    ans = this.port.readByte();
                    if (ans == 5) {
                        this.log.debug((Object)"<<ENQ");
                        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.enqnoack"));
                    }
                    if (ans == 21) {
                        this.log.debug((Object)"<<NAK");
                        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.naknoack"));
                    }
                    if (ans != 6) {
                        this.log.debug((Object)("<<" + String.format("0x%02x", ans)));
                        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.noack") + " " + ans);
                    }
                    this.log.debug((Object)"<<ASK");
                    flag = true;
                    break;
                }
                catch (IOException ex) {
                    last = ex;
                    this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.excherrwc"), (Throwable)ex);
                    continue;
                }
            }
            if (!flag) {
                this.log.error((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.excherrsnd"), this.readAttempts));
                throw new IOException(MessageFormat.format("rma.kkm.datanosended", this.readAttempts), last);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException(ex);
        }
        finally {
            this.log.debug((Object)">>EOT");
            try {
                this.port.write((byte)4);
            }
            catch (IOException ex) {
                this.log.error((Object)LocBundle.getMessageLog((String)"rma.print.errwreot"), (Throwable)ex);
            }
        }
    }

    private byte[] getData(byte cmd, byte[] password, byte[] data) {
        byte[] unmasked = new byte[1 + password.length + (data == null ? 0 : data.length)];
        if (password.length > 0) {
            unmasked[0] = password[0];
            unmasked[1] = password[1];
        }
        unmasked[password.length] = cmd;
        if (data != null) {
            System.arraycopy(data, 0, unmasked, password.length + 1, data.length);
        }
        LinkedList<Byte> masked = new LinkedList<Byte>();
        for (byte b : unmasked) {
            if (b == 16 || b == 3) {
                masked.add((byte)16);
                masked.add(b);
                continue;
            }
            masked.add(b);
        }
        byte[] result = new byte[masked.size() + 3];
        result[0] = 2;
        for (int i = 0; i < masked.size(); ++i) {
            result[1 + i] = (Byte)masked.get(i);
        }
        result[result.length - 2] = 3;
        result[result.length - 1] = this.getCrc(result);
        return result;
    }

    private byte getCrc(byte[] message) {
        if (message == null || message.length < 2) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.wrongdtfcrc"));
        }
        byte crc = 0;
        for (int i = 1; i < message.length - 1; ++i) {
            crc = (byte)(crc ^ message[i]);
        }
        return crc;
    }

    private void logDataFlow(String name, byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        StringBuilder result = new StringBuilder();
        if (name != null && !name.isEmpty()) {
            result.append(name).append(": ");
        }
        for (int i = 0; i < data.length; ++i) {
            result.append(String.format("0x%02x ", data[i]));
        }
        System.out.println(result.toString());
    }
}

