/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm.atol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import rmai18n.LocBundle;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.NoSuchDeviceException;
import ru.softlogic.rma.print.kkm.SerialDeviceApi;
import ru.softlogic.rma.print.kkm.atol.AtolConnection;
import ru.softlogic.rma.print.kkm.atol.AtolLongState;
import ru.softlogic.rma.print.kkm.atol.AtolShortState;
import ru.softlogic.rma.print.kkm.atol.AtolType;
import ru.softlogic.rma.print.kkm.atol.AtolVersion;
import ru.softlogic.rma.utils.ArrayUtils;

public class AtolApi
implements SerialDeviceApi {
    public static final byte CUT_FULL = 0;
    public static final byte CUT_PART = 1;
    public static final byte OPER_EXEC = 0;
    public static final byte OPER_VERIFY = 1;
    public static final byte PAY_TYPE_CASH = 1;
    public static final byte PAY_TYPE_CASHLESS = 2;
    public static final byte CHECK_TYPE_SALE = 1;
    public static final byte CHECK_TYPE_RETURN = 2;
    public static final byte CHECK_TYPE_CANCEL = 3;
    public static final byte MODE_REG = 1;
    public static final byte MODE_REP_X = 2;
    public static final byte MODE_REP_Z = 3;
    public static final byte MODE_PROG = 4;
    public static final byte MODE_FP = 5;
    public static final byte MODE_EKLZ = 6;
    public static final byte SOURCE_CPU_KKM = 1;
    public static final byte SOURCE_CPU_MEM = 2;
    public static final byte SOURCE_CPU_BOOTBLOCK = 3;
    public static final byte SOURCE_CPU_PRN = 4;
    public static final byte SOURCE_CPU_PRN_BOOTBLOCK = 5;
    public static final int OK = 0;
    public static final int ERR_NEED_CLOSE_Z = 136;
    private SerialPort serialPort;
    private Map<Boolean, SerialParams[]> serialParams;
    private AtolConnection conn;
    private byte[] password;
    private byte[] passwordFp;

    public AtolApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("Need SerialPort");
        }
        this.serialPort = port;
        this.conn = new AtolConnection(port);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(4800, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(2400, DataBits.Eight, StopBits.One, Parity.None)});
        this.password = new byte[]{0, 0};
        this.passwordFp = new byte[]{0, 0, 0, 48};
    }

    public AtolLongState getLongState() throws IOException {
        byte[] data = this.conn.sendCommand(63, this.password, null, null);
        if (data != null && data[0] == 68 && data.length == 30) {
            AtolLongState state = new AtolLongState();
            state.setKassir(data[1]);
            state.setKkmNumber(data[2]);
            state.setFlags(data[9]);
            state.setFactoryNumber(this.convert(new byte[]{data[10], data[11], data[12], data[13]}));
            state.setSoftwareVersion("" + (char)data[15] + "." + (char)data[16]);
            try {
                state.setCheckNumber(Short.parseShort(this.convert(new byte[]{data[18], data[19]})));
            }
            catch (NumberFormatException ex) {
                state.setCheckNumber((short)0);
            }
            state.setCheckState(data[22]);
            return state;
        }
        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.wrongansw"));
    }

    public int selectMode(byte mode) throws IOException {
        return this.getErrorCode(this.conn.sendCommand(86, this.password, new byte[]{mode, this.passwordFp[0], this.passwordFp[1], this.passwordFp[2], this.passwordFp[3]}, null));
    }

    public int putReportsToMemory() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(180, this.password, new byte[0], null));
    }

    public int printReportsFromMemory() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(181, this.password, new byte[0], null));
    }

    public int exitMode() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(72, this.password, null, 5000));
    }

    public int openCheck(byte flag, byte checkType) throws IOException {
        return this.getErrorCode(this.conn.sendCommand(146, this.password, new byte[]{flag, checkType}, null));
    }

    public int calculationCheck(byte flag, byte payType, int sum) throws IOException {
        byte[] bsum = this.convert(sum);
        byte[] data = new byte[7];
        data[0] = flag;
        data[1] = payType;
        System.arraycopy(bsum, 0, data, 2, 5);
        return this.getErrorCode(this.conn.sendCommand(153, this.password, data, null));
    }

    public int closeCheck(byte flag, byte payType, int sum) throws IOException {
        byte[] bsum = this.convert(sum);
        byte[] data = new byte[7];
        data[0] = flag;
        data[1] = payType;
        System.arraycopy(bsum, 0, data, 2, 5);
        return this.getErrorCode(this.conn.sendCommand(74, this.password, data, null));
    }

    public int addOperation(byte flag, int price, int count, byte section) throws IOException {
        byte[] bprice = this.convert(price);
        byte[] bcount = this.convert(count);
        byte[] data = new byte[12];
        data[0] = flag;
        for (int i = 0; i < 5; ++i) {
            data[i + 1] = bprice[i];
            data[i + 6] = bcount[i];
        }
        data[11] = section;
        return this.getErrorCode(this.conn.sendCommand(82, this.password, data, null));
    }

    public int addReversal(byte flag, int price, int count, byte section) throws IOException {
        byte[] bprice = this.convert(price);
        byte[] bcount = this.convert(count);
        byte[] data = new byte[12];
        data[0] = flag;
        for (int i = 0; i < 5; ++i) {
            data[i + 1] = bprice[i];
            data[i + 6] = bcount[i];
        }
        data[11] = section;
        return this.getErrorCode(this.conn.sendCommand(78, this.password, data, null));
    }

    public int addReturn(byte flag, int price, int count) throws IOException {
        byte[] bprice = this.convert(price);
        byte[] bcount = this.convert(count);
        byte[] data = new byte[11];
        data[0] = flag;
        for (int i = 0; i < 5; ++i) {
            data[i + 1] = bprice[i];
            data[i + 6] = bcount[i];
        }
        return this.getErrorCode(this.conn.sendCommand(87, this.password, data, null));
    }

    public int addCash(byte flag, int sum) throws IOException {
        byte[] bsum = this.convert(sum);
        byte[] data = new byte[1 + bsum.length];
        data[0] = flag;
        System.arraycopy(bsum, 0, data, 1, bsum.length);
        return this.getErrorCode(this.conn.sendCommand(73, this.password, data, null));
    }

    public int openSession() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(154, this.password, new byte[]{0}, null));
    }

    public int cancelCheck() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(89, this.password, null, null));
    }

    public AtolShortState getShortState() throws IOException {
        byte[] data = this.conn.sendCommand(69, this.password, null, null);
        if (data != null && data[0] == 85 && data.length == 3) {
            AtolShortState state = new AtolShortState();
            state.setMode(data[1] & 0xF);
            state.setSubmode((data[1] & 0xF0) >> 4);
            state.setStatus(data[2]);
            return state;
        }
        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.wrongansw"));
    }

    public AtolVersion getVersion(byte source) throws IOException {
        byte[] data = this.conn.sendCommand(157, this.password, new byte[]{source}, null);
        if (data != null && data[0] == 85 && data.length == 7) {
            AtolVersion version = new AtolVersion();
            version.setVersion(data[2]);
            version.setSubVersion(data[3]);
            version.setBuild(Integer.parseInt(this.convert(Arrays.copyOfRange(data, 5, 7))));
            return version;
        }
        if (data != null && data[0] == 85 && data[1] == 109) {
            return null;
        }
        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.wrongansw"));
    }

    public AtolType getAtolType() throws IOException {
        byte[] data = this.conn.sendCommand(165, this.password, null, null);
        if (data != null && data[0] == 0 && data.length >= 11) {
            AtolType type = new AtolType();
            type.setProto(data[1]);
            type.setType(data[2]);
            type.setModel(data[3]);
            type.setMode((data[4] << 8) + data[5]);
            type.setVersion(this.convert(Arrays.copyOfRange(data, 6, 10)));
            try {
                type.setName(new String(data, 11, data.length - 11, "866"));
            }
            catch (Throwable ex) {
                type.setName("Unknown");
            }
            return type;
        }
        throw new IOException(LocBundle.getMessageEx((String)"rma.kkm.wrongansw"));
    }

    public int printText(String text) throws IOException {
        if (text == null) {
            return 0;
        }
        return this.getErrorCode(this.conn.sendCommand(76, this.password, text.getBytes("866"), null));
    }

    public int cutPaper(byte cutType) throws IOException {
        return this.getErrorCode(this.conn.sendCommand(117, this.password, new byte[]{cutType}, null));
    }

    public int reportX() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(103, this.password, new byte[]{1}, null));
    }

    public int reportZ() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(90, this.password, new byte[0], null));
    }

    private int getErrorCode(byte[] answer) {
        if (answer.length > 2 && answer[0] == 85) {
            return answer[1] & 0xFF;
        }
        return -1;
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return ArrayUtils.arrayMerge(this.serialParams.get(true), this.serialParams.get(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void look(boolean preferred) throws NoSuchDeviceException {
        this.conn.setAttempts(2);
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.serialPort.putParams(params);
                this.open();
                this.getAtolType();
                return;
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
            }
        }
        throw new NoSuchDeviceException(MessageFormat.format(LocBundle.getMessageEx((String)"rma.kkm.notatol"), this.serialPort.getName()));
    }

    @Override
    public void open() throws IOException {
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public SerialPort getPort() {
        return this.serialPort;
    }

    public byte[] readTable(int table, int row, int field) throws IOException {
        if (table < 1 || table > 255) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.wrongtblnumb"));
        }
        if (table < 1 || table > 16000) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.wrongclmnnumb"));
        }
        if (field < 1 || field > 255) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.wrongfldnumb"));
        }
        byte[] data = new byte[]{(byte)table, (byte)(row >> 8 & 0xFF), (byte)(row & 0xFF), (byte)field};
        byte[] res = this.conn.sendCommand(70, this.password, data, null);
        if (res[1] == 0) {
            byte[] ret = new byte[res.length - 2];
            System.arraycopy(res, 2, ret, 0, ret.length);
            return ret;
        }
        System.out.println(res[1]);
        return null;
    }

    public int writeTable(int table, int row, int field, byte[] value) throws IOException {
        if (table < 1 || table > 255) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.wrongtblnumb"));
        }
        if (table < 1 || table > 16000) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.wrongclmnnumb"));
        }
        if (field < 1 || field > 255) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.wrongfldnumb"));
        }
        if (value == null || value.length == 0) {
            throw new IllegalArgumentException(LocBundle.getMessageEx((String)"rma.kkm.wrongfldval"));
        }
        byte[] data = new byte[4 + value.length];
        data[0] = (byte)table;
        data[1] = (byte)(row >> 8 & 0xFF);
        data[2] = (byte)(row & 0xFF);
        data[3] = (byte)field;
        System.arraycopy(value, 0, data, 4, value.length);
        return this.getErrorCode(this.conn.sendCommand(80, this.password, data, null));
    }

    public byte[] convert(int sum) {
        String str = Integer.toString(sum);
        while (str.length() < 10) {
            str = "0" + str;
        }
        byte b0 = (byte)(Integer.parseInt(str.substring(0, 2), 16) & 0xFF);
        byte b1 = (byte)(Integer.parseInt(str.substring(2, 4), 16) & 0xFF);
        byte b2 = (byte)(Integer.parseInt(str.substring(4, 6), 16) & 0xFF);
        byte b3 = (byte)(Integer.parseInt(str.substring(6, 8), 16) & 0xFF);
        byte b4 = (byte)(Integer.parseInt(str.substring(8), 16) & 0xFF);
        return new byte[]{b0, b1, b2, b3, b4};
    }

    public String convert(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        String res = "";
        for (byte b : data) {
            res = res + String.format("%02x", b);
        }
        return res;
    }

    public byte convertToByte(int value) {
        return (byte)(value % 10 + (value / 10 << 4));
    }

    public int convertFromByte(byte value) {
        return (value & 0xF) + (value >> 4) * 10;
    }

    public int setDate(Date date) throws IOException {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return this.getErrorCode(this.conn.sendCommand(100, this.password, new byte[]{this.convertToByte(c.get(5)), this.convertToByte(c.get(2) + 1), this.convertToByte(c.get(1) % 100)}, null));
    }

    public int setTime(Date date) throws IOException {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return this.getErrorCode(this.conn.sendCommand(75, this.password, new byte[]{this.convertToByte(c.get(11)), this.convertToByte(c.get(12)), this.convertToByte(c.get(13))}, null));
    }

    @Override
    public KkmType getKkmType() {
        return KkmType.Atol;
    }
}

