/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.kkm;

import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.rma.print.kkm.Kkm;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.atol.AtolKkm;
import ru.softlogic.rma.print.kkm.iskra.IskraKkm;
import ru.softlogic.rma.print.kkm.mercury.MercuryKkm;
import ru.softlogic.rma.print.kkm.shtrih.ShtrihKkm;

public class KkmFactory {
    public static Kkm createKkm(KkmType type, String port, Integer speed) {
        try {
            switch (type) {
                case ShtrihM: {
                    ShtrihKkm kkm = new ShtrihKkm(new SerialPort(port, new SerialParams(speed, DataBits.Eight, StopBits.One, Parity.None)));
                    return kkm;
                }
                case Atol: {
                    AtolKkm kkm = new AtolKkm(new SerialPort(port, new SerialParams(speed, DataBits.Eight, StopBits.One, Parity.None)));
                    return kkm;
                }
                case Iskra: {
                    IskraKkm kkm = new IskraKkm(new SerialPort(port, new SerialParams(speed, DataBits.Eight, StopBits.One, Parity.None)));
                    return kkm;
                }
                case Mercury: {
                    MercuryKkm kkm = new MercuryKkm(new SerialPort(port, new SerialParams(speed, DataBits.Eight, StopBits.One, Parity.None)));
                    return kkm;
                }
            }
            return null;
        }
        catch (Throwable ex) {
            Logger.getLogger((String)"print").error((Object)LocBundle.getMessageLog((String)"rma.print.kkmcrderr"), ex);
            return null;
        }
    }
}

