/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.ipp.lpt;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.rma.print.Printer;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.ipp.lpt.LPTHelper;
import ru.softlogic.rma.print.ipp.lpt.LPTPrinterModel;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ShiftInfoResult;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.kkm.render.RenderFactory;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;

public class LPTPrinter
implements Printer {
    private String fileName;
    private String encoding;
    private Logger log;
    private boolean isReverse;
    private LPTPrinterModel model;

    public LPTPrinter(String fileName, String encoding, boolean isReverse, LPTPrinterModel model) {
        this.fileName = fileName;
        this.encoding = encoding;
        this.isReverse = isReverse;
        if (model == null) {
            throw new IllegalArgumentException("LPT Printer model cann't be null");
        }
        this.model = model;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    protected void print(String image) throws Exception {
        String file = this.fileName;
        PrintWriter pw = null;
        ParallelPort port = null;
        try {
            port = new ParallelPort(file);
            port.setTimeout(3000);
            this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u043f\u043e\u0440\u0442");
            port.open();
            this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043e\u0442\u043a\u0440\u044b\u043b\u0438. \u041f\u0438\u0448\u0435\u043c startbytes \u043c\u043e\u0434\u0435\u043b\u044c");
            port.write(LPTHelper.getStartBytes(this.model));
            this.log.info((Object)"\u0417\u0430\u043f\u0438\u0441\u0430\u043b\u0438 \u043c\u043e\u0434\u0435\u043b\u044c.");
            if (this.isReverse) {
                this.log.info((Object)"isReverse. \u041f\u0438\u0448\u0435\u043c reverse");
                port.write(LPTHelper.getReverseBytes(this.model));
            }
            this.log.info((Object)"\u041f\u0438\u0448\u0435\u043c \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0443");
            port.write(image.getBytes(this.encoding));
            this.log.info((Object)"\u0417\u0430\u043f\u0438\u0441\u0430\u043b\u0438 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0443.");
            if (this.isReverse) {
                this.log.info((Object)"isReverse. \u041f\u0438\u0448\u0435\u043c reverse");
                port.write(LPTHelper.getEndReverseBytes(this.model));
            }
            this.log.info((Object)"\u041f\u0438\u0448\u0435\u043c endbytes \u043c\u043e\u0434\u0435\u043b\u044c");
            port.write(LPTHelper.getEndBytes(this.model));
            this.log.info((Object)"\u0417\u0430\u043f\u0438\u0441\u0430\u043b\u0438. \u0440\u0430\u0431\u043e\u0442\u0443 \u043e\u043a\u043e\u043d\u0447\u0438\u043b\u0438");
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            if (port.isError() && port.isPaperOut()) {
                throw new Exception(LocBundle.getMessage((String)"printer.lpt.nopaper"));
            }
            if (port.isError()) {
                throw new Exception(LocBundle.getMessage((String)"printer.lpt.error"));
            }
            throw e;
        }
        finally {
            try {
                this.log.info((Object)"\u041f\u044b\u0442\u0430\u0435\u043c\u0441\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u043f\u043e\u0440\u0442");
                port.close();
            }
            catch (Exception ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
            try {
                this.log.info((Object)"\u041f\u044b\u0442\u0430\u0435\u043c\u0441\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c pw");
                pw.close();
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    public OperationResult printRequest(RequestData data) throws IOException {
        try {
            Render render = RenderFactory.createLPTRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, data.getJob().getRecord().getDocType(), this.isReverse);
            this.print(render.process(data, 0));
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return new OperationResult(1, true, ex.getMessage(), data.getJob());
        }
        return new OperationResult(0, false, false, null);
    }

    @Override
    public OperationResult printDocumentNotFiscalMode(OperationData data) throws IOException {
        return this.printDocument(data);
    }

    @Override
    public CustomOperationResult printCustomNotFiscalMode(CustomData data) throws IOException {
        try {
            Render render = RenderFactory.createLPTRender(data != null && data.getMenuItem() != null ? data.getMenuItem().getService().getCheckRender() : null, null, this.isReverse);
            this.print(render.process(data, 0));
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return new CustomOperationResult(1, true, ex.getMessage(), data);
        }
        return new CustomOperationResult(0, false, false, null);
    }

    @Override
    public OperationResult printDocument(OperationData data) throws IOException {
        try {
            Render render = RenderFactory.createLPTRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, data.getJob().getRecord().getDocType(), this.isReverse);
            this.print(render.process(data, 0));
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return new OperationResult(1, true, ex.getMessage(), data.getJob());
        }
        return new OperationResult(0, false, false, null);
    }

    @Override
    public ShiftInfoResult printShiftInfoResult(ShiftOperatingPrintRequest req) throws IOException {
        return null;
    }
}

