/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.ipp.fiscal;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.fiscal.client.FiscalClient;
import ru.softlogic.fiscal.client.FiscalClientStub;
import ru.softlogic.fiscal.client.HttpFiscalClient;
import ru.softlogic.rma.connector.model.Dealer;
import ru.softlogic.rma.connector.model.Point;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.print.ipp.fiscal.FileFiscalPrinter;
import ru.softlogic.rma.print.ipp.fiscal.FiscalIppPrinter;
import ru.softlogic.rma.print.ipp.fiscal.FiscalServerPrinter;
import ru.softlogic.rma.utils.ReferenceUtil;

public class FiscalServerPrinterFactory {
    public static FiscalIppPrinter createPrinter(String name, int fontSize, String fontName) {
        Logger log = Logger.getLogger((String)"app");
        log.info((Object)(LocBundle.getMessageLog((String)"rma.print.fndprntr") + " " + name));
        FiscalServerPrinter printer = null;
        if (name != null && !name.isEmpty()) {
            for (PrintService ps : PrintServiceLookup.lookupPrintServices(null, null)) {
                if (!ps.getName().equals(name)) continue;
                log.info((Object)(LocBundle.getMessageLog((String)"rma.print.fndprntrsucc") + " " + name));
                printer = new FiscalIppPrinter(ps, fontSize, fontName);
                break;
            }
        }
        if (printer == null) {
            log.info((Object)LocBundle.getMessageLog((String)"rma.print.prntrntfnd"));
        }
        printer.setClient(FiscalServerPrinterFactory.createHttpFiscalClient());
        return printer;
    }

    public static FileFiscalPrinter createFilePrinter(String path, String file, String encoding, boolean fiscalMode) {
        Logger log = Logger.getLogger((String)"app");
        if (path == null || file == null || encoding == null) {
            return null;
        }
        FileFiscalPrinter printer = new FileFiscalPrinter(fiscalMode, path, file, encoding);
        printer.setClient(FiscalServerPrinterFactory.createHttpFiscalClient());
        return printer;
    }

    public static FiscalClient createHttpFiscalClient() {
        Logger log = Logger.getLogger((String)"app");
        FiscalClientStub client = null;
        boolean blockOnError = false;
        try {
            References refs = ReferenceUtil.read();
            if (refs == null) {
                log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440, references=null");
                client = new FiscalClientStub();
                return client;
            }
            Dealer dealer = refs.getDealer();
            Point point = refs.getPoint();
            if (dealer != null && point != null) {
                if (dealer.getProperties() == null) {
                    log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440, \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u044e\u0442 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430");
                    client = new FiscalClientStub();
                    return client;
                }
                log.info(dealer.getProperties());
                String id = dealer.getProperties().get("fserver.dealer-id");
                String url = dealer.getProperties().get("fserver.url");
                if (url == null) {
                    log.info((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440, \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0432\u043e\u0439\u0441\u0442\u0441\u0432\u043e fserver.url");
                    client = new FiscalClientStub();
                    return client;
                }
                String login = dealer.getProperties().get("fserver.login");
                if (login == null) {
                    log.info((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440, \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0432\u043e\u0439\u0441\u0442\u0441\u0432\u043e fserver.login");
                    client = new FiscalClientStub();
                    return client;
                }
                String password = dealer.getProperties().get("fserver.password");
                if (password == null) {
                    log.info((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440, \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0432\u043e\u0439\u0441\u0442\u0441\u0432\u043e fserver.password");
                    client = new FiscalClientStub();
                    return client;
                }
                String boe = dealer.getProperties().get("fserver.block-on-error");
                if (boe != null && "false".equals(boe)) {
                    blockOnError = false;
                }
                String timeout = dealer.getProperties().get("fserver.timeout");
                log.info((Object)("Dealer id: " + dealer.getId() + "(" + id + ")"));
                log.info((Object)("Point id: " + point.getId()));
                log.info((Object)("Fiscal server URL: " + url));
                log.info((Object)("Timeout: " + timeout));
                log.info((Object)("Block on error: " + blockOnError));
                client = new HttpFiscalClient(id != null && id.matches("^\\d{1,5}$") ? Integer.parseInt(id) : dealer.getId(), (int)point.getId(), url, login, password, timeout != null && timeout.matches("^[1-5]\\d$") ? Integer.parseInt(timeout) * 1000 : 60000);
                log.info((Object)"\u041a\u043b\u0438\u0435\u043d\u0442 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d");
                return client;
            }
            log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440, dealer=null \u0438\u043b\u0438 point=null");
            client = new FiscalClientStub();
            return client;
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
            log.error((Object)("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440, " + ex));
            client = new FiscalClientStub();
            return client;
        }
    }
}

