/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.ipp.fiscal;

import java.awt.EventQueue;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.fiscal.client.Document;
import ru.softlogic.fiscal.client.FiscalClient;
import ru.softlogic.fiscal.client.RemotePayment;
import ru.softlogic.fiscal.client.Result;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.RmaEvent;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.print.Printer;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.kkm.render.RenderFactory;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;

public abstract class FiscalServerPrinter
implements Printer {
    private FiscalClient client;
    private int lastDoc1;
    private int lastDoc2;
    private int lastDoc3;
    private int lastEklz;
    private int lastKkm;
    private Random rnd = new Random();
    protected Logger log = Logger.getLogger((String)"print");

    public FiscalServerPrinter() {
        this.log.setAdditivity(false);
    }

    public FiscalClient getClient() {
        return this.client;
    }

    public void setClient(FiscalClient client) {
        this.client = client;
    }

    protected Document getDocumentFromServer(OperationData data) {
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u043d\u0430 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0435\u0440: " + data));
        RemotePayment rp = new RemotePayment((int)data.getJob().getRecord().getDoc(), (int)data.getJob().getRecord().getServiceId(), data.getJob().getRecord().getServiceName(), data.getJob().getRecord().getAccount(), data.getJob().getRecord().getSumIncome(), data.getJob().getRecord().getSumOutcome(), data.getJob().getRecord().getSumComm(), 0);
        long start = System.currentTimeMillis();
        try {
            Result doc = this.client.print(rp);
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442: " + doc));
            if (doc.getError() == 0) {
                try {
                    this.lastDoc1 = Integer.parseInt(((Document)doc.getData()).getDoc1());
                    this.lastDoc2 = Integer.parseInt(((Document)doc.getData()).getDoc2());
                    this.lastDoc3 = Integer.parseInt(((Document)doc.getData()).getDoc3());
                    this.lastEklz = Integer.parseInt(((Document)doc.getData()).getEklz());
                    this.lastKkm = Integer.parseInt(((Document)doc.getData()).getKkm());
                }
                catch (Exception ex) {
                    this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438", (Throwable)ex);
                }
                return (Document)doc.getData();
            }
            PersistenceManager.getInstance().putSystemEvent(new RmaEvent(2, "FS: " + data.getJob().getRecord().getAccount() + "-> err:" + doc.getError()));
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430: ", (Throwable)ex);
            try {
                PersistenceManager.getInstance().putSystemEvent(new RmaEvent(2, "FS: " + data.getJob().getRecord().getAccount() + "-> ex:" + ex.getMessage() + ", timeout:" + (System.currentTimeMillis() - start)));
            }
            catch (PersistenceException persistenceException) {
                // empty catch block
            }
        }
        return this.getFakeDocument();
    }

    private Document getFakeDocument() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy HH:mm");
        int kpp = this.rnd.nextInt(10000);
        ++this.lastDoc1;
        ++this.lastDoc2;
        ++this.lastDoc3;
        Document doc = new Document(String.format("%04d", this.lastDoc1), String.format("%08d", this.lastDoc2), String.format("%08d", this.lastDoc3), String.format("%06d", kpp), String.format("%08d", this.lastKkm), sdf.format(new Date()), String.format("%10d", this.lastEklz), "Yarus01K");
        this.log.info((Object)("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442: " + doc));
        return doc;
    }

    protected abstract void print(String var1);

    public abstract boolean isFiscalMode();

    @Override
    public OperationResult printRequest(final RequestData data) throws IOException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, data.getJob().getRecord().getDocType());
                FiscalServerPrinter.this.print(render.process(data, 0));
            }
        });
        return new OperationResult(0, false, false, null);
    }

    @Override
    public OperationResult printDocument(final OperationData data) throws IOException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, data.getJob().getRecord().getDocType());
                Document doc = FiscalServerPrinter.this.getDocumentFromServer(data);
                HashMap<String, String> add = new HashMap<String, String>();
                add.put("doc1", doc.getDoc1());
                add.put("doc2", doc.getDoc2());
                add.put("doc3", doc.getDoc3());
                add.put("date", doc.getDate());
                add.put("eklz", doc.getEklz());
                add.put("kkm", doc.getKkm());
                add.put("kpp", doc.getKpp());
                add.put("type", doc.getDeviceType());
                data.getJob().getRecord().setAdditional(add);
                String image = render.process(data, 0);
                if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
                    image = data.getJob().getBeginAdvText() + "<br>" + image;
                }
                if (data.getJob().getEndAdvText() != null && !data.getJob().getEndAdvText().isEmpty()) {
                    image = image + "<br>" + data.getJob().getEndAdvText();
                }
                FiscalServerPrinter.this.print(image);
            }
        });
        return new OperationResult(0, false, false, null);
    }

    @Override
    public OperationResult printDocumentNotFiscalMode(final OperationData data) throws IOException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, data.getJob().getRecord().getDocType());
                String image = render.process(data, 0);
                if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
                    image = data.getJob().getBeginAdvText() + "<br>" + image;
                }
                if (data.getJob().getEndAdvText() != null && !data.getJob().getEndAdvText().isEmpty()) {
                    image = image + "<br>" + data.getJob().getEndAdvText();
                }
                FiscalServerPrinter.this.print(image);
            }
        });
        return new OperationResult(0, false, false, null);
    }

    @Override
    public CustomOperationResult printCustomNotFiscalMode(final CustomData data) throws IOException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Render render = RenderFactory.createRender(data.getTemplate(), (KkmType)null);
                FiscalServerPrinter.this.print(render.process(data, 0));
            }
        });
        return new CustomOperationResult(0, false, false, null);
    }
}

