/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.ipp.fiscal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.text.MessageFormat;
import javax.print.PrintService;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.swing.JTextPane;
import rmai18n.LocBundle;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.ipp.fiscal.FiscalServerPrinter;
import ru.softlogic.rma.print.kkm.ShiftInfoResult;

public class FiscalIppPrinter
extends FiscalServerPrinter {
    private PrintService printService;
    private int fontSize;
    private String fontFamily;

    public FiscalIppPrinter(PrintService printService, int fontSize, String fontFamily) {
        if (printService == null) {
            throw new IllegalArgumentException("Need PrintService");
        }
        if (fontSize < 7 || fontSize > 15) {
            fontSize = 10;
        }
        if (fontFamily == null || fontFamily.isEmpty()) {
            fontFamily = "Verdana";
        }
        this.printService = printService;
        this.fontSize = fontSize;
        this.fontFamily = fontFamily;
    }

    @Override
    protected void print(String image) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.printimg") + " " + image));
        int width = 80;
        MediaPrintableArea printableArea = (MediaPrintableArea)this.printService.getDefaultAttributeValue(MediaPrintableArea.class);
        if (printableArea != null) {
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.prntar") + "=" + printableArea));
            width = (int)printableArea.getWidth(1000) - 2;
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.prntwidth"), width));
        } else {
            this.log.error((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.prntwidthntst"), width));
        }
        String text = "<table style=\"font-size:" + this.fontSize + "pt;font-family:" + this.fontFamily + ";\"><tr><td width=\"" + width + "mm\">" + image + "</td></tr></table>";
        try {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.startprnt"));
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setPrintService(this.printService);
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.servinsd"));
            pj.setJobName("Payment");
            pj.setCopies(1);
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.prnttaskcrd"));
            PageFormat pageFormat = pj.defaultPage();
            pageFormat.setOrientation(1);
            Paper paper = pageFormat.getPaper();
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.origsize"), paper.getWidth(), paper.getHeight()));
            paper.setImageableArea(0.0, 0.0, paper.getWidth() - 0.0, paper.getHeight() - 0.0);
            pageFormat.setPaper(paper);
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.rendchk"));
            pj.setPrintable(new IppRender(text), pageFormat);
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.putjob"));
            pj.print();
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.putjobsucc"));
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
    }

    @Override
    public boolean isFiscalMode() {
        return true;
    }

    @Override
    public ShiftInfoResult printShiftInfoResult(ShiftOperatingPrintRequest req) throws IOException {
        this.log.error((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0447\u0435\u0440\u0435\u0437 \u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u041a\u041a\u041c \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        throw new IllegalStateException("\u041f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d\u044b \u0447\u0435\u0440\u0435\u0437 \u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u041a\u041a\u041c \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    private class IppRender
    implements Printable {
        private String text;

        public IppRender(String text) {
            this.text = text;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex == 0) {
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                JTextPane pane = new JTextPane();
                pane.setForeground(Color.white);
                pane.setOpaque(false);
                pane.setContentType("text/html");
                pane.setSize(800, 1200);
                pane.setText(this.text);
                pane.print(graphics);
                return 0;
            }
            return 1;
        }
    }
}

