/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.ipp.fiscal;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.ipp.fiscal.FiscalServerPrinter;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ShiftInfoResult;
import ru.softlogic.rma.print.kkm.render.RenderFactory;
import ru.softlogic.rma.print.kkm.render.TemplateRender;
import ru.softlogic.rma.print.queue.OperationData;

public class FileFiscalPrinter
extends FiscalServerPrinter {
    private boolean fiscalMode;
    private String filePath;
    private String fileName;
    private String encoding;

    public FileFiscalPrinter(boolean fiscalMode, String filePath, String fileName, String encoding) {
        this.fiscalMode = fiscalMode;
        this.filePath = filePath;
        this.fileName = fileName;
        this.encoding = encoding;
    }

    @Override
    public OperationResult printDocument(OperationData data) throws IOException {
        if (this.fiscalMode) {
            return super.printDocument(data);
        }
        return super.printDocumentNotFiscalMode(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void print(String image) {
        String file = this.fileName;
        if (file.contains("{") && file.contains("}")) {
            SimpleDateFormat sdf = new SimpleDateFormat(file.substring(file.indexOf("{") + 1, file.lastIndexOf("}")));
            file = file.replaceAll("\\{.*\\}", sdf.format(new Date()));
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new File(this.filePath, file), this.encoding);
            pw.write(image);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isFiscalMode() {
        return this.fiscalMode;
    }

    @Override
    public ShiftInfoResult printShiftInfoResult(ShiftOperatingPrintRequest req) throws IOException {
        if (req == null) {
            throw new IOException("\u0417\u0430\u0434\u0430\u043d \u043f\u0443\u0441\u0442\u043e\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043b\u044f \u043f\u0435\u0447\u0430\u0442\u0438");
        }
        TemplateRender render = (TemplateRender)RenderFactory.createShiftResultRender();
        if (render == null) {
            throw new IOException("\u0428\u0430\u0431\u043b\u043e\u043d \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        String image = render.process(req, 0);
        this.print(image);
        this.log.info((Object)"Print ok");
        return new ShiftInfoResult("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u0432 \u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
    }
}

