/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.ipp;

import java.io.IOException;
import java.util.Set;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.persistence.DocType;
import ru.softlogic.rma.print.Printer;
import ru.softlogic.rma.print.ipp.ComplexPrinter;
import ru.softlogic.rma.print.ipp.IppPrinter;
import ru.softlogic.rma.print.ipp.lpt.LPTPrinter;
import ru.softlogic.rma.print.ipp.lpt.LPTPrinterModel;

public class IppPrinterFactory {
    public static IppPrinter createPrinter(String name, int fontSize, String fontName) {
        Logger log = Logger.getLogger((String)"app");
        log.info((Object)(LocBundle.getMessageLog((String)"rma.print.fndprntr") + " " + name));
        IppPrinter printer = null;
        if (name != null && !name.isEmpty()) {
            for (PrintService ps : PrintServiceLookup.lookupPrintServices(null, null)) {
                if (!ps.getName().equals(name)) continue;
                log.info((Object)(LocBundle.getMessageLog((String)"rma.print.fndprntrsucc") + " " + name));
                printer = new IppPrinter(ps, fontSize, fontName);
                break;
            }
        }
        if (printer == null) {
            log.info((Object)LocBundle.getMessageLog((String)"rma.print.prntrntfnd"));
            PrintService ps = PrintServiceLookup.lookupDefaultPrintService();
            if (ps != null) {
                printer = new IppPrinter(ps, fontSize, fontName);
                Configuration.getInstance().getData().setPrinterName(ps.getName());
                try {
                    Configuration.getInstance().writeConfiguration();
                }
                catch (IOException ex) {
                    log.error((Object)ex, (Throwable)ex);
                }
            }
        }
        return printer;
    }

    public static LPTPrinter createLPTPrinter(String file, String encoding, boolean isReverse, LPTPrinterModel model) {
        Logger log = Logger.getLogger((String)"app");
        log.info((Object)(LocBundle.getMessageLog((String)"rma.print.fndprntr") + " " + file));
        try {
            return new LPTPrinter(file, encoding, isReverse, model);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static Printer createComplexPrinter(IppPrinter ippPrinter, LPTPrinter lptPrinter, Set<DocType> docTypes) {
        Logger log = Logger.getLogger((String)"app");
        log.info((Object)(LocBundle.getMessageLog((String)"rma.print.fndprntr") + " ComplexPrinter"));
        try {
            return new ComplexPrinter(ippPrinter, lptPrinter, docTypes);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

