/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.ipp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.demo.DOMSource;
import org.fit.cssbox.layout.BrowserCanvas;
import org.w3c.dom.Document;
import rmai18n.LocBundle;
import ru.softlogic.rma.app.Configuration;
import ru.softlogic.rma.persistence.DocType;
import ru.softlogic.rma.print.Printer;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.KkmType;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ShiftInfoResult;
import ru.softlogic.rma.print.kkm.render.Render;
import ru.softlogic.rma.print.kkm.render.RenderFactory;
import ru.softlogic.rma.print.kkm.render.TemplateRender;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;
import ru.softlogic.rma.utils.PathUtils;

public class IppPrinter
implements Printer {
    private PrintService printService;
    private int fontSize;
    private String fontFamily;
    private Logger log;

    public IppPrinter(PrintService printService, int fontSize, String fontFamily) {
        if (printService == null) {
            throw new IllegalArgumentException("Need PrintService");
        }
        if (fontSize < 7 || fontSize > 15) {
            fontSize = 10;
        }
        if (fontFamily == null || fontFamily.isEmpty()) {
            fontFamily = "Verdana";
        }
        this.printService = printService;
        this.fontSize = fontSize;
        this.fontFamily = fontFamily;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        try {
            this.log.info((Object)"_____ DocFalvor:________________");
            DocFlavor[] docFalvor = printService.getSupportedDocFlavors();
            for (int i = 0; i < docFalvor.length; ++i) {
                this.log.info((Object)docFalvor[i].getMimeType());
            }
            this.log.info((Object)"________________________________");
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
    }

    @Override
    public OperationResult printRequest(final RequestData data) throws IOException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? "" + data.getJob().getMenuItem().getService().getCode() : null, data.getJob().getRecord().getDocType());
                IppPrinter.this.print(render.process(data, 0), true);
            }
        });
        return new OperationResult(0, false, false, null);
    }

    @Override
    public OperationResult printDocument(final OperationData data) throws IOException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                data.getJob().getRecord().setDocType(Configuration.getInstance().getData().getDocType());
                Render render = RenderFactory.createRender(data != null && data.getJob().getMenuItem() != null ? data.getJob().getMenuItem().getService().getCheckRender() : null, data.getJob().getRecord().getDocType());
                String template = Desktop.isDesktopSupported() && DocType.PD4.equals((Object)data.getJob().getRecord().getDocType()) ? "newPD4" : null;
                Render render2 = RenderFactory.createRender(template, data.getJob().getRecord().getDocType());
                template = null;
                String image = "";
                if (template != null && data.getJob().getRecord().getDocType() == DocType.PD4) {
                    IppPrinter.this.log.info((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e \u0440\u0435\u043d\u0434\u0435\u04402 \u0434\u043b\u044f \u0447\u0435\u043a\u0430");
                    image = render2.process(data, 0);
                    if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
                        image = data.getJob().getBeginAdvText() + "<br>" + image;
                    }
                    if (data.getJob().getEndAdvText() != null && !data.getJob().getEndAdvText().isEmpty()) {
                        image = image + "<br>" + data.getJob().getEndAdvText();
                    }
                    try {
                        IppPrinter.this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0432 printThroughPdf2");
                        IppPrinter.this.printThroughPdf2(image);
                    }
                    catch (IOException ex) {
                        IppPrinter.this.log.error((Object)ex, (Throwable)ex);
                        IppPrinter.this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0441\u0442\u0430\u0440\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d \u041f\u04144");
                        image = render.process(data, 0);
                        if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
                            image = data.getJob().getBeginAdvText() + "<br>" + image;
                        }
                        if (data.getJob().getEndAdvText() != null && !data.getJob().getEndAdvText().isEmpty()) {
                            image = image + "<br>" + data.getJob().getEndAdvText();
                        }
                        IppPrinter.this.print(image, true);
                    }
                    catch (Exception ex) {
                        IppPrinter.this.log.error((Object)ex, (Throwable)ex);
                    }
                    IppPrinter.this.log.info((Object)"Print PDF ok");
                } else {
                    IppPrinter.this.log.info((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e \u0440\u0435\u043d\u0434\u0435\u04401 \u0434\u043b\u044f \u0447\u0435\u043a\u0430");
                    image = render.process(data, 0);
                    if (data.getJob().getBeginAdvText() != null && !data.getJob().getBeginAdvText().isEmpty()) {
                        image = data.getJob().getBeginAdvText() + "<br>" + image;
                    }
                    if (data.getJob().getEndAdvText() != null && !data.getJob().getEndAdvText().isEmpty()) {
                        image = image + "<br>" + data.getJob().getEndAdvText();
                    }
                    IppPrinter.this.print(image, true);
                    IppPrinter.this.log.info((Object)"Print ok");
                }
            }
        });
        return new OperationResult(0, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printThroughPdf(String image) {
        this.log.info((Object)"PDF");
        this.log.info((Object)("image = " + image));
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            this.log.info((Object)"new ITextRenderer");
            this.log.info((Object)"get ITextRenderer");
            try {
                this.log.info((Object)"set font");
                this.log.info((Object)"seted font");
            }
            catch (Exception e) {
                this.log.error((Object)LocBundle.getMessageEx((String)"rma.ippprinter.errloadttf"));
            }
            this.log.info((Object)"set image");
            this.log.info((Object)"createdPDF");
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            SimpleDoc doc = new SimpleDoc(is, DocFlavor.INPUT_STREAM.PDF, null);
            this.log.info((Object)"get SimpleDoc");
            HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
            attr.add(new Copies(1));
            attr.add(new JobName("print-Pd4.pdf", null));
            this.log.info((Object)"send to print");
            DocPrintJob pj = this.printService.createPrintJob();
            pj.print(doc, attr);
            this.log.info((Object)"sended to print");
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printThroughPdf2(String image) throws IOException {
        FileUtils.writeStringToFile((File)new File(PathUtils.getTmpPath(), "html.html"), (String)image);
        this.log.info((Object)"PDF");
        this.log.info((Object)("image = " + image));
        OutputStream os = null;
        try {
            File pdfFile = new File(PathUtils.getTmpPath(), "tempPD4.pdf");
            os = new FileOutputStream(pdfFile);
            this.log.info((Object)"new ITextRenderer");
            this.log.info((Object)"get ITextRenderer");
            try {
                this.log.info((Object)"set font");
                this.log.info((Object)"seted font");
            }
            catch (Exception e) {
                this.log.error((Object)LocBundle.getMessageEx((String)"rma.ippprinter.errloadttf"));
            }
            this.log.info((Object)"set image");
            try {
                os.close();
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
            this.log.info((Object)"createdPDF");
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Desktop desktop = Desktop.getDesktop();
                        IppPrinter.this.log.info((Object)"send to Desktop.print()");
                        try {
                            desktop.print(new File(PathUtils.getTmpPath() + "tempPD4.pdf"));
                        }
                        catch (IOException ex) {
                            IppPrinter.this.log.error((Object)ex, (Throwable)ex);
                        }
                        IppPrinter.this.log.info((Object)"sended to Desktop.print()");
                    }
                });
            }
            catch (Exception ex) {
                this.log.error((Object)ex, (Throwable)ex);
            }
        }
        catch (FileNotFoundException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printThroughPs(String image) {
        this.log.info((Object)"PS");
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            this.log.info((Object)"new ITextRenderer");
            this.log.info((Object)"get ITextRenderer");
            try {
                this.log.info((Object)"set font");
                this.log.info((Object)"seted font");
            }
            catch (Exception e) {
                this.log.error((Object)LocBundle.getMessageEx((String)"rma.ippprinter.errloadttf"));
            }
            this.log.info((Object)"set image");
            this.log.info((Object)"createdPDF");
            ByteArrayInputStream is1 = new ByteArrayInputStream(os.toByteArray());
            DocPrintJob printJob = this.printService.createPrintJob();
            SimpleDoc doc1 = new SimpleDoc(is1, DocFlavor.INPUT_STREAM.PDF, null);
            HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
            attributes.add(new Destination(new URI(("file:" + PathUtils.getAppHome() + File.separator + "postscript.ps").replaceAll("\\\\", "/"))));
            printJob.print(doc1, attributes);
            ((InputStream)is1).close();
            this.log.info((Object)"createdPS");
            File f = new File(PathUtils.getAppHome() + File.separator + "postscript.ps");
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            SimpleDoc doc = new SimpleDoc(new FileInputStream(f), DocFlavor.INPUT_STREAM.AUTOSENSE, null);
            this.log.info((Object)"get SimpleDoc");
            HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
            attr.add(new Copies(1));
            attr.add(new JobName("print-Pd4.pdf", null));
            this.log.info((Object)"send to print");
            DocPrintJob pj = this.printService.createPrintJob();
            pj.print(doc, attr);
            this.log.info((Object)"sended to print");
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    private void print(String image, boolean html) {
        this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.printimg") + " " + image));
        int width = 80;
        MediaPrintableArea printableArea = (MediaPrintableArea)this.printService.getDefaultAttributeValue(MediaPrintableArea.class);
        if (printableArea != null) {
            this.log.info((Object)(LocBundle.getMessageLog((String)"rma.print.prntar") + "=" + printableArea));
            width = (int)printableArea.getWidth(1000) - 2;
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.prntwidth"), width));
        } else {
            this.log.error((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.prntwidthntst"), width));
        }
        try {
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.startprnt"));
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setPrintService(this.printService);
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.servinsd"));
            pj.setJobName("Payment");
            pj.setCopies(1);
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.prnttaskcrd"));
            PageFormat pageFormat = pj.defaultPage();
            pageFormat.setOrientation(1);
            Paper paper = pageFormat.getPaper();
            this.log.info((Object)MessageFormat.format(LocBundle.getMessageLog((String)"rma.print.origsize"), paper.getWidth(), paper.getHeight()));
            paper.setImageableArea(0.0, 0.0, paper.getWidth() - 0.0, paper.getHeight() - 0.0);
            pageFormat.setPaper(paper);
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.rendchk"));
            if (html) {
                pj.setPrintable(new IppRender(image), pageFormat);
            } else {
                pj.setPrintable(new IppRenderUnHtml(image, width), pageFormat);
            }
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.putjob"));
            pj.print();
            this.log.info((Object)LocBundle.getMessageLog((String)"rma.print.putjobsucc"));
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
    }

    @Override
    public OperationResult printDocumentNotFiscalMode(OperationData data) throws IOException {
        return this.printDocument(data);
    }

    @Override
    public CustomOperationResult printCustomNotFiscalMode(final CustomData data) throws IOException {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Render render = RenderFactory.createRender(data.getTemplate(), (KkmType)null);
                IppPrinter.this.print(render.process(data, 0), true);
            }
        });
        return new CustomOperationResult(0, false, false, null);
    }

    @Override
    public ShiftInfoResult printShiftInfoResult(ShiftOperatingPrintRequest req) throws IOException {
        if (req == null) {
            throw new IOException("\u0417\u0430\u0434\u0430\u043d \u043f\u0443\u0441\u0442\u043e\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043b\u044f \u043f\u0435\u0447\u0430\u0442\u0438");
        }
        TemplateRender render = (TemplateRender)RenderFactory.createShiftResultRender();
        if (render == null) {
            throw new IOException("\u0428\u0430\u0431\u043b\u043e\u043d \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        String image = render.process(req, 0);
        this.print(image, true);
        this.log.info((Object)"Print ok");
        return new ShiftInfoResult("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u0432 \u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
    }

    private class IppRenderUnHtml
    implements Printable {
        private String text;
        private List<String> textList;
        private int width;

        public IppRenderUnHtml(String text, int width) {
            this.text = text.replaceAll("\n", "<br>");
            this.width = width;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (this.textList == null) {
                this.initTextLines();
            }
            IppPrinter.this.log.info((Object)("textList.size=" + this.textList.size()));
            IppPrinter.this.log.info((Object)("pageIndex=" + pageIndex));
            if (pageIndex > this.textList.size() - 1) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            JTextPane pane = new JTextPane();
            pane.setForeground(Color.white);
            pane.setOpaque(false);
            pane.setContentType("text/html");
            pane.setSize(800, 1200);
            pane.setText(this.textList.get(pageIndex));
            pane.print(graphics);
            return 0;
        }

        private void initTextLines() {
            this.textList = new LinkedList<String>();
            String pref = "<table style=\"font-size:" + IppPrinter.this.fontSize + "pt;font-family:" + IppPrinter.this.fontFamily + ";\"><tr><td width=\"" + this.width + "mm\">";
            String suf = "</td></tr></table>";
            String[] part = this.text.split("<new page>");
            for (int i = 0; i < part.length; ++i) {
                part[i] = pref.concat(part[i]).concat(suf);
            }
            this.textList = Arrays.asList(part);
            if (this.textList.isEmpty()) {
                this.textList.add(pref + this.text + suf);
            }
        }
    }

    private class IppRender
    implements Printable {
        private String text;

        public IppRender(String text) {
            this.text = text;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex == 0) {
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                try {
                    DOMSource parser = new DOMSource((InputStream)new ByteArrayInputStream(this.text.getBytes("UTF-8")));
                    Document doc = parser.parse();
                    DOMAnalyzer da = new DOMAnalyzer(doc, null);
                    da.attributesToStyles();
                    da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
                    da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
                    da.getStyleSheets();
                    BrowserCanvas bc = new BrowserCanvas(da.getRoot(), da, new Dimension(800, 1200), null);
                    JScrollPane documentScroll = new JScrollPane();
                    documentScroll.setViewportView((Component)bc);
                    bc.getViewport().setBgcolor(Color.WHITE);
                    bc.redrawBoxes();
                    BufferedImage image = bc.getImage();
                    graphics.drawImage(image, 0, 0, (int)pageFormat.getPaper().getImageableWidth(), (int)pageFormat.getPaper().getImageableHeight(), null);
                }
                catch (Exception ex) {
                    IppPrinter.this.log.error((Object)ex, (Throwable)ex);
                    return 1;
                }
                return 0;
            }
            return 1;
        }
    }
}

