/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.ipp;

import java.text.SimpleDateFormat;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.model.Dealer;
import ru.softlogic.rma.connector.model.Point;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.utils.SumFormatter;

public class ImageUtil {
    public static String getImage(Record record, References references) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        Dealer d = references.getDealer();
        Point p = references.getPoint();
        sb.append(LocBundle.getMessage((String)"rma.print.firm")).append(" ").append(d.getName()).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.inn")).append(" ").append(d.getInn()).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.pointcode")).append(" ").append(Short.toString(p.getId())).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.pointname")).append(" ").append(p.getName()).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.pointaddr")).append(" ").append(p.getCityName()).append(", ").append(p.getAddress()).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.kassir")).append(" ").append(p.getOperator()).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.time")).append(" ").append(sdf.format(record.getCreated())).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.docnumb")).append(" ").append(Short.toString(record.getDoc())).append("<br>");
        sb.append("<hr>");
        sb.append(LocBundle.getMessage((String)"rma.print.serv")).append(" ").append(record.getServiceName()).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.numb")).append(" ").append(record.getAccount()).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.income")).append(" ").append(SumFormatter.format(record.getSumIncome())).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.outcome")).append(" ").append(SumFormatter.format(record.getSumOutcome())).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.comm")).append(" ").append(SumFormatter.format(record.getSumComm())).append("<br>");
        sb.append("<hr>");
        sb.append(LocBundle.getMessage((String)"rma.print.support")).append(" ").append(d.getSupport()).append("<br>");
        sb.append(LocBundle.getMessage((String)"rma.print.savechk")).append("<br>");
        return sb.toString();
    }
}

