/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print.ipp;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.persistence.DocType;
import ru.softlogic.rma.print.Printer;
import ru.softlogic.rma.print.ShiftOperatingPrintRequest;
import ru.softlogic.rma.print.ipp.IppPrinter;
import ru.softlogic.rma.print.ipp.lpt.LPTPrinter;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ShiftInfoResult;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.RequestData;

public class ComplexPrinter
implements Printer {
    private IppPrinter ippPrinter;
    private LPTPrinter lptPrinter;
    private Set<DocType> lptDocTypes;
    private Logger log;

    public ComplexPrinter(IppPrinter ippPrinter, LPTPrinter lptPrinter, Set<DocType> lptDocTypes) {
        if (ippPrinter == null && lptPrinter == null) {
            throw new IllegalArgumentException("Need Printer");
        }
        this.ippPrinter = ippPrinter;
        this.lptPrinter = lptPrinter;
        if (lptDocTypes == null) {
            lptDocTypes = new HashSet<DocType>();
        }
        this.lptDocTypes = lptDocTypes;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    @Override
    public OperationResult printRequest(RequestData data) throws IOException {
        if (this.lptDocTypes.contains((Object)data.getJob().getRecord().getDocType()) && this.lptPrinter != null) {
            return this.lptPrinter.printRequest(data);
        }
        if (this.ippPrinter != null) {
            return this.ippPrinter.printRequest(data);
        }
        return new OperationResult(1, true, LocBundle.getMessage((String)"Print.printer_not_set"), data.getJob());
    }

    @Override
    public OperationResult printDocument(OperationData data) throws IOException {
        if (this.lptDocTypes.contains((Object)data.getJob().getRecord().getDocType()) && this.lptPrinter != null) {
            return this.lptPrinter.printDocument(data);
        }
        if (this.ippPrinter != null) {
            return this.ippPrinter.printDocument(data);
        }
        return new OperationResult(1, true, LocBundle.getMessage((String)"Print.printer_not_set"), data.getJob());
    }

    @Override
    public OperationResult printDocumentNotFiscalMode(OperationData data) throws IOException {
        return this.printDocument(data);
    }

    @Override
    public CustomOperationResult printCustomNotFiscalMode(CustomData data) throws IOException {
        if (this.lptDocTypes.contains((Object)data.getDocType()) && this.lptPrinter != null) {
            return this.lptPrinter.printCustomNotFiscalMode(data);
        }
        if (this.ippPrinter != null) {
            return this.lptPrinter.printCustomNotFiscalMode(data);
        }
        return new CustomOperationResult(1, true, LocBundle.getMessage((String)"Print.printer_not_set"), null);
    }

    @Override
    public ShiftInfoResult printShiftInfoResult(ShiftOperatingPrintRequest req) throws IOException {
        return null;
    }
}

