/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.print;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;
import ru.softlogic.rma.RmaPaymentJob;
import ru.softlogic.rma.print.kkm.CustomOperationResult;
import ru.softlogic.rma.print.kkm.OperationResult;
import ru.softlogic.rma.print.kkm.ReportResult;
import ru.softlogic.rma.print.queue.CustomData;
import ru.softlogic.rma.print.queue.OperationData;
import ru.softlogic.rma.print.queue.PrinterQueue;
import ru.softlogic.rma.print.queue.PrinterQueueListener;
import ru.softlogic.rma.print.queue.RequestData;
import ru.softlogic.rma.utils.SocketUtil;
import ru.softlogic.rma.utils.ThreadUtil;

public class RemoteListener
implements Runnable {
    public static final int DEFAULT_PORT = 39999;
    private int port;
    Logger logger = Logger.getLogger((String)"print");

    public RemoteListener(int port) {
        this.port = port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        PrinterQueue printerQueue = PrinterQueue.getInstance();
        printerQueue.addRemoteListener(new RemotePrinterListener());
        ServerSocket sock = null;
        while (!Thread.interrupted()) {
            try {
                if (this.port < 0) {
                    if (sock != null) {
                        SocketUtil.close(sock);
                        sock = null;
                    }
                    ThreadUtil.sleep(3000L);
                    continue;
                }
                if (sock == null) {
                    sock = new ServerSocket(this.port);
                    sock.setSoTimeout(5000);
                }
                Socket accept = null;
                try {
                    accept = sock.accept();
                }
                catch (Exception e) {
                    ThreadUtil.sleep(3000L);
                    continue;
                }
                accept.setSoTimeout(60000);
                this.logger.info((Object)"\u0412\u0445\u043e\u0434\u044f\u0449\u0435\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435");
                InputStream inputStream = accept.getInputStream();
                this.logger.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
                ObjectInputStream ois = new ObjectInputStream(inputStream);
                this.logger.info((Object)"\u041f\u043e\u0442\u043e\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0441\u043e\u0437\u0434\u0430\u043d");
                try {
                    Object data;
                    this.logger.info((Object)"\u0427\u0438\u0442\u0430\u044e \u043e\u0431\u044a\u0435\u043a\u0442");
                    Object obj = ois.readObject();
                    if (obj instanceof RequestData) {
                        data = (RequestData)obj;
                        ((RequestData)data).getJob().setSocket(accept);
                        this.logger.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c " + data));
                        printerQueue.addRequest((RequestData)data);
                    } else if (obj instanceof OperationData) {
                        data = (OperationData)obj;
                        ((OperationData)data).getJob().setSocket(accept);
                        this.logger.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c " + data));
                        printerQueue.addOperation((OperationData)data);
                    } else if (obj instanceof CustomData) {
                        data = (CustomData)obj;
                        ((CustomData)data).setSocket(accept);
                        this.logger.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c " + data));
                        printerQueue.addCustom((CustomData)data);
                    }
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex, (Throwable)ex);
                }
            }
            catch (IOException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
            }
            ThreadUtil.sleep(1000L);
        }
        SocketUtil.close(sock);
    }

    private class RemotePrinterListener
    implements PrinterQueueListener {
        Logger logger = Logger.getLogger((String)"print");

        private RemotePrinterListener() {
        }

        @Override
        public void onReportResult(ReportResult reportResult) {
            this.logger.info((Object)"\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0435 \u0441\u043d\u044f\u0442\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }

        @Override
        public void onReportException(Exception exception) {
            this.logger.info((Object)"\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0435 \u0441\u043d\u044f\u0442\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOperationResult(OperationResult operationResult) {
            if (operationResult.getJob() == null) {
                this.logger.info((Object)("\u0411\u044b\u043b\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430.\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + operationResult));
                return;
            }
            Socket socket = operationResult.getJob().getSocket();
            operationResult.getJob().setSocket(null);
            if (socket == null || socket.isClosed()) {
                this.logger.error((Object)"\u043d\u0435\u0442 \u0441\u043e\u043a\u0435\u0442\u0430");
            } else {
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(socket.getOutputStream());
                    oos.writeObject(operationResult);
                    oos.flush();
                    this.logger.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442");
                }
                catch (IOException ex) {
                    this.logger.error((Object)ex, (Throwable)ex);
                }
                finally {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {}
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOperationException(Exception ex, RmaPaymentJob job) {
            if (job == null) {
                this.logger.error((Object)("\u0411\u044b\u043b\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430." + ex), (Throwable)ex);
                return;
            }
            Socket socket = job.getSocket();
            job.setSocket(null);
            if (socket == null || socket.isClosed()) {
                this.logger.error((Object)"\u043d\u0435\u0442 \u0441\u043e\u043a\u0435\u0442\u0430");
            } else {
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(socket.getOutputStream());
                    oos.writeObject(ex);
                    oos.flush();
                    this.logger.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442");
                }
                catch (IOException ex1) {
                    this.logger.error((Object)ex1, (Throwable)ex1);
                }
                finally {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {}
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestResult(OperationResult operationResult) {
            Socket socket = operationResult.getJob().getSocket();
            operationResult.getJob().setSocket(null);
            if (socket == null || socket.isClosed()) {
                this.logger.error((Object)"\u043d\u0435\u0442 \u0441\u043e\u043a\u0435\u0442\u0430");
            } else {
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(socket.getOutputStream());
                    oos.writeObject(operationResult);
                    oos.flush();
                    this.logger.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442");
                }
                catch (IOException ex) {
                    this.logger.error((Object)ex, (Throwable)ex);
                }
                finally {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {}
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestException(Exception ex, RmaPaymentJob job) {
            Socket socket = job.getSocket();
            job.setSocket(null);
            if (socket == null || socket.isClosed()) {
                this.logger.error((Object)"\u043d\u0435\u0442 \u0441\u043e\u043a\u0435\u0442\u0430");
            } else {
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(socket.getOutputStream());
                    oos.writeObject(ex);
                    oos.flush();
                    this.logger.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442");
                }
                catch (IOException ex1) {
                    this.logger.error((Object)ex1, (Throwable)ex1);
                }
                finally {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {}
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        @Override
        public void onInfoResult(String info) {
            this.logger.info((Object)"\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }

        @Override
        public void onInfoException(Exception ex) {
            this.logger.info((Object)"\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }

        @Override
        public void onResetResult(ReportResult reportResult) {
            this.logger.info((Object)"\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0431\u0440\u043e\u0441 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }

        @Override
        public void onResetException(Exception ex) {
            this.logger.info((Object)"\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0431\u0440\u043e\u0441 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCustomResult(CustomOperationResult operationResult) {
            Socket socket = operationResult.getData().getSocket();
            operationResult.getData().setSocket(null);
            if (socket == null || socket.isClosed()) {
                this.logger.error((Object)"\u043d\u0435\u0442 \u0441\u043e\u043a\u0435\u0442\u0430");
            } else {
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(socket.getOutputStream());
                    oos.writeObject(operationResult);
                    oos.flush();
                    this.logger.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442");
                }
                catch (IOException ex) {
                    this.logger.error((Object)ex, (Throwable)ex);
                }
                finally {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {}
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCustomException(Exception ex, CustomData operation) {
            Socket socket = operation.getSocket();
            operation.setSocket(null);
            if (socket == null || socket.isClosed()) {
                this.logger.error((Object)"\u043d\u0435\u0442 \u0441\u043e\u043a\u0435\u0442\u0430");
            } else {
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(socket.getOutputStream());
                    oos.writeObject(ex);
                    oos.flush();
                    this.logger.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442");
                }
                catch (IOException ex1) {
                    this.logger.error((Object)ex1, (Throwable)ex1);
                }
                finally {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {}
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        @Override
        public void onShiftReportResult(String s) {
            this.logger.info((Object)"\u0423\u0434\u0430\u043b\u0451\u043d\u043d\u0430\u044f \u043f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }

        @Override
        public void onShiftException(Exception ex, String result) {
            this.logger.info((Object)"\u0423\u0434\u0430\u043b\u0451\u043d\u043d\u0430\u044f \u043f\u0435\u0447\u0430\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u043c\u0435\u043d \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }
    }
}

