/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.persistence.v2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.model.Shift;
import ru.softlogic.rma.connector.model.ShiftInfo;
import ru.softlogic.rma.persistence.BalanceRecord;
import ru.softlogic.rma.persistence.CloseShift;
import ru.softlogic.rma.persistence.Condition;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RecordsInfo;
import ru.softlogic.rma.persistence.ReverseOperation;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.persistence.RmaEvent;
import ru.softlogic.rma.persistence.ShiftCondition;
import ru.softlogic.rma.persistence.accessors.AccessorAttributesUtil;
import ru.softlogic.rma.persistence.accessors.AccessorBalanceRercordUtil;
import ru.softlogic.rma.persistence.accessors.AccessorBaseEventUtil;
import ru.softlogic.rma.persistence.accessors.AccessorCloseShiftUtil;
import ru.softlogic.rma.persistence.accessors.AccessorOperationsUtil;
import ru.softlogic.rma.persistence.accessors.AccessorRecordsInfoUtil;
import ru.softlogic.rma.persistence.accessors.AccessorReveseOperation;
import ru.softlogic.rma.persistence.accessors.AccessorShiftInfoUtil;
import ru.softlogic.rma.persistence.accessors.AccessorShiftUtil;
import ru.softlogic.rma.persistence.accessors.AccessorSystemEventUtil;
import ru.softlogic.rma.persistence.accessors.JDBCUtil;
import ru.softlogic.rma.persistence.events.BaseEvent;
import ru.softlogic.rma.utils.PathUtils;

public class PersistenceManager {
    private int timeout = 1;
    private static PersistenceManager instance = new PersistenceManager();
    private Logger logger = Logger.getLogger((String)"persistence");
    String basePath;

    private PersistenceManager() {
        this.logger.setAdditivity(false);
        this.basePath = PathUtils.getAppPaymentsPath();
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            this.initDatabase();
        }
        catch (ClassNotFoundException ex) {
            this.logger.error((Object)LocBundle.getMessage((String)"rma.persistence.dbdrvnotf"), (Throwable)ex);
        }
    }

    public static PersistenceManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase() {
        this.logger.info((Object)"-----------------------------------------------------------");
        this.logger.info((Object)"\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445");
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection(false);
            stmt = conn.createStatement();
            try {
                stmt.execute("select * from base_event FETCH FIRST ROW ONLY");
                this.logger.info((Object)"\u0422\u0430\u0431\u043b\u0438\u0446\u044b base_event \u0435\u0441\u0442\u044c");
            }
            catch (SQLException ex) {
                this.logger.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 base_event");
                try {
                    stmt.execute("create table base_event(\n  id              BIGINT GENERATED ALWAYS AS IDENTITY,  created         TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,  processed_time  TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,  local_state     SMALLINT DEFAULT 0 NOT NULL,  event_type      SMALLINT NOT NULL,  user_id         VARCHAR(140),  is_final        BOOLEAN DEFAULT FALSE NOT NULL)");
                    stmt.execute("CREATE INDEX base_ev_id_be ON base_event (id)");
                    stmt.execute("CREATE INDEX created_be ON base_event (created)");
                    stmt.execute("CREATE INDEX is_final_be ON base_event (is_final)");
                    stmt.execute("CREATE INDEX event_type_be ON base_event (event_type)");
                    conn.commit();
                    this.logger.info((Object)"\u0442\u0430\u0431\u043b\u0438\u0446\u0430 base_event \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
                }
                catch (SQLException ex1) {
                    this.initRollback("base_event", ex1, conn);
                }
            }
            try {
                stmt.execute("select * from operations FETCH FIRST ROW ONLY");
                this.logger.info((Object)"\u0442\u0430\u0431\u043b\u0438\u0446\u0430 operation \u0435\u0441\u0442\u044c");
            }
            catch (SQLException ex1) {
                this.logger.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 operations");
                try {
                    stmt.execute("create table operations(\n  id               BIGINT NOT NULL UNIQUE,  pid              BIGINT DEFAULT NULL,  id_processing    BIGINT DEFAULT NULL,  created          TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,  doc              SMALLINT DEFAULT 0 NOT NULL,  service_id       SMALLINT NOT NULL,  service_name     VARCHAR(100) NOT NULL,  provider_name    VARCHAR(100),  account          VARCHAR(40) NOT NULL,  account2         VARCHAR(40),  commission_id    SMALLINT NOT NULL,  sum_income       INTEGER NOT NULL,  sum_outcome      INTEGER NOT NULL,  sum_comm         INTEGER NOT NULL,  sum_fee          BIGINT NOT NULL,  comment          VARCHAR(100),  state            SMALLINT DEFAULT 0 NOT NULL,     substate         SMALLINT DEFAULT 0 NOT NULL,  abs_state        SMALLINT DEFAULT 0 NOT NULL,  error_code       SMALLINT DEFAULT NULL,  id_person_create VARCHAR(100) NOT NULL,  id_shift         BIGINT DEFAULT 0 NOT NULL,  print_info       SMALLINT DEFAULT 0 NOT NULL,  processed        TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,  is_canselled     SMALLINT DEFAULT 0 NOT NULL)");
                    stmt.execute("CREATE INDEX created_op ON operations (created)");
                    stmt.execute("CREATE INDEX doc_op ON operations (doc)");
                    stmt.execute("CREATE INDEX sinc_op ON operations (sum_income)");
                    stmt.execute("CREATE INDEX sout_op ON operations (sum_outcome)");
                    stmt.execute("CREATE INDEX state_op ON operations (state)");
                    stmt.execute("CREATE INDEX substate_op ON operations (substate)");
                    stmt.execute("CREATE INDEX abs_state_op ON operations (abs_state)");
                    stmt.execute("CREATE INDEX id_shift_op ON operations (id_shift)");
                    conn.commit();
                    this.logger.info((Object)"\u0422\u0430\u0431\u043b\u0438\u0446\u0430 operations \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
                }
                catch (SQLException ex2) {
                    this.initRollback("operations", ex2, conn);
                }
            }
            try {
                stmt.execute("select * from reverse_operations FETCH FIRST ROW ONLY");
                this.logger.info((Object)"\u0442\u0430\u0431\u043b\u0438\u0446\u0430 reverse_operation \u0435\u0441\u0442\u044c");
            }
            catch (SQLException ex1) {
                try {
                    this.logger.info((Object)"\u0441\u043e\u0437\u0434\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 reverse_operations");
                    stmt.execute("create table reverse_operations(\n  id                  BIGINT NOT NULL UNIQUE,  id_person_create    VARCHAR(100) NOT NULL,  state               SMALLINT NOT NULL,  operation_id        BIGINT REFERENCES OPERATIONS(ID),  comment             VARCHAR(250) NOT NULL)");
                    stmt.execute("CREATE INDEX state_ro ON reverse_operations (state)");
                    stmt.execute("CREATE INDEX pcreate_ro ON reverse_operations (id_person_create)");
                    conn.commit();
                    this.logger.info((Object)"\u0422\u0430\u0431\u043b\u0438\u0446\u0430 reverse_operations \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
                }
                catch (SQLException ex2) {
                    this.initRollback("revese_operations", ex2, conn);
                }
            }
            try {
                stmt.execute("select * from shift FETCH FIRST ROW ONLY");
                this.logger.info((Object)"\u0442\u0430\u0431\u043b\u0438\u0446\u0430 shift \u0435\u0441\u0442\u044c");
            }
            catch (SQLException ex1) {
                this.logger.info((Object)"\u0441\u043e\u0437\u0434\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 shift");
                try {
                    stmt.execute("CREATE TABLE shift(  id                 BIGINT NOT NULL UNIQUE,  id_server          BIGINT NOT NULL,  num                SMALLINT DEFAULT 0,  operating_day_name VARCHAR(100) NOT NULL,  dbegin             TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,  dend               TIMESTAMP DEFAULT NULL,  id_person_open     VARCHAR(100) NOT NULL,  id_person_close    VARCHAR(100) DEFAULT NULL,  fio_person_open    VARCHAR(140) DEFAULT '',  fio_person_close   VARCHAR(140) DEFAULT '',  shift_type         VARCHAR(15) DEFAULT '',  comment            VARCHAR(240) DEFAULT '',  state              SMALLINT NOT NULL)");
                    stmt.execute("CREATE INDEX stype_sh ON shift (shift_type)");
                    stmt.execute("CREATE INDEX shid_sh ON shift (id)");
                    stmt.execute("CREATE INDEX dbegin_sh ON shift (dbegin)");
                    stmt.execute("CREATE INDEX dend_sh ON shift (dend)");
                    stmt.execute("CREATE INDEX id_person_open_sh ON shift (id_person_open)");
                    conn.commit();
                    this.logger.info((Object)"\u0422\u0430\u0431\u043b\u0438\u0446\u0430 shift \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
                }
                catch (SQLException ex2) {
                    this.initRollback("revese_operations", ex2, conn);
                }
            }
            try {
                stmt.execute("select * from close_shift_event FETCH FIRST ROW ONLY");
                this.logger.info((Object)"\u0442\u0430\u0431\u043b\u0438\u0446\u0430 close_shift_event \u0435\u0441\u0442\u044c");
            }
            catch (SQLException ex1) {
                this.logger.info((Object)"\u0441\u043e\u0437\u0434\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 close_shift_event");
                try {
                    stmt.execute("create table close_shift_event(  id BIGINT NOT NULL UNIQUE,  id_person_create VARCHAR(100) NOT NULL,  state SMALLINT NOT NULL,  close_shift_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,  comment VARCHAR(200) DEFAULT '',  id_shift BIGINT NOT NULL)");
                    stmt.execute("CREATE INDEX clshevid_cse ON shift (id)");
                    stmt.execute("CREATE INDEX state_cse ON shift (state)");
                    conn.commit();
                    this.logger.info((Object)"\u0442\u0430\u0431\u043b\u0438\u0446\u0430 close_shift_event \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
                }
                catch (Exception ex2) {
                    this.initRollback("close_shift_event", ex2, conn);
                }
            }
            try {
                stmt.executeQuery("SELECT * FROM attributes FETCH FIRST ROW ONLY");
                this.logger.info((Object)"\u0442\u0430\u0431\u043b\u0438\u0446\u0430 attributes \u0435\u0441\u0442\u044c");
            }
            catch (SQLException ex1) {
                this.logger.info((Object)"\u0441\u043e\u0437\u0434\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 attributes");
                try {
                    stmt.execute("CREATE TABLE attributes(    id             BIGINT GENERATED ALWAYS AS IDENTITY,    id_operation   BIGINT REFERENCES OPERATIONS(ID),    name\t    VARCHAR(255) NOT NULL,    value\t    VARCHAR(4000) NOT NULL,    name_title\t    VARCHAR(255) NOT NULL,    value_title    VARCHAR(4000) NOT NULL)");
                    stmt.execute("CREATE INDEX owner ON attributes (id_operation)");
                    conn.commit();
                    this.logger.info((Object)"\u0422\u0430\u0431\u043b\u0438\u0446\u0430 attributes \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
                }
                catch (SQLException ex2) {
                    this.initRollback("attributes", ex2, conn);
                }
            }
            try {
                stmt.execute("select * from rma_event FETCH FIRST ROW ONLY");
                this.logger.info((Object)"\u0442\u0430\u0431\u043b\u0438\u0446\u0430 rma_event \u0435\u0441\u0442\u044c");
            }
            catch (SQLException ex1) {
                this.logger.info((Object)"\u0441\u043e\u0437\u0434\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 rma_event");
                try {
                    stmt.execute("create table rma_event(  id BIGINT NOT NULL UNIQUE,  comment VARCHAR(150) DEFAULT '',  type SMALLINT NOT NULL)");
                    conn.commit();
                    this.logger.info((Object)"\u0442\u0430\u0431\u043b\u0438\u0446\u0430 rma_event \u0441\u043e\u0437\u0434\u0430\u043d\u0430");
                }
                catch (SQLException ex2) {
                    this.initRollback("rma_event", ex2, conn);
                }
            }
            try {
                stmt.execute("select * from test FETCH FIRST ROWS ONLY");
            }
            catch (SQLException ex1) {
                this.logger.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0446\u0443 test");
                try {
                    stmt.execute("CREATE TABLE test(id INT GENERATED ALWAYS AS IDENTITY)");
                    conn.commit();
                }
                catch (SQLException ex2) {
                    this.initRollback("test", ex2, conn);
                }
            }
            conn.commit();
            this.close(stmt);
            this.close(conn);
        }
        catch (Exception ex) {
            try {
                this.logger.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0431\u0430\u0437\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", (Throwable)ex);
                this.close(stmt);
                this.close(conn);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
    }

    public Record[] getOperationsByCondition(Condition cond) throws PersistenceException {
        return this.getOperationsByCondition(cond, false);
    }

    public Record[] getOperationsByCondition(Condition cond, boolean withAttr) throws PersistenceException {
        this.logger.info((Object)("\u0414\u0435\u043b\u0430\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u0437 \u0431\u0434 \u043f\u043e \u0443\u0441\u043b\u043e\u0432\u0438\u044e " + cond));
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            Record[] recordArray = AccessorOperationsUtil.select(cond, withAttr, conn, this.logger);
            return recordArray;
        }
        catch (SQLException ex) {
            this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u0437 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0439 \u0431\u0434 " + ex.getMessage()));
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public short getShiftState(long id) throws PersistenceException {
        this.logger.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043c\u0435\u043d\u044b, \u0434\u043b\u044f \u0441\u043c\u0435\u043d\u044b id=" + id));
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            short res = AccessorCloseShiftUtil.isExistCloseToShiftId(id, conn, this.logger);
            this.logger.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430, \u043a\u043e\u0434 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438: " + res));
            short s = res;
            return s;
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public ArrayList<String> getSeviceNameByPayments() throws PersistenceException {
        this.logger.info((Object)"\u0412\u044b\u0431\u0438\u0440\u0430\u044e \u0438\u043c\u0435\u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0441 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f\u043c\u0438");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(false);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select service_name from operations  group by service_name FETCH FIRST 1000 ROWS ONLY");
            ArrayList<String> services = new ArrayList<String>();
            while (rs.next()) {
                services.add(rs.getString("service_name"));
            }
            ArrayList<String> arrayList = services;
            return arrayList;
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(true);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM test FETCH FIRST ROWS ONLY");
            boolean bl = true;
            this.close(rs);
            this.close(stmt);
            this.close(conn);
            return bl;
        }
        catch (SQLException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(rs);
            this.close(stmt);
            this.close(conn);
        }
    }

    public List<Shift> getShifts(ShiftCondition condition) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            List<Shift> list = AccessorShiftUtil.getShiftsByCondition(condition, conn, this.logger);
            return list;
        }
        catch (SQLException ex) {
            throw new PersistenceException(LocBundle.getMessageEx((String)"rma.persistance.err"), ex);
        }
        finally {
            this.close(conn);
        }
    }

    public RecordsInfo getRecordsInfoByCondition(Condition conndition) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            RecordsInfo recordsInfo = AccessorRecordsInfoUtil.getRecordsInfoByCondition(conndition, conn, this.logger);
            return recordsInfo;
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public boolean validShiftTime(String type, Date from, Date to) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            boolean bl = AccessorShiftUtil.validShiftTime(type, from, to, conn, this.logger);
            return bl;
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public void updateRecord(Record record) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(false);
            AccessorOperationsUtil.updateRecord(record, conn, this.logger);
            conn.commit();
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            JDBCUtil.rollbackNoException(conn);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public boolean containOperation(Record record) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            boolean bl = AccessorOperationsUtil.contain(record, conn, this.logger);
            return bl;
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public Shift getCurrentShift() throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            Shift shift = AccessorShiftUtil.getCurrentShift(conn, this.logger);
            return shift;
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public void updateShift(Shift sh) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            AccessorShiftUtil.update(sh, conn, this.logger);
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public List<Record> getOperationsByShift(long shiftId) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            List<Record> list = AccessorOperationsUtil.getOperationsByShift(shiftId, conn, this.logger);
            return list;
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public List<BalanceRecord> selectBalanceInfoForShift(long idShift, String personId) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            List<BalanceRecord> list = AccessorBalanceRercordUtil.fetchByShiftAndPerson(idShift, personId, conn, this.logger);
            return list;
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public List<BaseEvent> getQueue(boolean isFinal, boolean isNow) throws PersistenceException {
        this.logger.info((Object)"\u0412\u044b\u0431\u0438\u0440\u0430\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(true);
            String sql = "select * from base_event where is_final=? ";
            if (!isNow) {
                sql = sql + "and {fn TIMESTAMPDIFF(SQL_TSI_MINUTE,processed_time,CURRENT_TIMESTAMP)}>? ";
            }
            stmt = conn.prepareStatement(sql);
            stmt.setBoolean(1, isFinal);
            if (!isNow) {
                stmt.setInt(2, this.timeout);
            }
            rs = stmt.executeQuery();
            LinkedList<BaseEvent> events = new LinkedList<BaseEvent>();
            while (rs.next()) {
                BaseEvent event = new BaseEvent();
                event.setId(rs.getLong("id"));
                event.setIsFinal(rs.getBoolean("is_final"));
                event.setCreated(new Date(rs.getTimestamp("created").getTime()));
                event.setEventType(rs.getShort("event_type"));
                event.setProcessed(new Date(rs.getDate("processed_time").getTime()));
                event.setLocalState(rs.getShort("local_state"));
                event.setEventData(this.getEventData(event.getId(), event.getEventType()));
                events.add(event);
            }
            return events;
        }
        catch (SQLException ex) {
            this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 message=" + ex.getMessage()));
            throw new PersistenceException(ex);
        }
    }

    public Object getEventData(long id, short type) throws PersistenceException {
        switch (type) {
            case 0: {
                return this.getOperationById(id);
            }
            case 3: {
                return this.getCloseShiftById(id);
            }
            case -1: {
                return this.getRmaEventById(id);
            }
            case 1: {
                return this.getReverseOperationById(id);
            }
        }
        return null;
    }

    public void closeShift(Shift shift, String comment) throws PersistenceException {
        Connection conn = null;
        try {
            this.logger.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043c\u0435\u043d\u044b \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c, \u0434\u043b\u044f \u0441\u043c\u0435\u043d\u044b " + shift));
            conn = this.getConnection(false);
            BaseEvent event = new BaseEvent();
            event.setCreated(new Date());
            event.setProcessed(new Date());
            event.setIsFinal(false);
            event.setEventType((short)3);
            event.setLocalState((short)1);
            event.setId(AccessorBaseEventUtil.insert(event, conn, this.logger));
            CloseShift closeShift = new CloseShift();
            closeShift.setId(event.getId());
            closeShift.setCloseTime(shift.getDayEnd());
            closeShift.setServerShiftId(shift.getIdServer());
            closeShift.setState((short)1);
            closeShift.setComment(comment);
            closeShift.setShiftId(shift.getIdServer());
            closeShift.setIdPersonCreate(shift.getIdPersonClose());
            AccessorCloseShiftUtil.insert(closeShift, conn, this.logger);
            event.setLocalState((short)0);
            AccessorBaseEventUtil.update(event, conn, this.logger);
            shift.setStatus((short)1);
            AccessorShiftUtil.update(shift, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e");
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)ex, (Throwable)ex);
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    public CloseShift getCloseShiftById(long id) throws PersistenceException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        CloseShift closeShift = null;
        try {
            this.logger.info((Object)("\u0412\u044b\u0431\u0438\u0440\u0430\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u043c\u0435\u043d\u044b \u0441 id=" + id));
            conn = this.getConnection(true);
            stmt = conn.prepareStatement("select * from close_shift_event where id=?");
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                closeShift = new CloseShift();
                closeShift.setId(rs.getLong("id"));
                closeShift.setIdPersonCreate(rs.getString("id_person_create"));
                closeShift.setState(rs.getShort("state"));
                closeShift.setComment(rs.getString("comment"));
                closeShift.setCloseTime(new Date(rs.getTimestamp("close_shift_time").getTime()));
                closeShift.setShiftId(rs.getLong("id_shift"));
            }
            this.logger.info((Object)("\u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 " + closeShift));
            CloseShift closeShift2 = closeShift;
            this.close(rs);
            this.close(stmt);
            this.close(conn);
            return closeShift2;
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044f message=" + ex.getMessage()));
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
    }

    public RmaEvent getRmaEventById(long id) throws PersistenceException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        RmaEvent event = null;
        try {
            this.logger.info((Object)("\u0414\u0435\u043b\u0430\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441 id=" + id));
            conn = this.getConnection(true);
            stmt = conn.prepareStatement("select * from rma_event where id=?");
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                event = new RmaEvent(rs.getShort("type"), rs.getString("comment"));
                event.setId(id);
            }
            this.logger.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u0431\u043e\u0440\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044f " + event));
            RmaEvent rmaEvent = event;
            this.close(rs);
            this.close(stmt);
            this.close(conn);
            return rmaEvent;
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044f message=" + ex.getMessage()));
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
    }

    public void openShift(Shift shift) throws PersistenceException {
        Connection conn = null;
        try {
            this.logger.info((Object)("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u044e \u0441\u043c\u0435\u043d\u0443 \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0431\u0430\u0437\u0443 " + shift));
            conn = this.getConnection(false);
            BaseEvent baseEvent = new BaseEvent();
            baseEvent.setCreated(shift.getDayBegin());
            baseEvent.setLocalState((short)4);
            baseEvent.setEventType((short)4);
            baseEvent.setIsFinal(true);
            baseEvent.setProcessed(shift.getDayBegin());
            long id = AccessorBaseEventUtil.insert(baseEvent, conn, this.logger);
            shift.setId(id);
            AccessorShiftUtil.insert(shift, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430");
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0441\u0442\u0430\u0432\u043a\u0435 \u0441\u043c\u0435\u043d\u044b \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0431\u0430\u0437\u0443 " + ex.getMessage()));
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    public void addOperation(Record rec) throws PersistenceException {
        Connection conn = null;
        try {
            this.logger.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c " + rec));
            conn = this.getConnection(false);
            BaseEvent event = new BaseEvent();
            event.setIsFinal(false);
            event.setLocalState((short)1);
            event.setCreated(new Date());
            event.setProcessed(new Date());
            event.setEventType((short)0);
            event.setId(AccessorBaseEventUtil.insert(event, conn, this.logger));
            rec.setId(event.getId());
            rec.setProcessed(event.getProcessed());
            AccessorOperationsUtil.insert(rec, conn, this.logger);
            event.setLocalState((short)0);
            AccessorBaseEventUtil.update(event, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b");
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0441\u0442\u0430\u0432\u043a\u0435 \u043e\u043f\u0440\u0435\u0430\u0446\u0438\u0438 \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0431\u0430\u0437\u0443 " + ex.getMessage()));
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    public void addFinalOperation(Record rec) throws PersistenceException {
        Connection conn = null;
        try {
            this.logger.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c " + rec));
            conn = this.getConnection(false);
            BaseEvent event = new BaseEvent();
            event.setIsFinal(true);
            event.setLocalState((short)4);
            event.setCreated(new Date());
            event.setProcessed(new Date());
            event.setEventType((short)0);
            event.setId(AccessorBaseEventUtil.insert(event, conn, this.logger));
            rec.setId(event.getId());
            rec.setProcessed(event.getProcessed());
            AccessorOperationsUtil.insert(rec, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b");
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0441\u0442\u0430\u0432\u043a\u0435 \u043e\u043f\u0440\u0435\u0430\u0446\u0438\u0438 \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0431\u0430\u0437\u0443 " + ex.getMessage()));
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    public void addAllOperations(Record[] records) throws PersistenceException {
        Connection conn = null;
        try {
            this.logger.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043d\u0430\u0431\u043e\u0440 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 records=" + Arrays.toString(records)));
            conn = this.getConnection(false);
            for (Record rec : records) {
                BaseEvent event = new BaseEvent();
                event.setIsFinal(false);
                event.setLocalState((short)1);
                event.setCreated(new Date());
                event.setProcessed(event.getCreated());
                event.setEventType((short)0);
                event.setId(AccessorBaseEventUtil.insert(event, conn, this.logger));
                rec.setId(event.getId());
                AccessorOperationsUtil.insert(rec, conn, this.logger);
                event.setLocalState((short)0);
                AccessorBaseEventUtil.update(event, conn, this.logger);
            }
            conn.commit();
            this.logger.info((Object)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b");
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0441\u0442\u0430\u0432\u043a\u0435 \u043e\u043f\u0440\u0435\u0430\u0446\u0438\u0438 \u0432 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0431\u0430\u0437\u0443 " + ex.getMessage()));
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    public void updateChangedRecord(Record record) throws PersistenceException {
        Connection conn = null;
        try {
            this.logger.info((Object)("\u0414\u0435\u043b\u0430\u044e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 " + record));
            conn = this.getConnection(false);
            AccessorOperationsUtil.updateChangedRecord(record, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u0434\u0435\u043b\u0430\u043d\u043e");
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u043f\u043e\u043b\u0435\u0439 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 message=" + ex.getMessage()));
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    public ReverseOperation getReverseOperationById(long id) throws PersistenceException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ReverseOperation reverseOperation = null;
        try {
            this.logger.info((Object)("\u0414\u0435\u043b\u0430\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 \u043e\u0442\u043c\u0435\u043d\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0441 id=" + id));
            conn = this.getConnection(true);
            stmt = conn.prepareStatement("select * from reverse_operations where id=?");
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                reverseOperation = new ReverseOperation();
                reverseOperation.setId(rs.getLong("id"));
                reverseOperation.setIdPersonCreate(rs.getString("id_person_create"));
                reverseOperation.setState(rs.getShort("state"));
                reverseOperation.setIdOperation(rs.getLong("operation_id"));
            }
            this.logger.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 " + reverseOperation));
            ReverseOperation reverseOperation2 = reverseOperation;
            this.close(rs);
            this.close(stmt);
            this.close(conn);
            return reverseOperation2;
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 message=" + ex.getMessage()));
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
    }

    private void initRollback(String tableName, Exception ex, Connection conn) {
        this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b " + tableName), (Throwable)ex);
        try {
            conn.rollback();
        }
        catch (SQLException ex1) {
            this.logger.error((Object)LocBundle.getMessageLog((String)"rma.persistence.rollberr"), (Throwable)ex1);
        }
    }

    public void updateBaseEvent(BaseEvent event) throws PersistenceException {
        this.logger.info((Object)("\u041e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 " + event));
        Connection conn = null;
        try {
            conn = this.getConnection(false);
            AccessorBaseEventUtil.update(event, conn, this.logger);
            conn.commit();
        }
        catch (SQLException ex) {
            this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0441\u043e\u0431\u044b\u0442\u0438\u044f " + event + " message=" + ex.getMessage()));
            JDBCUtil.rollbackNoException(conn);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public void putSystemEvent(RmaEvent event) throws PersistenceException {
        Connection conn = null;
        try {
            this.logger.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c " + event));
            conn = this.getConnection(false);
            BaseEvent be = new BaseEvent();
            be.setCreated(new Date());
            be.setProcessed(new Date());
            be.setEventType((short)-1);
            be.setIsFinal(false);
            be.setLocalState((short)1);
            long id = AccessorBaseEventUtil.insert(be, conn, this.logger);
            be.setId(id);
            event.setId(id);
            AccessorSystemEventUtil.insert(event, conn, this.logger);
            be.setLocalState((short)0);
            AccessorBaseEventUtil.update(be, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c");
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0441\u0442\u0430\u0432\u043a\u0435 \u0432 \u0431\u0430\u0437\u0443 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044f message=" + ex.getMessage()));
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0441\u0442\u0430\u0432\u043a\u0435 \u0432 \u0431\u0430\u0437\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044f " + event + " message=" + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    public boolean validEventQueue() throws PersistenceException {
        this.logger.info((Object)"\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0436\u0443 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u043d\u0430 \u043f\u0443\u0441\u0442\u043e\u0442\u0443");
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            boolean bl = AccessorBaseEventUtil.isEmpty(conn, this.logger);
            return bl;
        }
        catch (SQLException ex) {
            throw new PersistenceException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u0439 message=" + ex.getMessage(), ex);
        }
        finally {
            this.close(conn);
        }
    }

    public ShiftInfo[] getShiftInfo(String idUser, Date from, Date to, boolean visibleAllShifts) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            ShiftInfo[] shiftInfoArray = AccessorShiftInfoUtil.getShiftInfo(idUser, from, to, visibleAllShifts, conn, this.logger);
            return shiftInfoArray;
        }
        catch (SQLException ex) {
            this.logger.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 \u0438\u0442\u043e\u0433\u043e\u0432 \u0441\u043c\u0435\u043d message=" + ex.getMessage()));
            throw new PersistenceException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 \u0438\u0442\u043e\u0433\u043e\u0432 \u0441\u043c\u0435\u043d", ex);
        }
        finally {
            this.close(conn);
        }
    }

    public void canselByCart(Record rec, String idPerson) throws PersistenceException {
        this.logger.info((Object)("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0436\u0443 \u043e\u0442\u043c\u0435\u043d\u0443 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u0437 \u043a\u043e\u0440\u0437\u0438\u043d\u044b " + rec));
        Connection conn = null;
        try {
            conn = this.getConnection(false);
            BaseEvent be = new BaseEvent();
            be.setCreated(new Date());
            be.setIsFinal(false);
            be.setProcessed(be.getCreated());
            be.setEventType((short)0);
            be.setLocalState((short)1);
            this.logger.info((Object)("\u0412\u0441\u0442\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0434\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u0451\u043d\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + be));
            be.setId(AccessorBaseEventUtil.insert(be, conn, this.logger));
            rec.setProcessed(be.getProcessed());
            rec.setCreated(be.getCreated());
            rec.setId(be.getId());
            rec.setCanselled(true);
            rec.setIdPerson(idPerson);
            rec.setState((short)80);
            rec.setSubstate((short)2);
            this.logger.info((Object)("\u0412\u0441\u0442\u0430\u0432\u043b\u044f\u044e \u043f\u043b\u0430\u0442\u0451\u0436 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 80,2 " + rec));
            AccessorOperationsUtil.insert(rec, conn, this.logger);
            be.setLocalState((short)0);
            AccessorBaseEventUtil.update(be, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u0438 \u043f\u043b\u0430\u0442\u0451\u0436 \u0432\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u044b \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 80,2");
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            JDBCUtil.rollbackNoException(conn);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public void canselAllByCart(Record[] rec, String idPerson) throws PersistenceException {
        this.logger.info((Object)("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0436\u0443 \u043e\u0442\u043c\u0435\u043d\u0443 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u0438\u0437 \u043a\u043e\u0440\u0437\u0438\u043d\u044b " + Arrays.toString(rec)));
        Connection conn = null;
        try {
            conn = this.getConnection(false);
            for (Record record : rec) {
                BaseEvent be = new BaseEvent();
                be.setCreated(new Date());
                be.setIsFinal(false);
                be.setProcessed(be.getCreated());
                be.setEventType((short)0);
                be.setLocalState((short)1);
                this.logger.info((Object)("\u0412\u0441\u0442\u0430\u0432\u043b\u044f\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u0434\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u0451\u043d\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + be));
                be.setId(AccessorBaseEventUtil.insert(be, conn, this.logger));
                record.setProcessed(be.getProcessed());
                record.setCreated(be.getCreated());
                record.setId(be.getId());
                record.setState((short)80);
                record.setSubstate((short)2);
                this.logger.info((Object)("\u0412\u0441\u0442\u0430\u0432\u043b\u044f\u044e \u043f\u043b\u0430\u0442\u0451\u0436 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 80,2 " + record));
                AccessorOperationsUtil.insert(record, conn, this.logger);
                be.setLocalState((short)0);
                AccessorBaseEventUtil.update(be, conn, this.logger);
            }
            this.logger.info((Object)"\u0414\u0435\u043b\u0430\u044e \u043a\u043e\u043c\u043c\u0438\u0442");
            conn.commit();
            this.logger.info((Object)"\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u0438 \u043f\u043b\u0430\u0442\u0451\u0436 \u0432\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u044b \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 80,2");
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            JDBCUtil.rollbackNoException(conn);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public Shift getShifiByIdServer(long id) throws PersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            Shift shift = AccessorShiftUtil.fetchByIdServer(id, conn, this.logger);
            return shift;
        }
        catch (SQLException ex) {
            throw new PersistenceException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u043c\u0435\u043d\u044b \u0441 id=" + id + " message=" + ex.getMessage(), ex);
        }
        finally {
            this.close(conn);
        }
    }

    public Record getOperationById(long id) throws PersistenceException {
        Connection conn = null;
        Record rec = null;
        try {
            Map<String, RmaAttribute> attrs;
            conn = this.getConnection(true);
            rec = AccessorOperationsUtil.fetchById(id, conn, this.logger);
            if (rec != null) {
                attrs = AccessorAttributesUtil.fetchAll(id, conn, this.logger);
                RmaAttribute remove = (RmaAttribute)attrs.remove("id1");
                if (remove != null) {
                    rec.setAccountTitle(remove.getKeyTitle());
                    rec.setAccountValueTitle(remove.getValueTitle());
                }
                if ((remove = (RmaAttribute)attrs.remove("id2")) != null) {
                    rec.setAccount2Title(remove.getKeyTitle());
                    rec.setAccount2ValueTitle(remove.getValueTitle());
                }
                rec.setAttributes(attrs);
            }
            attrs = rec;
            return attrs;
        }
        catch (SQLException ex) {
            throw new PersistenceException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0441 id=" + id + " message=" + ex.getMessage(), ex);
        }
        finally {
            this.close(conn);
        }
    }

    public void canselPaymentByQueue(Record rec, String idPerson) throws PersistenceException {
        this.logger.info((Object)("\u0414\u0435\u043b\u0430\u044e \u043e\u0442\u043c\u0435\u043d\u0443 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + rec));
        Connection conn = null;
        try {
            conn = this.getConnection(false);
            this.logger.info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u043e\u0442\u043c\u0435\u043d\u044b");
            BaseEvent be = new BaseEvent();
            be.setCreated(new Date());
            be.setProcessed(be.getCreated());
            be.setIsFinal(false);
            be.setLocalState((short)1);
            be.setEventType((short)1);
            be.setId(AccessorBaseEventUtil.insert(be, conn, this.logger));
            this.logger.info((Object)("\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u043e " + be));
            this.logger.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e \u043e\u0442\u043c\u0435\u043d\u044b \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c");
            ReverseOperation rev = new ReverseOperation();
            rev.setId(be.getId());
            rev.setIdOperation(rec.getId());
            rev.setIdPersonCreate(idPerson);
            rev.setState((short)0);
            rev.setComment(rec.getComment());
            AccessorReveseOperation.insert(rev, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u041e\u0442\u043c\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c");
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            JDBCUtil.rollbackNoException(conn);
            throw new PersistenceException(ex);
        }
        finally {
            this.close(conn);
        }
    }

    public void updateStateForOperation(long id, short state, short substate) throws PersistenceException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(false);
            stmt = conn.prepareStatement("update from operations set state=?,substate=? where id = ?");
            stmt.setShort(1, state);
            stmt.setShort(2, substate);
            stmt.setLong(3, id);
            stmt.execute();
            conn.commit();
            this.close(stmt);
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 id=" + id, ex);
            }
            catch (Throwable throwable) {
                this.close(stmt);
                this.close(conn);
                throw throwable;
            }
        }
    }

    public void setNormalState(int id, short state, short substate, Short error, short finalStatus, Long processingId, short absState) throws PersistenceException {
        Connection conn = null;
        try {
            this.logger.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441=" + state + " \u0441\u0443\u0431\u0441\u0442\u0430\u0442\u0443\u0441=" + substate + " \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 id=" + id + " isfinal=" + (finalStatus == 1)));
            conn = this.getConnection(false);
            AccessorOperationsUtil.setNormalState(id, state, substate, error, finalStatus, processingId, absState, conn, this.logger);
            AccessorBaseEventUtil.setFinalState(id, finalStatus == 1, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u0421\u0442\u0443\u0442\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)ex, (Throwable)ex);
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    public void setErrorState(long id, short localState) throws PersistenceException {
        Connection conn = null;
        try {
            this.logger.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u043e\u0448\u0438\u0431\u043a\u0443 \u0434\u043b\u044f \u0441\u043e\u0431\u044b\u0442\u0438\u044f " + id + " localState=" + localState));
            conn = this.getConnection(false);
            AccessorBaseEventUtil.setError(id, localState, conn, this.logger);
            conn.commit();
            this.logger.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
            this.close(conn);
        }
        catch (SQLException ex) {
            try {
                this.logger.error((Object)ex, (Throwable)ex);
                JDBCUtil.rollbackNoException(conn);
                throw new PersistenceException(ex);
            }
            catch (Throwable throwable) {
                this.close(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        Connection conn = null;
        try {
            conn = this.getConnection(true);
            DatabaseMetaData dbmd = conn.getMetaData();
            String string = dbmd.getDatabaseProductName() + " " + dbmd.getDatabaseProductVersion();
            return string;
        }
        catch (SQLException ex) {
            this.logger.error((Object)LocBundle.getMessageLog((String)"rma.persistence.getdbvererr"), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            this.close(conn);
        }
    }

    public void shutdown() throws PersistenceException {
        this.logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.stoppingdb"));
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.logger.info((Object)LocBundle.getMessageLog((String)"success"));
    }

    private Connection getConnection(boolean autoCommit) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:derby:" + this.basePath + ";create=true");
        connection.setAutoCommit(autoCommit);
        return connection;
    }

    private void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                this.logger.error((Object)LocBundle.getMessageLog((String)"rma.persistence.erronclsconn"), (Throwable)ex);
            }
        }
    }

    private void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                this.logger.error((Object)LocBundle.getMessageLog((String)"rma.persistence.erronclsstmt"), (Throwable)ex);
            }
        }
    }

    private void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                this.logger.error((Object)LocBundle.getMessageLog((String)"rma.persistence.erronclsrs"), (Throwable)ex);
            }
        }
    }
}

