/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.persistence.accessors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;

public class JDBCUtil {
    public static void rollbackNoException(Connection conn) {
        try {
            conn.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Connection connection, Logger logger) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException ex) {
                logger.error((Object)LocBundle.getMessageLog((String)"rma.persistence.erronclsconn"), (Throwable)ex);
            }
        }
    }

    public static void close(Statement statement, Logger logger) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                logger.error((Object)LocBundle.getMessageLog((String)"rma.persistence.erronclsstmt"), (Throwable)ex);
            }
        }
    }

    public static void close(ResultSet resultSet, Logger logger) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                logger.error((Object)LocBundle.getMessageLog((String)"rma.persistence.erronclsrs"), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getIdentityVal(Connection conn, Logger logger) throws SQLException {
        long l;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("values IDENTITY_VAL_LOCAL()");
            rs.next();
            l = rs.getLong(1);
        }
        catch (Throwable throwable) {
            JDBCUtil.close(rs, logger);
            JDBCUtil.close(stmt, logger);
            throw throwable;
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return l;
    }
}

