/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.persistence.accessors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.rma.connector.model.Shift;
import ru.softlogic.rma.persistence.ShiftCondition;
import ru.softlogic.rma.persistence.accessors.JDBCUtil;

public class AccessorShiftUtil {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
    private static SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd 23:59:59");

    public static long insert(Shift shift, Connection conn, Logger logger) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("insert into shift(\n  id,  id_server,  num,  operating_day_name,  dbegin,  dend,  id_person_open,  id_person_close,  fio_person_open,  fio_person_close,  shift_type,  state) values(?,?,?,?,?,?,?,?,?,?,?,?)");
            stmt.setLong(1, shift.getId());
            stmt.setLong(2, shift.getIdServer());
            stmt.setShort(3, shift.getNum());
            stmt.setString(4, shift.getOperatingDay());
            stmt.setTimestamp(5, new Timestamp(shift.getDayBegin().getTime()));
            stmt.setTimestamp(6, new Timestamp(shift.getDayEnd().getTime()));
            stmt.setString(7, shift.getIdPersonOpen());
            stmt.setString(8, shift.getIdPersonClose());
            stmt.setString(9, shift.getFioPersonOpen());
            stmt.setString(10, shift.getFioPersonClose());
            stmt.setString(11, shift.getShiftTypeCode());
            stmt.setShort(12, shift.getStatus());
            stmt.executeUpdate();
            long l = JDBCUtil.getIdentityVal(conn, logger);
            return l;
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            JDBCUtil.close(stmt, logger);
        }
    }

    public static void update(Shift shift, Connection conn, Logger logger) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("update shift set   operating_day_name = ?,  dbegin = ?,  dend = ?,  id_person_open = ?,  id_person_close = ?,  fio_person_open = ?,  fio_person_close = ?,  shift_type = ?,  state = ?  where id=?");
            stmt.setString(1, shift.getOperatingDay());
            stmt.setTimestamp(2, new Timestamp(shift.getDayBegin().getTime()));
            stmt.setTimestamp(3, new Timestamp(shift.getDayEnd().getTime()));
            stmt.setString(4, shift.getIdPersonOpen());
            stmt.setString(5, shift.getIdPersonClose());
            stmt.setString(6, shift.getFioPersonOpen());
            stmt.setString(7, shift.getFioPersonClose());
            stmt.setString(8, shift.getShiftTypeCode());
            stmt.setShort(9, shift.getStatus());
            stmt.setLong(10, shift.getId());
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            JDBCUtil.close(stmt, logger);
        }
    }

    public static Shift fetchByIdServer(long id, Connection conn, Logger logger) throws SQLException {
        Shift shift;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Shift shift2 = null;
        try {
            stmt = conn.prepareStatement("select * from shift where id_server = ?");
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                shift2 = new Shift();
                shift2.setId(rs.getLong("id"));
                shift2.setIdServer(rs.getLong("id_server"));
                shift2.setNum(rs.getShort("num"));
                shift2.setOperatingDay("operating_day_name");
                shift2.setDayBegin(new Date(rs.getTimestamp("dbegin").getTime()));
                shift2.setDayEnd(new Date(rs.getTimestamp("dend").getTime()));
                shift2.setIdPersonOpen(rs.getString("id_person_open"));
                shift2.setIdPersonClose(rs.getString("id_person_close"));
                shift2.setFioPersonOpen(rs.getString("fio_person_open"));
                shift2.setFioPersonClose(rs.getString("fio_person_open"));
                shift2.setShiftTypeCode(rs.getString("shift_type"));
                shift2.setComment(rs.getString("comment"));
                shift2.setStatus(rs.getShort("state"));
            }
            shift = shift2;
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return shift;
    }

    public static Shift getCurrentShift(Connection conn, Logger logger) throws SQLException {
        Shift shift;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT * FROM shift where 1=1  ORDER BY id DESC FETCH FIRST ROW ONLY");
            Shift shift2 = null;
            if (rs.next()) {
                shift2 = new Shift();
                shift2.setId(rs.getLong("id"));
                shift2.setNum(rs.getShort("num"));
                shift2.setIdServer(rs.getLong("id_server"));
                shift2.setOperatingDay(rs.getString("operating_day_name"));
                shift2.setDayBegin(new Date(rs.getTimestamp("dbegin").getTime()));
                if (rs.getTimestamp("dend") != null) {
                    shift2.setDayEnd(new Date(rs.getTimestamp("dend").getTime()));
                }
                shift2.setIdPersonOpen(rs.getString("id_person_open"));
                shift2.setIdPersonClose(rs.getString("id_person_close"));
                shift2.setFioPersonOpen(rs.getString("fio_person_open"));
                shift2.setFioPersonClose(rs.getString("fio_person_close"));
                shift2.setShiftTypeCode(rs.getString("shift_type"));
                shift2.setStatus(rs.getShort("state"));
            }
            shift = shift2;
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return shift;
    }

    public static List<Shift> getShiftsByCondition(ShiftCondition condition, Connection conn, Logger logger) throws SQLException {
        LinkedList<Shift> linkedList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            String query = null;
            query = condition == null ? "select * from shift by id desk fetch first row only" : "select * from shift where 1=1 " + (condition.getFrom() == null ? "" : " and dbegin>='" + sdf.format(condition.getFrom()) + "'\n") + (condition.getTo() == null ? "" : " and dbegin<='" + sdf1.format(condition.getTo()) + "'\n") + " order by id";
            System.out.println(query);
            rs = stmt.executeQuery(query);
            LinkedList<Shift> shifts = new LinkedList<Shift>();
            while (rs.next()) {
                Shift shift = new Shift();
                shift.setId(rs.getLong("id"));
                shift.setNum(rs.getShort("num"));
                shift.setOperatingDay(rs.getString("operating_day_name"));
                shift.setDayBegin(new Date(rs.getTimestamp("dbegin").getTime()));
                if (rs.getTimestamp("dend") != null) {
                    shift.setDayEnd(new Date(rs.getTimestamp("dend").getTime()));
                }
                shift.setIdPersonOpen(rs.getString("id_person_open"));
                shift.setIdPersonClose(rs.getString("id_person_close"));
                shift.setFioPersonOpen(rs.getString("fio_person_open"));
                shift.setFioPersonClose(rs.getString("fio_person_close"));
                shift.setStatus(rs.getShort("state"));
                shift.setShiftTypeCode(rs.getString("shift_type"));
                shifts.add(shift);
            }
            linkedList = shifts;
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return linkedList;
    }

    public static boolean validShiftTime(String type, Date from, Date to, Connection conn, Logger logger) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("select 1 from shift where shift_type=? and dbegin < ? and dend >= ?");
            stmt.setString(1, type);
            stmt.setTimestamp(2, new Timestamp(from.getTime()));
            stmt.setTimestamp(3, new Timestamp(to.getTime()));
            rs = stmt.executeQuery();
            bl = !rs.next();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(conn, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(conn, logger);
        return bl;
    }
}

