/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.persistence.accessors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.rma.connector.model.ShiftInfo;
import ru.softlogic.rma.persistence.accessors.JDBCUtil;

public class AccessorShiftInfoUtil {
    public static ShiftInfo[] getShiftInfo(String idPerson, Date from, Date to, boolean enableAllShifts, Connection conn, Logger logger) throws SQLException {
        ShiftInfo[] shiftInfoArray;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("select shift.ID id_shift,   shift.ID_SERVER,   shift.SHIFT_TYPE,   SHIFT.NUM,   SHIFT.operating_day_name,   SHIFT.DBEGIN,   SHIFT.FIO_PERSON_OPEN,   SHIFT.FIO_PERSON_CLOSE,   SHIFT.DEND,   SHIFT.state,   count(OPERATIONS.ID) OPER_COUNT,    sum(SUM_INCOME) SUM_INCOME  from shift\n left join OPERATIONS on OPERATIONS.ID_SHIFT = SHIFT.ID_SERVER  where 1=1 " + (enableAllShifts ? "" : "  and (SHIFT.ID_PERSON_OPEN=" + idPerson + " or SHIFT.ID_PERSON_CLOSE =" + idPerson + " or OPERATIONS.id_person_create=" + idPerson + ")") + "  and date(shift.dbegin)>=? and date(shift.dbegin)<=? " + " group by SHIFT.ID," + "   SHIFT.ID_SERVER," + "   SHIFT.NUM," + "   SHIFT.operating_day_name," + "   SHIFT_TYPE," + "   SHIFT.DBEGIN," + "   SHIFT.DEND," + "   SHIFT.state," + "   SHIFT.FIO_PERSON_OPEN," + "   SHIFT.FIO_PERSON_CLOSE" + " ORDER BY shift.ID DESC");
            stmt.setTimestamp(1, new Timestamp(from.getTime()));
            stmt.setTimestamp(2, new Timestamp(to.getTime()));
            rs = stmt.executeQuery();
            LinkedList<ShiftInfo> res = new LinkedList<ShiftInfo>();
            ShiftInfo shInf = null;
            while (rs.next()) {
                shInf = new ShiftInfo();
                shInf.setNum(rs.getInt("NUM"));
                shInf.setIdShiftServer(rs.getLong("ID_SERVER"));
                shInf.setOperDay(rs.getString("OPERATING_DAY_NAME"));
                shInf.setStartTime(new Date(rs.getTimestamp("DBEGIN").getTime()));
                shInf.setCloseTime(new Date(rs.getTimestamp("DEND").getTime()));
                shInf.setIdShift(rs.getLong("id_shift"));
                shInf.setCoutPayments(rs.getInt("OPER_COUNT"));
                shInf.setSum(rs.getLong("SUM_INCOME"));
                shInf.setCloseKassirName(rs.getString("FIO_PERSON_CLOSE"));
                shInf.setOpenKassirName(rs.getString("FIO_PERSON_OPEN"));
                shInf.setState(rs.getInt("state"));
                shInf.setShiftType(rs.getString("SHIFT_TYPE"));
                res.add(shInf);
            }
            shiftInfoArray = res.toArray(new ShiftInfo[res.size()]);
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return shiftInfoArray;
    }
}

