/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.persistence.accessors;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.persistence.Condition;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RmaAttribute;
import ru.softlogic.rma.persistence.accessors.AccessorAttributesUtil;
import ru.softlogic.rma.persistence.accessors.JDBCUtil;

public class AccessorOperationsUtil {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Record fetchById(long id, Connection conn, Logger logger) throws SQLException {
        Record record;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Record rec = null;
        try {
            stmt = conn.prepareStatement("select * from operations where id=?");
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                rec = new Record();
                rec.setId(rs.getLong("id"));
                rec.setParentId(rs.getLong("pid"));
                rec.setProcessingId(rs.getLong("id_processing"));
                rec.setCreated(new java.util.Date(rs.getTimestamp("created").getTime()));
                rec.setDoc(rs.getShort("doc"));
                rec.setState(rs.getShort("state"));
                rec.setSubstate(rs.getShort("substate"));
                rec.setServiceId(rs.getShort("service_id"));
                rec.setServiceName(rs.getString("service_name"));
                rec.setProviderName(rs.getString("provider_name"));
                rec.setAccount(rs.getString("account"));
                rec.setAccount2(rs.getString("account2"));
                rec.setCommissionId(rs.getShort("commission_id"));
                rec.setSumIncome(rs.getInt("sum_income"));
                rec.setSumComm(rs.getInt("sum_comm"));
                rec.setSumOutcome(rs.getInt("sum_outcome"));
                rec.setSumFee(rs.getLong("sum_fee"));
                rec.setComment(rs.getString("comment"));
                rec.setState(rs.getShort("state"));
                rec.setSubstate(rs.getShort("substate"));
                rec.setAbsState(rs.getShort("abs_state"));
                rec.setError(rs.getShort("error_code"));
                rec.setIdPerson(rs.getString("id_person_create"));
                rec.setIdShift(rs.getLong("id_shift"));
                rec.setCanselled(rs.getShort("is_canselled") == 1);
            }
            record = rec;
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return record;
    }

    public static void insert(Record rec, Connection conn, Logger logger) throws SQLException {
        PreparedStatement stmt = null;
        PreparedStatement stmt1 = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("insert into operations(\n  id,  pid,  created,  doc,  service_id,  service_name,  provider_name,  account,  account2,  commission_id,  sum_income,  sum_comm,  sum_outcome,  sum_fee,  comment,  state,  substate,  abs_state,  id_person_create,  id_shift,  is_canselled) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            stmt.setLong(1, rec.getId());
            if (rec.getParentId() != null) {
                stmt.setLong(2, rec.getParentId());
            } else {
                stmt.setNull(2, -5);
            }
            Timestamp timeCr = new Timestamp(rec.getCreated().getTime());
            stmt.setTimestamp(3, timeCr);
            stmt.setShort(4, rec.getDoc());
            stmt.setShort(5, rec.getServiceId());
            stmt.setString(6, rec.getServiceName());
            stmt.setString(7, rec.getProviderName());
            stmt.setString(8, rec.getAccount());
            if (rec.getAccount2() != null) {
                stmt.setString(9, rec.getAccount2());
            } else {
                stmt.setNull(9, 12);
            }
            stmt.setShort(10, rec.getCommissionId());
            stmt.setInt(11, rec.getSumIncome());
            stmt.setInt(12, rec.getSumComm());
            stmt.setInt(13, rec.getSumOutcome());
            stmt.setLong(14, rec.getSumFee());
            if (rec.getComment() != null) {
                stmt.setString(15, rec.getComment());
            } else {
                stmt.setNull(15, 12);
            }
            stmt.setShort(16, rec.getState());
            stmt.setShort(17, rec.getSubstate());
            stmt.setShort(18, rec.getAbsState());
            stmt.setString(19, rec.getIdPerson());
            stmt.setLong(20, rec.getIdShift());
            stmt.setShort(21, rec.isCanselled() ? (short)1 : 0);
            stmt.executeUpdate();
            stmt1 = conn.prepareStatement("INSERT INTO attributes    (id,id_operation,name,value,name_title,value_title) VALUES    (DEFAULT,?,?,?,?,?)");
            if (rec.getAccount() != null) {
                stmt1.setLong(1, rec.getId());
                stmt1.setString(2, "id1");
                stmt1.setString(3, rec.getAccount());
                stmt1.setString(4, rec.getAccountTitle());
                stmt1.setString(5, rec.getAccountValueTitle());
                stmt1.executeUpdate();
            }
            if (rec.getAccount2() != null) {
                stmt1.setLong(1, rec.getId());
                stmt1.setString(2, "id2");
                stmt1.setString(3, rec.getAccount2());
                stmt1.setString(4, rec.getAccount2Title());
                stmt1.setString(5, rec.getAccount2ValueTitle());
                stmt1.executeUpdate();
            }
            if (rec.getAttributes() != null && rec.getAttributes().size() > 0) {
                for (String key : rec.getAttributes().keySet()) {
                    RmaAttribute atr = rec.getAttributes().get(key);
                    stmt1.setLong(1, rec.getId());
                    stmt1.setString(2, atr.getKey());
                    stmt1.setString(3, atr.getValue());
                    stmt1.setString(4, atr.getKeyTitle());
                    stmt1.setString(5, atr.getValueTitle());
                    stmt1.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                JDBCUtil.close(stmt1, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        JDBCUtil.close(stmt1, logger);
    }

    public static void updateChangedRecord(Record record, Connection conn, Logger logger) throws SQLException {
        if (record == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Record");
        }
        logger.info((Object)(LocBundle.getMessageLog((String)"rma.persistence.payadd") + " " + record));
        Statement stmt = null;
        ResultSet rs = null;
        PreparedStatement stmt2 = null;
        PreparedStatement stmt3 = null;
        try {
            RmaAttribute atr;
            stmt = conn.createStatement();
            stmt2 = conn.prepareStatement("UPDATE operations    SET account=?, account2=?    WHERE id=?");
            stmt2.setString(1, record.getAccount());
            if (record.getAccount2() != null) {
                stmt2.setString(2, record.getAccount2());
            } else {
                stmt2.setNull(2, 12);
            }
            stmt2.setLong(3, record.getId());
            stmt2.executeUpdate();
            Map<String, RmaAttribute> attributes = AccessorAttributesUtil.fetchAll(record.getId(), conn, logger);
            stmt3 = conn.prepareStatement("INSERT INTO attributes    (id,id_operation,name,value,name_title,value_title) VALUES    (DEFAULT,?,?,?,?,?)");
            if (record.getAccount() != null && attributes.get("id1") == null) {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.insertid1"));
                stmt3.setInt(1, (int)record.getId());
                stmt3.setString(2, "id1");
                stmt3.setString(3, record.getAccount());
                stmt3.setString(4, record.getAccountTitle());
                stmt3.setString(5, record.getAccountValueTitle());
                stmt3.executeUpdate();
            }
            if (record.getAccount2() != null && attributes.get("id2") == null) {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.insertid2"));
                stmt3.setInt(1, (int)record.getId());
                stmt3.setString(2, "id2");
                stmt3.setString(3, record.getAccount2());
                stmt3.setString(4, record.getAccount2Title());
                stmt3.setString(5, record.getAccount2ValueTitle());
                stmt3.executeUpdate();
            }
            if (record.getAttributes() != null && record.getAttributes().size() > 0) {
                for (String key : record.getAttributes().keySet()) {
                    if (attributes.get(key) != null) continue;
                    atr = record.getAttributes().get(key);
                    logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.insertkv"));
                    stmt3.setInt(1, (int)record.getId());
                    stmt3.setString(2, atr.getKey());
                    stmt3.setString(3, atr.getValue() == null ? "" : atr.getValue());
                    stmt3.setString(4, atr.getKeyTitle() == null ? "" : atr.getKeyTitle());
                    stmt3.setString(5, atr.getValueTitle() == null ? "" : atr.getValueTitle());
                    stmt3.executeUpdate();
                }
            }
            JDBCUtil.close(stmt3, logger);
            stmt3 = conn.prepareStatement("UPDATE attributes   SET name=?, value=?, name_title=?, value_title=? WHERE id = ?");
            if (record.getAccount() != null && attributes.get("id1") != null) {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.updateid1"));
                stmt3.setString(1, "id1");
                stmt3.setString(2, record.getAccount());
                stmt3.setString(3, record.getAccountTitle());
                stmt3.setString(4, record.getAccountValueTitle());
                stmt3.setLong(5, attributes.get("id1").getId());
                stmt3.executeUpdate();
            }
            if (record.getAccount2() != null && attributes.get("id2") != null) {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.updateid2"));
                stmt3.setString(1, "id2");
                stmt3.setString(2, record.getAccount2());
                stmt3.setString(3, record.getAccount2Title());
                stmt3.setString(4, record.getAccount2ValueTitle());
                stmt3.setLong(5, attributes.get("id2").getId());
                stmt3.executeUpdate();
            }
            if (record.getAttributes() != null && record.getAttributes().size() > 0) {
                for (String key : record.getAttributes().keySet()) {
                    if (attributes.get(key) == null) continue;
                    atr = record.getAttributes().get(key);
                    logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.updatekv"));
                    stmt3.setString(1, atr.getKey());
                    stmt3.setString(2, atr.getValue() == null ? "" : atr.getValue());
                    stmt3.setString(3, atr.getKeyTitle() == null ? "" : atr.getKeyTitle());
                    stmt3.setString(4, atr.getValueTitle() == null ? "" : atr.getValueTitle());
                    stmt3.setLong(5, attributes.get(atr.getKey()).getId());
                    stmt3.executeUpdate();
                }
            }
            logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.payupdsucc"));
        }
        catch (SQLException ex) {
            try {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.payinserr"), (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                JDBCUtil.close(stmt2, logger);
                JDBCUtil.close(stmt3, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        JDBCUtil.close(stmt2, logger);
        JDBCUtil.close(stmt3, logger);
    }

    public static void setNormalState(int id, short state, short substate, Short error, short finalStatus, Long processingId, short absState, Connection conn, Logger logger) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPDATE operations    SET state=?,substate=?,error_code=?,id_processing=?,abs_state=?  WHERE id=?");
            stmt.setShort(1, state);
            stmt.setShort(2, substate);
            if (error == null) {
                stmt.setNull(3, 5);
            } else {
                stmt.setShort(3, error);
            }
            if (processingId == null) {
                stmt.setNull(4, -5);
            } else {
                stmt.setLong(4, processingId);
            }
            stmt.setShort(5, absState);
            stmt.setInt(6, id);
            stmt.execute();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            JDBCUtil.close(stmt, logger);
        }
    }

    public static List<Record> getOperationsByShift(long shiftId, Connection conn, Logger logger) throws SQLException {
        LinkedList<Record> linkedList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("select * from operations where ID_SHIFT=?");
            stmt.setLong(1, shiftId);
            LinkedList<Record> records = new LinkedList<Record>();
            rs = stmt.executeQuery();
            while (rs.next()) {
                Record rec = new Record();
                rec.setId(rs.getInt("id"));
                rec.setCreated(new java.util.Date(rs.getTimestamp("created").getTime()));
                rec.setProcessed(new java.util.Date(rs.getTimestamp("processed").getTime()));
                rec.setState(rs.getShort("state"));
                rec.setAbsState(rs.getShort("abs_state"));
                rec.setSubstate(rs.getShort("substate"));
                rec.setDoc(rs.getShort("doc"));
                rec.setServiceId(rs.getShort("service_id"));
                rec.setProviderName(rs.getString("provider_name"));
                rec.setServiceName(rs.getString("service_name"));
                rec.setAccount(rs.getString("account"));
                rec.setAccount2(rs.getString("account2"));
                rec.setCommissionId(rs.getShort("commission_id"));
                rec.setSumIncome(rs.getInt("sum_income"));
                rec.setSumOutcome(rs.getInt("sum_outcome"));
                rec.setSumComm(rs.getInt("sum_comm"));
                rec.setSumFee(rs.getLong("sum_fee"));
                rec.setComment(rs.getString("comment"));
                rec.setPrintInfo(rs.getInt("print_info"));
                rec.setIdShift(rs.getLong("id_shift"));
                rec.setCanselled(rs.getShort("is_canselled") == 1);
                records.add(rec);
            }
            linkedList = records;
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return linkedList;
    }

    public static Record[] select(Condition condition, boolean withAttrs, Connection conn, Logger logger) throws SQLException {
        Record[] recordArray;
        Statement stmt = null;
        Statement stmt2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        try {
            stmt = conn.createStatement();
            stmt2 = conn.createStatement();
            String query = null;
            if (condition == null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                query = "select OPERATIONS.*,BASE_EVENT.PROCESSED_TIME,SHIFT.NUM    from OPERATIONS   left join SHIFT on OPERATIONS.ID_SHIFT = SHIFT.ID_SERVER   left join BASE_EVENT on OPERATIONS.ID = BASE_EVENT.ID where OPERATIONS.created>='" + sdf.format(cal.getTime()) + " and operations.id_person_create = '" + CurrentUser.getInstance().getUserId() + "' " + "' ORDER BY ORDER BY OPERATIONS.created DESC, id DESC FETCH FIRST 2000 ROWS ONLY";
            } else {
                boolean all = condition.isStateNew() && condition.isStateProcessing() && condition.isStateError() && condition.isStateSuccsess();
                query = "select OPERATIONS.*,BASE_EVENT.PROCESSED_TIME,SHIFT.NUM   FROM operations    left join SHIFT on OPERATIONS.ID_SHIFT = SHIFT.ID_SERVER   left join BASE_EVENT on OPERATIONS.ID = BASE_EVENT.ID  WHERE operations.id_person_create = '" + CurrentUser.getInstance().getUserId() + "' " + (condition.getDoc() == null ? "" : " and OPERATIONS.doc=" + condition.getDoc() + '\n') + (condition.getFrom() == null ? "" : " and OPERATIONS.created>='" + sdf.format(condition.getFrom()) + "'\n") + (condition.getTo() == null ? "" : " and OPERATIONS.created<='" + sdf.format(condition.getTo()) + "'\n") + (StringUtils.isEmpty((String)condition.getService()) ? "" : " and lower(OPERATIONS.service_name) like '%" + condition.getService().trim().toLowerCase() + "%' \n") + (condition.getAccount() == null || condition.getAccount().isEmpty() ? "" : "   and lower(OPERATIONS.account) like '%" + condition.getAccount().trim().toLowerCase() + "%' \n") + (condition.getSum() == null ? "" : "   and (OPERATIONS.sum_income=" + condition.getSum() + " or OPERATIONS.sum_outcome=" + condition.getSum() + ")\n") + (all ? "" : "and OPERATIONS.state in (-1" + (condition.isStateNew() ? ",0" : "") + (condition.isStateProcessing() ? ",20,40" : "") + (condition.isStateError() ? ",70,80,90" : "") + (condition.isStateSuccsess() ? ",60" : "") + ")") + (condition.getIdShift() != null && !condition.getIdShift().isEmpty() ? " and shift.num=" + condition.getIdShift() : "") + " ORDER BY \n" + (condition.isDesc() ? "   OPERATIONS.created DESC, operations.id DESC \n" : " OPERATIONS.created, operations.id \n") + (condition.getStart() > -1 ? "OFFSET " + condition.getStart() + " ROW FETCH NEXT " + (condition.getLimit() > 0 ? condition.getLimit() : 2000) + "  ROWS ONLY " : "");
            }
            rs = stmt.executeQuery(query);
            LinkedList<Record> res = new LinkedList<Record>();
            while (rs.next()) {
                Record rec = new Record();
                rec.setId(rs.getInt("id"));
                rec.setProcessingId(rs.getLong("id_processing"));
                rec.setCreated(new java.util.Date(rs.getTimestamp("created").getTime()));
                rec.setDoc(rs.getShort("doc"));
                rec.setServiceId(rs.getShort("service_id"));
                rec.setServiceName(rs.getString("service_name"));
                rec.setAccount(rs.getString("account"));
                rec.setAccount2(rs.getString("account2"));
                rec.setCommissionId(rs.getShort("commission_id"));
                rec.setSumIncome(rs.getInt("sum_income"));
                rec.setSumOutcome(rs.getInt("sum_outcome"));
                rec.setSumComm(rs.getInt("sum_comm"));
                rec.setSumFee(rs.getLong("sum_fee"));
                rec.setState(rs.getShort("state"));
                rec.setAbsState(rs.getShort("abs_state"));
                rec.setSubstate(rs.getShort("substate"));
                rec.setError(rs.getShort("error_code"));
                rec.setComment(rs.getString("comment"));
                rec.setPrintInfo(rs.getInt("print_info"));
                rec.setIdShift(rs.getLong("id_shift"));
                rec.setNumShift(rs.getShort("num"));
                rec.setCanselled(rs.getShort("is_canselled") == 1);
                rec.setProcessed(new java.util.Date(rs.getTimestamp("PROCESSED_TIME").getTime()));
                res.add(rec);
                if (!withAttrs) continue;
                rs2 = stmt2.executeQuery("SELECT name,value,name_title,value_title FROM attributes WHERE id_operation=" + rs.getInt("id"));
                LinkedHashMap<String, RmaAttribute> attrs = new LinkedHashMap<String, RmaAttribute>();
                while (rs2.next()) {
                    RmaAttribute atr = new RmaAttribute();
                    atr.setKey(rs2.getString("name"));
                    atr.setKeyTitle(rs2.getString("name_title"));
                    atr.setValue(rs2.getString("value"));
                    atr.setValueTitle(rs2.getString("value_title"));
                    attrs.put(atr.getKey(), atr);
                }
                rs2.close();
                RmaAttribute remove = (RmaAttribute)attrs.remove("id1");
                if (remove != null) {
                    rec.setAccountTitle(remove.getKeyTitle());
                    rec.setAccountValueTitle(remove.getValueTitle());
                }
                if ((remove = (RmaAttribute)attrs.remove("id2")) != null) {
                    rec.setAccount2Title(remove.getKeyTitle());
                    rec.setAccount2ValueTitle(remove.getValueTitle());
                }
                rec.setAttributes(attrs);
            }
            recordArray = res.toArray(new Record[res.size()]);
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(rs2, logger);
                JDBCUtil.close(stmt, logger);
                JDBCUtil.close(stmt2, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(rs2, logger);
        JDBCUtil.close(stmt, logger);
        JDBCUtil.close(stmt2, logger);
        return recordArray;
    }

    public static boolean contain(Record record, Connection conn, Logger logger) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("SELECT count(*) as cnt    FROM operations    WHERE service_id=? and account=? and sum_income=? and created>=? ");
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            stmt.setInt(1, record.getServiceId());
            stmt.setString(2, record.getAccount());
            stmt.setDouble(3, record.getSumIncome());
            stmt.setDate(4, new Date(cal.getTime().getTime()));
            rs = stmt.executeQuery();
            rs.next();
            bl = rs.getInt("cnt") > 0;
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return bl;
    }

    public static void updateRecord(Record record, Connection conn, Logger logger) throws SQLException {
        if (record == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Record");
        }
        logger.info((Object)(LocBundle.getMessageLog((String)"rma.persistence.payadd") + " " + record));
        Statement stmt = null;
        ResultSet rs = null;
        PreparedStatement stmt2 = null;
        PreparedStatement stmt3 = null;
        try {
            RmaAttribute atr;
            stmt = conn.createStatement();
            stmt2 = conn.prepareStatement("UPDATE operations    SET created=?,        doc =?,       service_id=?,       service_name=?,       account=?,       account2=?,       commission_id=?,       sum_income=?,       sum_outcome=?,       sum_comm=?,       comment=?,       print_info=?,       state=?,       substate=?,       sum_fee=?,        print_info=?,       is_canselled=?   WHERE id=?");
            stmt2.setTimestamp(1, new Timestamp(record.getCreated().getTime()));
            stmt2.setShort(2, record.getDoc());
            stmt2.setShort(3, record.getServiceId());
            stmt2.setString(4, record.getServiceName());
            stmt2.setString(5, record.getAccount());
            if (record.getAccount2() != null) {
                stmt2.setString(6, record.getAccount2());
            } else {
                stmt2.setNull(6, 12);
            }
            stmt2.setShort(7, record.getCommissionId());
            stmt2.setInt(8, record.getSumIncome());
            stmt2.setInt(9, record.getSumOutcome());
            stmt2.setInt(10, record.getSumComm());
            stmt2.setString(11, record.getComment());
            stmt2.setShort(12, record.getLocalState());
            stmt2.setInt(13, record.getPrintInfo());
            stmt2.setInt(14, record.getState());
            stmt2.setInt(15, record.getSubstate());
            stmt2.setLong(16, record.getSumFee());
            stmt2.setInt(17, record.getPrintInfo());
            stmt2.setShort(18, record.isCanselled() ? (short)1 : 0);
            stmt2.setLong(19, record.getId());
            stmt2.executeUpdate();
            rs = stmt.executeQuery("SELECT name,id from attributes WHERE id_operation=" + record.getId());
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            while (rs.next()) {
                map.put(rs.getString("name"), rs.getInt("id"));
            }
            stmt3 = conn.prepareStatement("INSERT INTO attributes    (id,id_operation,name,value,name_title,value_title) VALUES    (DEFAULT,?,?,?,?,?)");
            if (record.getAccount() != null && map.get("id1") == null) {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.insertid1"));
                stmt3.setInt(1, (int)record.getId());
                stmt3.setString(2, "id1");
                stmt3.setString(3, record.getAccount());
                stmt3.setString(4, record.getAccountTitle());
                stmt3.setString(5, record.getAccountValueTitle());
                stmt3.executeUpdate();
            }
            if (record.getAccount2() != null && map.get("id2") == null) {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.insertid2"));
                stmt3.setInt(1, (int)record.getId());
                stmt3.setString(2, "id2");
                stmt3.setString(3, record.getAccount2());
                stmt3.setString(4, record.getAccount2Title());
                stmt3.setString(5, record.getAccount2ValueTitle());
                stmt3.executeUpdate();
            }
            if (record.getAttributes() != null && record.getAttributes().size() > 0) {
                for (String key : record.getAttributes().keySet()) {
                    if (map.get(key) != null) continue;
                    atr = record.getAttributes().get(key);
                    logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.insertkv"));
                    stmt3.setInt(1, (int)record.getId());
                    stmt3.setString(2, atr.getKey());
                    stmt3.setString(3, atr.getValue() == null ? "" : atr.getValue());
                    stmt3.setString(4, atr.getKeyTitle() == null ? "" : atr.getKeyTitle());
                    stmt3.setString(5, atr.getValueTitle() == null ? "" : atr.getValueTitle());
                    stmt3.executeUpdate();
                }
            }
            JDBCUtil.close(stmt3, logger);
            stmt3 = conn.prepareStatement("UPDATE attributes   SET name=?, value=?, name_title=?, value_title=? WHERE id = ?");
            if (record.getAccount() != null && map.get("id1") != null) {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.updateid1"));
                stmt3.setString(1, "id1");
                stmt3.setString(2, record.getAccount());
                stmt3.setString(3, record.getAccountTitle());
                stmt3.setString(4, record.getAccountValueTitle());
                stmt3.setInt(5, (Integer)map.get("id1"));
                stmt3.executeUpdate();
            }
            if (record.getAccount2() != null && map.get("id2") != null) {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.updateid2"));
                stmt3.setString(1, "id2");
                stmt3.setString(2, record.getAccount2());
                stmt3.setString(3, record.getAccount2Title());
                stmt3.setString(4, record.getAccount2ValueTitle());
                stmt3.setInt(5, (Integer)map.get("id2"));
                stmt3.executeUpdate();
            }
            if (record.getAttributes() != null && record.getAttributes().size() > 0) {
                for (String key : record.getAttributes().keySet()) {
                    if (map.get(key) == null) continue;
                    atr = record.getAttributes().get(key);
                    logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.updatekv"));
                    stmt3.setString(1, atr.getKey());
                    stmt3.setString(2, atr.getValue() == null ? "" : atr.getValue());
                    stmt3.setString(3, atr.getKeyTitle() == null ? "" : atr.getKeyTitle());
                    stmt3.setString(4, atr.getValueTitle() == null ? "" : atr.getValueTitle());
                    stmt3.setInt(5, (Integer)map.get(atr.getKey()));
                    stmt3.executeUpdate();
                }
            }
            logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.payupdsucc"));
        }
        catch (SQLException ex) {
            try {
                logger.info((Object)LocBundle.getMessageLog((String)"rma.persistence.payinserr"), (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(stmt, logger);
                JDBCUtil.close(stmt2, logger);
                JDBCUtil.close(stmt3, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(stmt, logger);
        JDBCUtil.close(stmt2, logger);
        JDBCUtil.close(stmt3, logger);
    }
}

