/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.persistence.accessors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.log4j.Logger;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.persistence.accessors.JDBCUtil;
import ru.softlogic.rma.persistence.events.BaseEvent;

public class AccessorBaseEventUtil {
    public static long insert(BaseEvent event, Connection conn, Logger logger) throws SQLException {
        long l;
        PreparedStatement stmt = null;
        try {
            event.setIdUser(CurrentUser.getInstance().getUserId());
            stmt = conn.prepareStatement("insert into base_event(\n  id,  created,  processed_time,  local_state,  event_type,  is_final)  values(DEFAULT,?,?,?,?,?)");
            stmt.setTimestamp(1, new Timestamp(event.getCreated().getTime()));
            stmt.setTimestamp(2, new Timestamp(event.getProcessed().getTime()));
            stmt.setShort(3, event.getLocalState());
            stmt.setShort(4, event.getEventType());
            stmt.setBoolean(5, event.isIsFinal());
            stmt.executeUpdate();
            l = JDBCUtil.getIdentityVal(conn, logger);
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(stmt, logger);
        return l;
    }

    public static void setFinalState(long id, boolean isFinal, Connection conn, Logger logger) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("update base_event set processed_time=CURRENT_TIMESTAMP, is_final = ? where id = ?");
            stmt.setBoolean(1, isFinal);
            stmt.setLong(2, id);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            JDBCUtil.close(stmt, logger);
        }
    }

    public static void update(BaseEvent event, Connection conn, Logger logger) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("update base_event\n set created=?,     processed_time=CURRENT_TIMESTAMP,     local_state=?,     event_type=?,     is_final=?  where id = ?");
            stmt.setTimestamp(1, new Timestamp(event.getCreated().getTime()));
            stmt.setShort(2, event.getLocalState());
            stmt.setShort(3, event.getEventType());
            stmt.setBoolean(4, event.isIsFinal());
            stmt.setLong(5, event.getId());
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            JDBCUtil.close(stmt, logger);
        }
    }

    public static void setError(long id, short localState, Connection conn, Logger logger) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("update base_event set local_state=? where id = ?");
            stmt.setShort(1, localState);
            stmt.setLong(2, id);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            JDBCUtil.close(stmt, logger);
        }
    }

    public static boolean isEmpty(Connection conn, Logger logger) throws SQLException {
        boolean bl;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select * from base_event FETCH FIRST ROW ONLY");
            bl = !rs.next();
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return bl;
    }
}

