/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.persistence.accessors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.rma.persistence.BalanceRecord;
import ru.softlogic.rma.persistence.accessors.JDBCUtil;

public class AccessorBalanceRercordUtil {
    public static List<BalanceRecord> fetchByShiftAndPerson(long idShift, String idPerson, Connection conn, Logger logger) throws SQLException {
        LinkedList<BalanceRecord> linkedList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement("select \n   op.provider_name,\n   op.SERVICE_NAME,\n   count(op.ID) count_all,\n   sum(op.SUM_INCOME) sum_income,\n   sum(case when STATE=? then 1 else 0 end) COUNT_SUCCESS,\n   sum(case when STATE=? then op.SUM_INCOME else 0 end) SUM_SUCCESS,\n   sum(op.SUM_COMM) SUM_COMM,\n   sum(case when STATE=? then 1 else 0 end) COUNT_ERROR,\n   sum(case when STATE=? then op.SUM_INCOME else 0 end) SUM_ERROR,\n   sum(case when STATE=? and SUBSTATE=? then 1 else 0 end) COUNT_CANCELLED,\n   sum(case when STATE=? and SUBSTATE=? then op.SUM_INCOME else 0 end) SUM_CANCELLED\n from operations op\n where ID_SHIFT=? \n group by service_name,provider_name");
            stmt.setInt(1, 60);
            stmt.setInt(2, 60);
            stmt.setInt(3, 80);
            stmt.setInt(4, 80);
            stmt.setInt(5, 80);
            stmt.setInt(6, 8);
            stmt.setInt(7, 80);
            stmt.setInt(8, 8);
            stmt.setLong(9, idShift);
            LinkedList<BalanceRecord> recoreds = new LinkedList<BalanceRecord>();
            rs = stmt.executeQuery();
            while (rs.next()) {
                BalanceRecord rec = new BalanceRecord();
                rec.setProviderName(rs.getString("provider_name"));
                rec.setServiceName(rs.getString("SERVICE_NAME"));
                rec.setCountAll(rs.getInt("count_all"));
                rec.setSumIncome(rs.getLong("sum_income"));
                rec.setCountSuccess(rs.getInt("COUNT_SUCCESS"));
                rec.setSumSuccess(rs.getLong("SUM_SUCCESS"));
                rec.setSumComm(rs.getLong("SUM_COMM"));
                rec.setCountError(rs.getInt("COUNT_ERROR"));
                rec.setSumError(rs.getLong("SUM_ERROR"));
                rec.setCountCancelled(rs.getInt("COUNT_CANCELLED"));
                rec.setSumCancelled(rs.getLong("SUM_CANCELLED"));
                recoreds.add(rec);
            }
            linkedList = recoreds;
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, logger);
                JDBCUtil.close(stmt, logger);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, logger);
        JDBCUtil.close(stmt, logger);
        return linkedList;
    }
}

