/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.persistence;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import ru.softlogic.rma.persistence.DocType;
import ru.softlogic.rma.persistence.RmaAttribute;

public class Record
implements Serializable {
    private long id;
    private Long parentId;
    private Long processingId;
    private Date created;
    private Date processed;
    private short doc;
    private short serviceId;
    private String serviceName;
    private String account;
    private String accountTitle;
    private String accountValueTitle;
    private String account2;
    private String account2Title;
    private String account2ValueTitle;
    private Map<String, RmaAttribute> attributes;
    private short commissionId;
    private int sumIncome;
    private int sumOutcome;
    private int sumComm;
    private long sumFee;
    private short state;
    private short substate;
    private short localState;
    private short absState;
    private short finalStatus;
    private short error;
    private String comment;
    private int printInfo;
    public static final int PRINTED = 1;
    public static final int PRINTED_FISCAL = 2;
    public static final int PRINTED_BACK = 4;
    public static final int NOT = 0;
    private Map<String, String> additional;
    private DocType docType;
    private long crc;
    private long idShift;
    private short numShift;
    private String idPerson;
    private String providerName;
    private boolean canselled;
    private short typeCashSource;

    public boolean isCanselled() {
        return this.canselled;
    }

    public void setCanselled(boolean canselled) {
        this.canselled = canselled;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getIdPerson() {
        return this.idPerson;
    }

    public void setIdPerson(String idPerson) {
        this.idPerson = idPerson;
    }

    public String getAccount() {
        return this.account;
    }

    public void setPrintInfo(int printInfo) {
        this.printInfo = printInfo;
    }

    public int getPrintInfo() {
        return this.printInfo;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount2() {
        return this.account2;
    }

    public void setAccount2(String account2) {
        this.account2 = account2;
    }

    public short getCommissionId() {
        return this.commissionId;
    }

    public void setCommissionId(short commissionId) {
        this.commissionId = commissionId;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public short getDoc() {
        return this.doc;
    }

    public void setDoc(short doc) {
        this.doc = doc;
    }

    public short getError() {
        return this.error;
    }

    public void setError(short error) {
        this.error = error;
    }

    public short getFinalStatus() {
        return this.finalStatus;
    }

    public void setFinalStatus(short finalStatus) {
        this.finalStatus = finalStatus;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Date getProcessed() {
        return this.processed;
    }

    public void setProcessed(Date processed) {
        this.processed = processed;
    }

    public short getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(short serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public short getState() {
        return this.state;
    }

    public void setState(short state) {
        this.state = state;
    }

    public short getSubstate() {
        return this.substate;
    }

    public void setSubstate(short substate) {
        this.substate = substate;
    }

    public int getSumComm() {
        return this.sumComm;
    }

    public void setSumComm(int sumComm) {
        this.sumComm = sumComm;
    }

    public int getSumIncome() {
        return this.sumIncome;
    }

    public void setSumIncome(int sumIncome) {
        this.sumIncome = sumIncome;
    }

    public int getSumOutcome() {
        return this.sumOutcome;
    }

    public void setSumOutcome(int sumOutcome) {
        this.sumOutcome = sumOutcome;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Long getProcessingId() {
        return this.processingId;
    }

    public void setProcessingId(Long processingId) {
        this.processingId = processingId;
    }

    public short getLocalState() {
        return this.localState;
    }

    public void setLocalState(short loacalState) {
        this.localState = loacalState;
    }

    public short getAbsState() {
        return this.absState;
    }

    public void setAbsState(short absState) {
        this.absState = absState;
    }

    public Map<String, RmaAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, RmaAttribute> attributes) {
        this.attributes = attributes;
    }

    public String getAccount2Title() {
        if (this.account2Title == null) {
            return "id2";
        }
        return this.account2Title;
    }

    public String getAccount2ValueTitle() {
        if (this.account2ValueTitle == null) {
            return this.account2;
        }
        return this.account2ValueTitle;
    }

    public String getAccountTitle() {
        if (this.accountTitle == null) {
            return "id1";
        }
        return this.accountTitle;
    }

    public String getAccountValueTitle() {
        if (this.accountValueTitle == null) {
            return this.account;
        }
        return this.accountValueTitle;
    }

    public void setAccount2Title(String account2Title) {
        this.account2Title = account2Title;
    }

    public void setAccount2ValueTitle(String account2ValueTitle) {
        if (account2ValueTitle == null || account2ValueTitle.trim().length() == 0) {
            account2ValueTitle = null;
        }
        this.account2ValueTitle = account2ValueTitle;
    }

    public void setAccountTitle(String accountTitle) {
        this.accountTitle = accountTitle;
    }

    public void setAccountValueTitle(String accountValueTitle) {
        this.accountValueTitle = accountValueTitle;
    }

    public Map<String, String> getAdditional() {
        return this.additional;
    }

    public void setAdditional(Map<String, String> additional) {
        this.additional = additional;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public void setDocType(DocType docType) {
        this.docType = docType;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setCrc(long crc) {
        this.crc = crc;
    }

    public long getSumFee() {
        return this.sumFee;
    }

    public void setSumFee(long sumFee) {
        this.sumFee = sumFee;
    }

    public int getSumFeeRound() {
        return Math.round((float)this.sumFee / 100.0f);
    }

    public short getTypeCashSource() {
        return this.typeCashSource;
    }

    public void setTypeCashSource(short typeCashSource) {
        this.typeCashSource = typeCashSource;
    }

    public long getIdShift() {
        return this.idShift;
    }

    public void setIdShift(long idShift) {
        this.idShift = idShift;
    }

    public short getNumShift() {
        return this.numShift;
    }

    public void setNumShift(short numShift) {
        this.numShift = numShift;
    }

    public String toString() {
        return "Record{id=" + this.id + ", parentId=" + this.parentId + ", processingId=" + this.processingId + ", created=" + this.created + ", processed=" + this.processed + ", doc=" + this.doc + ", serviceId=" + this.serviceId + ", serviceName=" + this.serviceName + ", account=" + this.account + ", accountTitle=" + this.accountTitle + ", accountValueTitle=" + this.accountValueTitle + ", account2=" + this.account2 + ", account2Title=" + this.account2Title + ", account2ValueTitle=" + this.account2ValueTitle + ", attributes=" + this.attributes + ", commissionId=" + this.commissionId + ", sumIncome=" + this.sumIncome + ", sumOutcome=" + this.sumOutcome + ", sumComm=" + this.sumComm + ", state=" + this.state + ", substate=" + this.substate + ", localState=" + this.localState + ", absState=" + this.absState + ", finalStatus=" + this.finalStatus + ", error=" + this.error + ", comment=" + this.comment + ", printInfo=" + this.printInfo + ", additional=" + this.additional + ", docType=" + (Object)((Object)this.docType) + ", crc=" + this.crc + ", sumFee=" + this.sumFee + ", typeCashSource=" + this.typeCashSource + ", idShift=" + this.idShift + ",numShift=" + this.numShift + '}';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Record)) {
            return false;
        }
        Record rec = (Record)obj;
        if (this.id != rec.id || this.parentId != rec.parentId || this.processingId != rec.processingId) {
            return false;
        }
        if (this.doc != rec.doc) {
            return false;
        }
        if (this.serviceId != rec.serviceId) {
            return false;
        }
        if (this.account != null && rec.getAccount() != null && !this.account.equals(rec.getAccount())) {
            return false;
        }
        if (this.account != null && rec.getAccount() == null && this.account == null && rec.getAccount() != null) {
            return false;
        }
        if (this.account2 != null && rec.getAccount2() == null && this.account2 == null && rec.getAccount2() != null) {
            return false;
        }
        return this.created.equals(rec.created);
    }
}

