/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.paydocument;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import ru.softlogic.rma.paydocument.IRealRender;
import ru.softlogic.rma.paydocument.PayAttribut;
import ru.softlogic.rma.paydocument.PaydocModelLoader;
import ru.softlogic.rma.paydocument.VelocityWrapper;
import ru.softlogic.rma.utils.PathUtils;

public class DocumentRender {
    private static DocumentRender instance;
    private List<PayAttribut> model;
    private Map<String, Template> templates;
    private IRealRender paramRender = new VelocityWrapper();
    private Map<String, String> payParams = new HashMap<String, String>();

    private DocumentRender() {
    }

    public static DocumentRender getInstance() {
        if (instance == null) {
            instance = new DocumentRender();
        }
        return instance;
    }

    public Map<String, String> getCurrentPayParams() {
        return this.payParams;
    }

    public void init() {
        String path = PathUtils.getAppHome() + "/resources/paydoccfg.xml";
        this.model = PaydocModelLoader.loadModel(path);
    }

    public void clear() {
        this.payParams.clear();
    }

    public Map<String, String> merge() {
        if (this.model == null || this.model.isEmpty()) {
            return this.payParams;
        }
        this.payParams.clear();
        block0: for (PayAttribut attribut : this.model) {
            String name = attribut.getName();
            Set<Integer> prioritys = attribut.getValues().keySet();
            String res = null;
            for (Integer priority : prioritys) {
                String strTmpl = attribut.getValues().get(priority);
                String templateName = name + '.' + priority;
                res = this.paramRender.renderParam(templateName, strTmpl);
                if (!StringUtils.isNotEmpty((String)res)) continue;
                this.payParams.put(name, res);
                continue block0;
            }
        }
        return this.payParams;
    }

    public DocumentRender addContextAttribut(String name, Object value) {
        this.paramRender.addParam(name, value);
        return this;
    }

    public DocumentRender clearContext() {
        this.paramRender.clear();
        return this;
    }
}

