/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model.keeperpayments;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import org.apache.log4j.Logger;
import ru.softlogic.rma.connector.model.CurrentUser;
import ru.softlogic.rma.model.keeperpayments.IKeeperUpdateListener;
import ru.softlogic.rma.model.keeperpayments.KeeperException;
import ru.softlogic.rma.model.keeperpayments.PaymentData;
import ru.softlogic.rma.model.keeperpayments.utils.KeeperKeyUtils;
import ru.softlogic.rma.persistence.PersistenceException;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.RecordsInfo;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.shift.ShiftManager;
import ru.softlogic.rma.utils.PathUtils;
import ru.softlogic.rma.utils.RecordsCheker;

public final class KeeperPayment {
    PaymentData paymentData;
    private static KeeperPayment instance;
    private SealedObject so;
    private transient List<IKeeperUpdateListener> listeners = new LinkedList<IKeeperUpdateListener>();

    private KeeperPayment() {
        try {
            this.readPaymentData();
        }
        catch (Exception ex) {
            Logger.getLogger((String)"app").error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 keeper " + ex.getMessage()));
        }
    }

    public static KeeperPayment getInstanse() {
        if (instance == null) {
            instance = new KeeperPayment();
        }
        try {
            instance.readPaymentData();
            instance.notifyUpdateListeners();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return instance;
    }

    public void notifyUpdateListeners() throws Exception {
        for (IKeeperUpdateListener listener : this.listeners) {
            listener.updateState(this.paymentData);
        }
        try {
            this.writePaymentData();
        }
        catch (Exception ex) {
            Logger.getLogger((String)"app").error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u043a\u043e\u0440\u0437\u0438\u043d\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043d\u0430 \u0434\u0438\u0441\u043a", (Throwable)ex);
            throw ex;
        }
    }

    public void addUpdateListener(IKeeperUpdateListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void readPaymentData() throws IOException {
        String path = PathUtils.getKeeperPath();
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(path));
            Object obj = ois.readObject();
            if (obj instanceof SealedObject) {
                SealedObject tempSealedObject = (SealedObject)obj;
                this.paymentData = (PaymentData)tempSealedObject.getObject(KeeperKeyUtils.KEY);
            } else if (obj instanceof PaymentData) {
                this.paymentData = (PaymentData)obj;
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            if (this.paymentData == null) {
                this.paymentData = new PaymentData();
            }
        }
    }

    public void writePaymentData() throws IOException {
        String path = PathUtils.getKeeperPath();
        ObjectOutputStream oos = null;
        try {
            File file = new File(path);
            File dir = new File(file.getParent());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Cipher cipher = Cipher.getInstance("DESede");
            cipher.init(1, KeeperKeyUtils.KEY);
            this.so = new SealedObject(this.paymentData, cipher);
            oos = new ObjectOutputStream(new FileOutputStream(path));
            oos.writeObject(this.so);
            oos.close();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addPayment(Record rec) throws Exception {
        ShiftManager.getInstance().checkShift();
        RecordsCheker.checkIntegrity(rec);
        this.paymentData.getToPayRecords().add(rec);
        this.notifyUpdateListeners();
    }

    public void addAllPayment(Record[] records) throws Exception {
        ShiftManager.getInstance().checkShift();
        if (records == null && records.length <= 0) {
            return;
        }
        for (Record each : records) {
            RecordsCheker.checkIntegrity(each);
        }
        this.paymentData.getToPayRecords().addAll(Arrays.asList(records));
        this.notifyUpdateListeners();
    }

    public Record getLastRecord() {
        if (this.paymentData.getToPayRecords().isEmpty()) {
            return null;
        }
        int length = this.paymentData.getToPayRecords().size();
        return this.paymentData.getToPayRecords().get(length - 1);
    }

    public boolean isEmpty() {
        return this.paymentData.getToPayRecords().isEmpty();
    }

    public void completePayment() throws Exception {
        ShiftManager.getInstance().checkShift();
        try {
            Logger.getLogger((String)"pay").info((Object)"\u041f\u0435\u0440\u0435\u043d\u043e\u0448\u0443 \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c");
            Record[] rec = this.paymentData.getToPayRecords().toArray(new Record[this.paymentData.getToPayRecords().size()]);
            PersistenceManager.getInstance().addAllOperations(rec);
            this.paymentData.getToPayRecords().clear();
            Logger.getLogger((String)"pay").info((Object)"\u041f\u043b\u0430\u0442\u0435\u0436\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u044b");
        }
        catch (PersistenceException ex) {
            Logger.getLogger((String)"pay").error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c", (Throwable)ex);
            throw ex;
        }
        this.notifyUpdateListeners();
    }

    public void cancelPayment(Record rec, String comment) throws Exception {
        if (rec == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Record");
        }
        if (this.paymentData.getToPayRecords().contains(rec)) {
            rec.setComment(comment);
            this.paymentData.getToPayRecords().remove(rec);
            PersistenceManager.getInstance().canselByCart(rec, CurrentUser.getInstance().getUserId());
        }
        this.notifyUpdateListeners();
    }

    public void canselAllPayments(String comment) throws Exception {
        for (Record rec : this.paymentData.getToPayRecords()) {
            rec.setComment(comment);
        }
        try {
            PersistenceManager.getInstance().canselAllByCart(this.paymentData.getToPayRecords().toArray(new Record[this.paymentData.getToPayRecords().size()]), CurrentUser.getInstance().getUserId());
            this.paymentData.getToPayRecords().clear();
        }
        catch (PersistenceException ex) {
            Logger.getLogger((String)"pay").error((Object)ex.getMessage());
            throw new KeeperException(ex);
        }
        this.notifyUpdateListeners();
    }

    public RecordsInfo getRecordsInfo() {
        if (this.paymentData == null) {
            return null;
        }
        RecordsInfo info = new RecordsInfo();
        for (Record rec : this.paymentData.getToPayRecords()) {
            info.setCount(info.getCount() + 1);
            info.setSumIncome(info.getSumIncome() + rec.getSumIncome());
            info.setSumOutcome(info.getSumOutcome() + rec.getSumOutcome());
            info.setSumComm(info.getSumComm() + rec.getSumComm());
        }
        return info;
    }
}

