/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import ru.softlogic.rma.connector.model.CommissionStep;
import ru.softlogic.rma.connector.model.CommissionType;
import ru.softlogic.rma.connector.model.Dealer;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.Operator;
import ru.softlogic.rma.connector.model.Point;
import ru.softlogic.rma.connector.model.Provider;
import ru.softlogic.rma.connector.model.References;
import ru.softlogic.rma.connector.model.Service;
import ru.softlogic.rma.connector.model.ServiceProvider;
import ru.softlogic.rma.connector.model.ServiceType;
import ru.softlogic.rma.connector.model.command.CommandType;
import ru.softlogic.rma.connector.model.directory.calendar.DayOff;
import ru.softlogic.rma.connector.model.directory.calendar.SheduleReference;
import ru.softlogic.rma.connector.model.directory.shift.ShiftTypeCodes;
import ru.softlogic.rma.connector.model.directory.shift.ShiftTypesReference;
import ru.softlogic.rma.connector.ws.stub.Auth;
import ru.softlogic.rma.connector.ws.stub.Command;
import ru.softlogic.rma.connector.ws.stub.Commission;
import ru.softlogic.rma.connector.ws.stub.Menu;
import ru.softlogic.rma.connector.ws.stub.PD4Record;
import ru.softlogic.rma.connector.ws.stub.Person;
import ru.softlogic.rma.connector.ws.stub.PersonalNumber;
import ru.softlogic.rma.connector.ws.stub.ReferenceResponse;
import ru.softlogic.rma.connector.ws.stub.References;
import ru.softlogic.rma.connector.ws.stub.ServiceProvider;
import ru.softlogic.rma.connector.ws.stub.ShiftType;
import ru.softlogic.rma.connector.ws.stub.WorkCalendar;

public class ReferenceBuilder {
    public References build(ReferenceResponse response) {
        References refs = new References();
        refs.setVersion(response.getReferences().getVersion());
        refs.setUpdateUrl(response.getReferences().getUpdateUrl());
        refs.setUpdateLogin(response.getReferences().getUpdateLogin());
        refs.setUpdatePassword(response.getReferences().getUpdatePassword());
        refs.setDealer(this.buildDealer(response.getReferences().getDealer()));
        refs.setOperator(this.buildOperator(response.getReferences().getOperator()));
        refs.setPoint(this.buildPoint(response.getReferences().getPoint()));
        refs.setAuth(this.buildAuth(response.getReferences().getAuth()));
        refs.setCommands(this.buildCommands(response.getReferences().getCommands()));
        refs.setPd4Records(this.buildPD4Records(response.getReferences().getPd4Records()));
        refs.setPersonalNumbers(this.buildPersonalNumbers(response.getReferences().getPersonalNumbers()));
        refs.setMenu(this.buildMenu(response.getReferences().getMenu()));
        refs.setSheduleReference(this.buildScheduleReference(response.getReferences().getCalendar()));
        refs.setShiftTypeReference(this.buildShiftTypesReference(response.getReferences().getShiftTypes()));
        refs.setPersons(this.buildPersons(response.getReferences().getPersons()));
        refs.setChanges(this.buildChanges(response.getReferences().getChangedItems()));
        return refs;
    }

    public List<MenuItem> buildChanges(References.ChangedItems items) {
        if (items != null && items.getChangedItem() != null && !items.getChangedItem().isEmpty()) {
            return Arrays.asList(this.buildMenuItems(items.getChangedItem(), null));
        }
        return null;
    }

    public List<ru.softlogic.rma.connector.model.Person> buildPersons(References.Persons persons) {
        LinkedList<ru.softlogic.rma.connector.model.Person> personList = null;
        if (persons != null && persons.getPerson() != null && !persons.getPerson().isEmpty()) {
            personList = new LinkedList<ru.softlogic.rma.connector.model.Person>();
            for (Person p : persons.getPerson()) {
                personList.add(new ru.softlogic.rma.connector.model.Person(p.getPerson(), p.getLogin(), p.getFio(), p.getRole(), p.getRoleName()));
            }
        }
        return personList;
    }

    public ShiftTypesReference buildShiftTypesReference(References.ShiftTypes shTypes) {
        ShiftTypesReference ref = null;
        if (shTypes != null && shTypes.getShiftType() != null && !shTypes.getShiftType().isEmpty()) {
            ref = new ShiftTypesReference();
            for (ShiftType item : shTypes.getShiftType()) {
                ru.softlogic.rma.connector.model.directory.shift.ShiftType shType = new ru.softlogic.rma.connector.model.directory.shift.ShiftType(item.getId().intValue(), item.getCode(), item.getUsage(), item.getTimeStart(), item.getTimeEnd());
                String code = ShiftTypeCodes.OPERATING.getCode();
                if (code.equals(shType.getType())) {
                    ref.setOperationType(shType);
                    continue;
                }
                ref.setNonOperatingType(shType);
            }
        }
        return ref;
    }

    public SheduleReference buildScheduleReference(References.Calendar calendar) {
        SheduleReference schRef = null;
        if (calendar != null && calendar.getDay() != null && !calendar.getDay().isEmpty()) {
            schRef = new SheduleReference();
            SheduleReference scheduleRef = new SheduleReference(new ArrayList<DayOff>());
            for (WorkCalendar day : calendar.getDay()) {
                if (!day.getDayoff().booleanValue()) continue;
                scheduleRef.getCalendar().add(new DayOff(day.getDay()));
            }
            schRef = scheduleRef;
        }
        return schRef;
    }

    public ru.softlogic.rma.connector.model.Menu buildMenu(Menu menu) {
        ru.softlogic.rma.connector.model.Menu m = null;
        if (menu != null) {
            m = new ru.softlogic.rma.connector.model.Menu();
            m.setTypes(this.buildTypes(menu.getTypes()));
        }
        return m;
    }

    public ServiceType[] buildTypes(List<ru.softlogic.rma.connector.ws.stub.ServiceType> types) {
        LinkedList<ServiceType> listTypes = new LinkedList<ServiceType>();
        for (ru.softlogic.rma.connector.ws.stub.ServiceType each : types) {
            ServiceType st = this.buildServiceType(each);
            if (st.getItems() == null) continue;
            listTypes.add(st);
        }
        return listTypes.toArray(new ServiceType[listTypes.size()]);
    }

    public ServiceType buildServiceType(ru.softlogic.rma.connector.ws.stub.ServiceType type) {
        ServiceType st = new ServiceType();
        st.setName(type.getName());
        st.setLogo(type.getLogo());
        st.setItems(this.buildMenuItems(type.getItems(), st));
        return st;
    }

    public MenuItem[] buildMenuItems(List<ru.softlogic.rma.connector.ws.stub.MenuItem> menuItem, ServiceType st) {
        MenuItem[] item = null;
        if (menuItem != null && !menuItem.isEmpty()) {
            item = new MenuItem[menuItem.size()];
            int index = 0;
            for (ru.softlogic.rma.connector.ws.stub.MenuItem each : menuItem) {
                item[index++] = this.buildItem(each, st);
            }
        }
        return item;
    }

    public MenuItem buildItem(ru.softlogic.rma.connector.ws.stub.MenuItem item, ServiceType st) {
        MenuItem mi = new MenuItem();
        mi.setHotKey(item.isHotKey());
        mi.setStatus(item.getStatus());
        mi.setVerify(item.isVerify());
        mi.setWarning(item.isWarning());
        mi.setServiceType(st);
        mi.setIdMenu(item.getIdMenu());
        mi.setService(this.buildService(item.getService()));
        mi.setCommission(this.buildComission(item.getCommission()));
        mi.setFee(this.buildComission(item.getFee()));
        return mi;
    }

    public Service buildService(ru.softlogic.rma.connector.ws.stub.Service service) {
        Service s = null;
        if (service != null) {
            s = new Service();
            s.setFullName(service.getFullName());
            s.setId(service.getId());
            s.setCode(service.getCode());
            s.setBarcodePrefix(service.getBarcodePrefix());
            s.setLogo(service.getLogo());
            s.setMaxSum(service.getMaxSum());
            s.setMinSum(service.getMinSum());
            s.setName(service.getName());
            s.setAltName(service.getAltName());
            s.setPrintName(service.getPrintName());
            s.setProcessingType(service.getProcessingType());
            s.setShortName(service.getShortName());
            s.setVerifyType(service.getVerifyType());
            s.setProviderType(service.getProviderType());
            s.setWarning(service.getWarning());
            s.setChildServices(service.getChildServices());
            s.setProvider(service.getProvider());
            s.setLegalName(service.getLegalName());
            s.setInn(service.getInn());
            s.setProviderInn(service.getProviderInn());
            s.setContractNo(service.getContractNo());
            s.setSupport(service.getSupport());
            s.setProperties(service.getProperties());
            s.setProviderProperties(service.getProviderProperties());
            s.setBankBik(service.getBankBik());
            s.setBankName(service.getBankName());
            s.setBankRs(service.getBankRs());
            s.setBankKs(service.getBankKs());
            s.setKpp(service.getKpp());
            s.setKbk(service.getKbk());
            s.setOkato(service.getOkato());
            s.setPaymentDetails(service.getPaymentDetails());
            s.setCheckRender(service.getCheckRender());
            s.setProv(this.buildProvider(service.getProv()));
            s.setProvService(this.buildSp(service.getSp()));
            s.setCommission(this.buildComission(service.getMaxCommission()));
            s.setMinCommission(this.buildComission(service.getMinCommission()));
        }
        return s;
    }

    public ServiceProvider buildSp(ru.softlogic.rma.connector.ws.stub.ServiceProvider sp) {
        ServiceProvider sProv = null;
        if (sp != null) {
            sProv = new ServiceProvider();
            sProv.setId(sp.getId());
            sProv.setName(sp.getName());
            sProv.setContractNumber(sp.getCn());
            if (sp.getCd() != null) {
                sProv.setContractDate(sp.getCd().toGregorianCalendar().getTime());
            }
            sProv.setDetailsOfPayment(sp.getDp());
            ServiceProvider.Properties prop = sp.getProperties();
            if (prop != null && !prop.getEntry().isEmpty()) {
                for (ServiceProvider.Properties.Entry each : prop.getEntry()) {
                    sProv.getProperties().put(each.getKey(), each.getValue());
                }
            }
        }
        return sProv;
    }

    public Provider buildProvider(ru.softlogic.rma.connector.ws.stub.Dealer prov) {
        Provider provider = null;
        if (prov != null) {
            provider = new Provider();
            provider.setId(prov.getId());
            provider.setBankAddress(prov.getBankAdress());
            provider.setBankBik(prov.getBankBik());
            provider.setName(prov.getName());
            provider.setOgrn(prov.getOgrn());
            provider.setKpp(prov.getKpp());
            provider.setKbk(prov.getKbk());
            provider.setOkato(prov.getOkato());
            provider.setRs(prov.getAccount());
            provider.setKs(prov.getKs());
            provider.setContractNum(prov.getContractNum());
            provider.setContractDate(prov.getContractDate());
            provider.setBankName(prov.getBank());
            provider.setVat(prov.isVat());
            provider.setInn(prov.getInn());
            if (prov.getProperties() != null) {
                provider.getProperties().putAll(prov.getProperties());
            }
        }
        return provider;
    }

    public ru.softlogic.rma.connector.model.PersonalNumber[] buildPersonalNumbers(List<PersonalNumber> numbers) {
        ru.softlogic.rma.connector.model.PersonalNumber[] num = null;
        if (numbers != null && !numbers.isEmpty()) {
            num = new ru.softlogic.rma.connector.model.PersonalNumber[numbers.size()];
            int index = 0;
            for (PersonalNumber each : numbers) {
                num[index++] = this.buildPersonalNumber(each);
            }
        }
        return num;
    }

    public ru.softlogic.rma.connector.model.PersonalNumber buildPersonalNumber(PersonalNumber number) {
        ru.softlogic.rma.connector.model.PersonalNumber num = null;
        if (number != null) {
            num = new ru.softlogic.rma.connector.model.PersonalNumber();
            num.setType(number.getType());
            num.setNumber(number.getNumber());
            num.setCommission(this.buildComission(number.getCommission()));
        }
        return num;
    }

    public ru.softlogic.rma.connector.model.Commission buildComission(Commission commission) {
        ru.softlogic.rma.connector.model.Commission comm = null;
        if (commission != null) {
            comm = new ru.softlogic.rma.connector.model.Commission();
            comm.setFixedValue(commission.getFixedValue());
            comm.setId((short)commission.getId());
            comm.setMax(commission.getMax());
            comm.setMin(commission.getMin());
            comm.setRoundOrder(commission.getRoundOrder());
            comm.setName(commission.getName());
            comm.setPercentValue(commission.getPercentValue());
            comm.setType(commission.getType() == 0 ? CommissionType.Direct : CommissionType.Inverce);
            comm.setSteps(this.buildStaps(commission.getSteps()));
        }
        return comm;
    }

    public TreeSet<CommissionStep> buildStaps(List<ru.softlogic.rma.connector.ws.stub.CommissionStep> staps) {
        TreeSet sTree = null;
        if (staps != null) {
            sTree = new TreeSet();
            for (ru.softlogic.rma.connector.ws.stub.CommissionStep commissionStep : staps) {
                CommissionStep cs = new CommissionStep();
                cs.setFixedValue(commissionStep.getFixedValue());
                cs.setPercentValue(commissionStep.getPercentValue());
                cs.setSum(commissionStep.getSum());
                cs.setMin(commissionStep.getMin());
                cs.setMax(commissionStep.getMax());
            }
        }
        return sTree;
    }

    public ru.softlogic.rma.model.add.PD4Record[] buildPD4Records(PD4Record[] records) {
        ru.softlogic.rma.model.add.PD4Record[] rec = null;
        if (records != null) {
            rec = new ru.softlogic.rma.model.add.PD4Record[records.length];
            int index = 0;
            for (PD4Record each : records) {
                rec[index++] = this.buildPD4Record(each);
            }
        }
        return rec;
    }

    public ru.softlogic.rma.model.add.PD4Record buildPD4Record(PD4Record records) {
        ru.softlogic.rma.model.add.PD4Record rec = new ru.softlogic.rma.model.add.PD4Record();
        if (records != null) {
            rec.setBank(records.getBank());
            rec.setBankKs(records.getBankKs());
            rec.setBik(records.getBik());
            rec.setDestination(records.getDestination());
            rec.setInn(records.getInn());
            rec.setKbk(records.getKbk());
            rec.setKpp(records.getKpp());
            rec.setName(records.getName());
            rec.setOkato(records.getOkato());
            rec.setRs(records.getRs());
        }
        return rec;
    }

    public ru.softlogic.rma.connector.model.command.Command[] buildCommands(Command[] command) {
        ru.softlogic.rma.connector.model.command.Command[] commands = null;
        if (command != null) {
            commands = new ru.softlogic.rma.connector.model.command.Command[command.length];
            int index = 0;
            for (Command each : command) {
                commands[index++] = this.buildCommand(each);
            }
        }
        return commands;
    }

    public ru.softlogic.rma.connector.model.command.Command buildCommand(Command command) {
        return new ru.softlogic.rma.connector.model.command.Command(command.getId(), CommandType.valueOf(command.getType().name()), command.getExecuteTill(), command.isReboot(), command.getParam1(), command.getParam2(), command.getParam3(), command.getComment());
    }

    public ru.softlogic.rma.connector.model.command.Auth buildAuth(Auth auth) {
        ru.softlogic.rma.connector.model.command.Auth a = null;
        if (auth != null) {
            a = new ru.softlogic.rma.connector.model.command.Auth(auth.getUser(), auth.getPassword());
        }
        return a;
    }

    public Point buildPoint(ru.softlogic.rma.connector.ws.stub.Point point) {
        Point p = null;
        if (point != null) {
            p = new Point();
            p.setName(point.getName());
            p.setAddress(point.getAddress());
            p.setId(point.getId());
            p.setOperator(point.getOperator());
            p.setCityId(point.getCityId());
            p.setCityName(point.getCityName());
            p.setCityCode(point.getCityCode());
            p.setNeedConnection(point.isNeedConnection() == null ? false : point.isNeedConnection());
            p.setAttributes(point.getAttributes());
            p.setWorkWithShift(point.isShiftWork());
        }
        return p;
    }

    public Operator buildOperator(ru.softlogic.rma.connector.ws.stub.Operator operator) {
        Operator oper = null;
        if (operator != null) {
            oper = new Operator();
            oper.setName(operator.getName());
            oper.setBankBik(operator.getBankBik());
            oper.setBankContract(operator.getBankContract());
            oper.setBankName(operator.getBankName());
            oper.setSite(operator.getSite());
            oper.setLegalName(operator.getLegalName());
            oper.setSupport(operator.getSupport());
        }
        return oper;
    }

    public Dealer buildDealer(ru.softlogic.rma.connector.ws.stub.Dealer dealer) {
        Dealer d = null;
        if (dealer != null) {
            d = new Dealer();
            d.setId(dealer.getId());
            d.setName(dealer.getName());
            d.setAddress(dealer.getAddress());
            d.setSupport(dealer.getSupport());
            d.setInn(dealer.getInn());
            d.setSupportWorkTime(dealer.getSupportWorkTime());
            d.setProperties(dealer.getProperties());
            d.setBank(dealer.getBank());
        }
        return d;
    }
}

