/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model.add;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.rma.connector.model.MenuItem;
import ru.softlogic.rma.connector.model.Service;
import ru.softlogic.rma.model.add.BankRecord;
import ru.softlogic.rma.model.add.PD4Record;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.providers.universal.general.ControlData;

public class PD4Fields {
    public static final String NAME = "corr_name";
    public static final String RS = "recipient_acc";
    public static final String INN = "corr_inn";
    public static final String KPP = "corr_kpp";
    public static final String BANK = "corr_bank_name";
    public static final String BANK_KS = "corr_acc";
    public static final String BIK = "corr_bik";
    public static final String KBK = "corr_kbk";
    public static final String OKATO = "corr_oktmo";
    public static final String PAYER_NAME = "fio";
    public static final String PAYER_ADDRESS = "adr";
    public static final String PAYER_PHONE = "client_tel";
    public static final String PAYER_DEST = "pay_purpose";

    public static Map<Field, Object> getPD4Values(MenuItem menuItem, Map<String, IdentityField> fields, Map<String, Object> panelValues) {
        return PD4Fields.getPD4Values(menuItem, fields, panelValues, null);
    }

    public static Map<Field, Object> getPD4Values(MenuItem menuItem, Map<String, IdentityField> fields, Map<String, Object> panelValues, Map<String, BankRecord> bankRecords) {
        HashMap<Field, Object> values = new HashMap<Field, Object>();
        if (menuItem != null && menuItem.getService() != null && fields != null) {
            Service s = menuItem.getService();
            Field f = (Field)fields.get(BIK);
            if (f != null) {
                if (panelValues.get(BIK) != null) {
                    values.put(f, ((InputElement)panelValues.get(BIK)).getValue());
                } else if (s.getBankBik() != null && !s.getBankBik().trim().isEmpty()) {
                    values.put(f, s.getBankBik());
                }
            }
            if ((f = (Field)fields.get(BANK)) != null) {
                if (panelValues.get(BANK) != null) {
                    values.put(f, ((InputElement)panelValues.get(BANK)).getValue());
                } else if (s.getBankName() != null && !s.getBankName().trim().isEmpty()) {
                    values.put(f, s.getBankName());
                } else if (bankRecords != null && bankRecords.get((String)values.get(fields.get(BIK))) != null) {
                    values.put(f, bankRecords.get((String)values.get(fields.get(BIK))).getName());
                }
            }
            if ((f = (Field)fields.get(BANK_KS)) != null) {
                if (panelValues.get(BANK_KS) != null) {
                    values.put(f, ((InputElement)panelValues.get(BANK_KS)).getValue());
                } else if (s.getBankKs() != null && !s.getBankKs().trim().isEmpty()) {
                    values.put(f, s.getBankKs());
                } else if (bankRecords != null && bankRecords.get((String)values.get(fields.get(BIK))) != null) {
                    values.put(f, bankRecords.get((String)values.get(fields.get(BIK))).getKs());
                }
            }
            if ((f = (Field)fields.get(NAME)) != null) {
                if (panelValues.get(NAME) != null) {
                    values.put(f, ((InputElement)panelValues.get(NAME)).getValue());
                } else if (s.getBankBik() != null && !s.getBankBik().trim().isEmpty()) {
                    values.put(f, s.getPrintName());
                }
            }
            if ((f = (Field)fields.get(INN)) != null) {
                if (panelValues.get(INN) != null) {
                    values.put(f, panelValues.get(INN));
                } else if (s.getProviderInn() != null && !s.getProviderInn().trim().isEmpty()) {
                    values.put(f, s.getProviderInn());
                } else if (s.getInn() != null && !s.getInn().trim().isEmpty()) {
                    values.put(f, s.getInn());
                }
            }
            if ((f = (Field)fields.get(KBK)) != null) {
                if (panelValues.get(KBK) != null) {
                    System.out.println(">>> kbk from form = " + panelValues.get(KBK));
                    values.put(f, ((InputElement)panelValues.get(KBK)).getValue());
                } else if (s.getKbk() != null && !s.getKbk().trim().isEmpty()) {
                    values.put(f, s.getKbk());
                }
            }
            if ((f = (Field)fields.get(KPP)) != null) {
                if (panelValues.get(KPP) != null) {
                    values.put(f, ((InputElement)panelValues.get(KPP)).getValue());
                } else if (s.getKpp() != null && !s.getKpp().trim().isEmpty()) {
                    values.put(f, s.getKpp());
                }
            }
            if ((f = (Field)fields.get(OKATO)) != null) {
                if (panelValues.get(OKATO) != null) {
                    System.out.println(">>> okato from form = " + panelValues.get(KBK));
                    values.put(f, ((InputElement)panelValues.get(OKATO)).getValue());
                } else if (s.getOkato() != null && !s.getOkato().trim().isEmpty()) {
                    values.put(f, s.getOkato());
                }
            }
            f = (Field)fields.get(PAYER_DEST);
            String value = "";
            if (f != null) {
                if (panelValues.get(PAYER_DEST) != null) {
                    value = ((InputElement)panelValues.get(PAYER_DEST)).getValue();
                } else if (s.getPaymentDetails() != null && !s.getPaymentDetails().trim().isEmpty()) {
                    value = String.valueOf(s.getPaymentDetails());
                }
            }
            values.put(f, PD4Fields.processTemplate(value, panelValues));
            f = (Field)fields.get(RS);
            if (f != null) {
                if (panelValues.get(RS) != null) {
                    values.put(f, ((InputElement)panelValues.get(RS)).getValue());
                } else if (s.getBankRs() != null && !s.getBankRs().trim().isEmpty()) {
                    values.put(f, s.getBankRs());
                }
            }
            if ((f = (Field)fields.get(PAYER_NAME)) != null && panelValues.get(PAYER_NAME) != null) {
                values.put(f, ((InputElement)panelValues.get(PAYER_NAME)).getValue());
            }
            if ((f = (Field)fields.get(PAYER_PHONE)) != null && panelValues.get(PAYER_PHONE) != null) {
                values.put(f, ((InputElement)panelValues.get(PAYER_PHONE)).getValue());
            }
            if ((f = (Field)fields.get(PAYER_ADDRESS)) != null && panelValues.get(PAYER_ADDRESS) != null) {
                values.put(f, ((InputElement)panelValues.get(PAYER_ADDRESS)).getValue());
            }
        }
        return values;
    }

    public static boolean isPD4InForm(List<IdentityField> fields) {
        HashSet<String> keys = new HashSet<String>();
        for (Field field : fields) {
            if (!(field instanceof IdentityField)) continue;
            keys.add(((IdentityField)field).getId());
        }
        return keys.contains(BANK) && keys.contains(BANK_KS) && keys.contains(BIK) && keys.contains(INN) && keys.contains(KPP) && keys.contains(NAME) && keys.contains(PAYER_ADDRESS) && keys.contains(PAYER_DEST) && keys.contains(PAYER_NAME) && keys.contains(PAYER_PHONE) && keys.contains(RS);
    }

    public static boolean isPD4InFormPD4(List<ControlData> data) {
        HashSet<String> keys = new HashSet<String>();
        for (ControlData cd : data) {
            Field ff = cd.getField();
            if (!(ff instanceof IdentityField)) continue;
            keys.add(((IdentityField)ff).getId());
        }
        return keys.contains(BANK) && keys.contains(BANK_KS) && keys.contains(BIK) && keys.contains(INN) && keys.contains(KPP) && keys.contains(NAME) && keys.contains(PAYER_ADDRESS) && keys.contains(PAYER_DEST) && keys.contains(PAYER_NAME) && keys.contains(PAYER_PHONE) && keys.contains(RS);
    }

    public static boolean isPD4InData(Map<String, Object> data) {
        HashSet<String> keys = new HashSet<String>();
        for (String key : data.keySet()) {
            Object obj = data.get(key);
            if (key.startsWith("#") || !(obj instanceof InputElement)) continue;
            InputElement ie = (InputElement)obj;
            keys.add(ie.getKey());
        }
        return keys.contains(BANK) && keys.contains(BANK_KS) && keys.contains(BIK) && keys.contains(INN) && keys.contains(KPP) && keys.contains(NAME) && keys.contains(PAYER_ADDRESS) && keys.contains(PAYER_DEST) && keys.contains(PAYER_NAME) && keys.contains(PAYER_PHONE) && keys.contains(RS);
    }

    public static boolean isSingleValue(Set<PD4Record> records, String field) {
        if (records.size() == 1) {
            return true;
        }
        String value = null;
        for (PD4Record rec : records) {
            if (value == null) {
                if (INN.equals(field)) {
                    value = rec.getInn();
                    continue;
                }
                if (KPP.equals(field)) {
                    value = rec.getKpp();
                    continue;
                }
                if (PAYER_DEST.equals(field)) {
                    value = rec.getDestination();
                    continue;
                }
                if (BIK.equals(field)) {
                    value = rec.getBik();
                    continue;
                }
                if (NAME.equals(field)) {
                    value = rec.getName();
                    continue;
                }
                if (OKATO.equals(field)) {
                    value = rec.getOkato();
                    continue;
                }
                if (KBK.equals(field)) {
                    value = rec.getKbk();
                    continue;
                }
                if (!RS.equals(field)) continue;
                value = rec.getRs();
                continue;
            }
            if (INN.equals(field) && !value.equalsIgnoreCase(rec.getInn())) {
                return false;
            }
            if (KPP.equals(field) && !value.equalsIgnoreCase(rec.getKpp())) {
                return false;
            }
            if (PAYER_DEST.equals(field) && !value.equalsIgnoreCase(rec.getDestination())) {
                return false;
            }
            if (BIK.equals(field) && !value.equalsIgnoreCase(rec.getBik())) {
                return false;
            }
            if (NAME.equals(field) && !value.equalsIgnoreCase(rec.getName())) {
                return false;
            }
            if (OKATO.equals(field) && !value.equalsIgnoreCase(rec.getOkato())) {
                return false;
            }
            if (KBK.equals(field) && !value.equalsIgnoreCase(rec.getKbk())) {
                return false;
            }
            if (!RS.equals(field) || value.equalsIgnoreCase(rec.getRs())) continue;
            return false;
        }
        return true;
    }

    public static boolean isPD4InForm(Record record) {
        if (record == null || record.getAttributes() == null) {
            return false;
        }
        Set<String> keySet = record.getAttributes().keySet();
        return keySet.contains(BANK) && keySet.contains(BANK_KS) && keySet.contains(BIK) && keySet.contains(INN) && keySet.contains(KBK) && keySet.contains(KPP) && keySet.contains(NAME) && keySet.contains(OKATO) && keySet.contains(PAYER_ADDRESS) && keySet.contains(PAYER_DEST) && keySet.contains(PAYER_NAME) && keySet.contains(PAYER_PHONE) && keySet.contains(RS);
    }

    public static String processTemplate(String template, Map<String, Object> data) {
        if (template == null || data == null) {
            return null;
        }
        Set<String> keys = PD4Fields.parceTemplate(template);
        for (String key : keys) {
            String value = null;
            Object object = data.get(key);
            if (object instanceof String) {
                value = (String)object;
            } else if (object instanceof InputElement) {
                value = ((InputElement)object).getValue();
            }
            if (value == null) continue;
            template = template.replaceAll("\\$\\{" + key + "\\}", value);
        }
        return template;
    }

    public static Set<String> parceTemplate(String template) {
        if (template == null) {
            template = "";
        }
        HashSet<String> set = new HashSet<String>();
        Matcher m = Pattern.compile("\\$\\{(([A-Za-z\u0410-\u042f\u0430-\u044f0-9_.])+)\\}").matcher(template);
        while (m.find()) {
            set.add(m.group(1));
        }
        return set;
    }
}

