/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import ru.softlogic.rma.mainmenu.MainMenuListener;
import ru.softlogic.rma.model.PaymentTableModel;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.persistence.v2.PersistenceManager;
import ru.softlogic.rma.utils.StateUtil;

public class TableMouseListener
extends MouseAdapter {
    private JTable paymentTable;
    private SimpleDateFormat sdf;
    private JLabel processedLabel;
    private JLabel stateLabel;
    private JLabel substateLabel;
    private JLabel errorLabel;
    private JPopupMenu popupMenu;
    private JMenuItem cancelMenuItem;
    private MainMenuListener appMainMenuListener;
    private JMenuItem paymentReprintMenuItem;
    private JMenuItem addToCartMenuItem;

    public TableMouseListener(JTable paymentTable) {
        if (paymentTable == null) {
            throw new IllegalArgumentException("Need payments table");
        }
        this.paymentTable = paymentTable;
        this.sdf = new SimpleDateFormat("HH:mm:ss dd.MM.yy");
    }

    public void setErrorLabel(JLabel errorLabel) {
        this.errorLabel = errorLabel;
    }

    public void setProcessedLabel(JLabel processedLabel) {
        this.processedLabel = processedLabel;
    }

    public void setStateLabel(JLabel stateLabel) {
        this.stateLabel = stateLabel;
    }

    public void setSubstateLabel(JLabel substateLabel) {
        this.substateLabel = substateLabel;
    }

    public void setCancelMenuItem(JMenuItem cancelMenuItem) {
        this.cancelMenuItem = cancelMenuItem;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public void setPaymentReprintMenuItem(JMenuItem paymentPrintBackMenuItem) {
        this.paymentReprintMenuItem = paymentPrintBackMenuItem;
    }

    public void setAddToCartMenuItem(JMenuItem addToCartMenuItem) {
        this.addToCartMenuItem = addToCartMenuItem;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 1) {
            Record rec = this.getRecord(event);
            if (rec != null) {
                if (this.processedLabel != null) {
                    this.processedLabel.setText(this.sdf.format(rec.getProcessed()));
                }
                if (this.stateLabel != null) {
                    this.stateLabel.setText(StateUtil.formatState(rec.getState()));
                }
                if (this.substateLabel != null) {
                    this.substateLabel.setText(StateUtil.formatSubstate(rec.getState(), rec.getSubstate()));
                }
                if (this.errorLabel != null) {
                    this.errorLabel.setText(StateUtil.formatError(rec.getError()));
                }
            } else {
                if (this.processedLabel != null) {
                    this.processedLabel.setText("");
                }
                if (this.stateLabel != null) {
                    this.stateLabel.setText("");
                }
                if (this.substateLabel != null) {
                    this.substateLabel.setText("");
                }
                if (this.errorLabel != null) {
                    this.errorLabel.setText("");
                }
            }
        } else if (event.getClickCount() == 2 & event.getButton() == 1) {
            // empty if block
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        Record rec;
        if (event.isMetaDown() && (rec = this.getRecord(event)) != null) {
            System.out.println("111   " + rec);
            try {
                rec = PersistenceManager.getInstance().getOperationById(rec.getId());
            }
            catch (Exception ex) {
                return;
            }
            if (rec == null) {
                return;
            }
            if (this.cancelMenuItem != null) {
                this.cancelMenuItem.setEnabled(rec.getState() == 60);
                this.cancelMenuItem.putClientProperty("rec", rec);
            }
            if (this.addToCartMenuItem != null) {
                this.addToCartMenuItem.setEnabled(false);
                this.addToCartMenuItem.putClientProperty("rec", rec);
            }
            if (this.paymentReprintMenuItem != null) {
                this.paymentReprintMenuItem.putClientProperty("rec", rec);
            }
            if (this.popupMenu != null) {
                this.popupMenu.show((JComponent)event.getSource(), event.getX(), event.getY());
            }
        }
    }

    private Record getRecord(MouseEvent event) {
        int row = this.paymentTable.rowAtPoint(event.getPoint());
        if (row >= 0) {
            ListSelectionModel model = this.paymentTable.getSelectionModel();
            model.setSelectionInterval(row, row);
            PaymentTableModel ptm = (PaymentTableModel)this.paymentTable.getModel();
            return ptm.getRecords()[row];
        }
        return null;
    }

    public void setViewListener(MainMenuListener appMainMenuListener) {
        this.appMainMenuListener = appMainMenuListener;
    }
}

