/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model;

import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.model.directory.shift.ShiftType;
import ru.softlogic.rma.connector.model.directory.shift.ShiftTypeCodes;

public class ShiftTableModel
implements TableModel {
    private String[] names;
    private ShiftType[] shifts;
    private Set<TableModelListener> listeners;
    private SimpleDateFormat timeFormatter = new SimpleDateFormat("HH-mm-ss");

    public ShiftTableModel() {
        this.names = new String[]{"#", "\u0422\u0438\u043f \u0441\u043c\u0435\u043d\u044b", "\u0412\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430", "\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", "\u0412 \u0440\u0430\u0431. \u0434\u043d\u0438", "\u0412 \u0432\u044b\u0445. \u0434\u043d\u0438"};
        this.listeners = new HashSet<TableModelListener>();
    }

    @Override
    public int getRowCount() {
        return this.shifts == null ? 0 : this.shifts.length;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ShiftType shift = this.shifts[rowIndex];
        switch (columnIndex) {
            case 0: {
                return rowIndex + 1;
            }
            case 1: {
                return this.shifts[rowIndex].getType().equals(ShiftTypeCodes.OPERATING.getCode()) ? "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f" : "\u0412\u043d\u0435\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f";
            }
            case 2: {
                return this.timeFormatter.format(shift.getStart());
            }
            case 3: {
                return this.timeFormatter.format(shift.getEnd());
            }
            case 4: {
                return (shift.getFlags() & 1) == 1 ? "\u0414\u0430" : "\u041d\u0435\u0442";
            }
            case 5: {
                return (shift.getFlags() & 2) == 2 ? "\u0414\u0430" : "\u041d\u0435\u0442";
            }
        }
        return LocBundle.getMessage((String)"rma.model.unknown");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void setShifts(ShiftType[] shifts) {
        this.shifts = shifts;
        for (TableModelListener l : this.listeners) {
            l.tableChanged(new TableModelEvent(this));
        }
    }
}

