/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import ru.softlogic.rma.connector.model.ShiftInfo;
import ru.softlogic.rma.model.ResultShiftInfoTableModel;

public class ShiftResultMouseListener
extends MouseAdapter {
    private JTable shiftInfoTable;
    private JLabel processedLable;

    public ShiftResultMouseListener(JTable shiftTable) {
        if (shiftTable == null) {
            throw new IllegalArgumentException("Need payments table");
        }
        this.shiftInfoTable = shiftTable;
    }

    public void setProcessedLable(JLabel processedLable) {
        this.processedLable = processedLable;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        ShiftInfo shiftInfo;
        if (event.getClickCount() == 1 && (shiftInfo = this.getShiftInfo(event)) != null && this.processedLable != null) {
            if (shiftInfo.getState() == 0) {
                this.processedLable.setText("\u041e\u0442\u043a\u0440\u044b\u0442\u0430\u044f \u0441\u043c\u0435\u043d\u0430");
            } else if (shiftInfo.getState() == 1) {
                this.processedLable.setText("\u0417\u0430\u043a\u0440\u044b\u0442\u0430");
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.isMetaDown()) {
            // empty if block
        }
    }

    private ShiftInfo getShiftInfo(MouseEvent event) {
        int row = this.shiftInfoTable.rowAtPoint(event.getPoint());
        if (row >= 0) {
            ListSelectionModel model = this.shiftInfoTable.getSelectionModel();
            model.setSelectionInterval(row, row);
            ResultShiftInfoTableModel smodel = (ResultShiftInfoTableModel)this.shiftInfoTable.getModel();
            return smodel.getShiftInfo()[row];
        }
        return null;
    }
}

