/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.model.ShiftInfo;

public class ResultShiftInfoTableModel
implements TableModel {
    private String[] names;
    private ShiftInfo[] shifts;
    private SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:00");
    DecimalFormat df1 = new DecimalFormat("#,###,###,##0.00");
    private Set<TableModelListener> listeners;

    public ResultShiftInfoTableModel() {
        this.names = new String[]{"\u041d\u043e\u043c\u0435\u0440 \u0441\u043c.", "\u041e\u043f\u0435\u0440. \u0434\u0435\u043d\u044c", "\u041e\u0442\u043a\u0440\u044b\u0442\u0430", "\u0417\u0430\u043a\u0440\u044b\u0442\u0430", "\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", "\u0421\u0443\u043c\u043c\u0430", "\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435"};
        this.listeners = new HashSet<TableModelListener>();
    }

    public ShiftInfo[] getShiftInfo() {
        return this.shifts;
    }

    public void setShiftsInfo(ShiftInfo[] shifts) {
        this.shifts = shifts;
        this.notifyListeners();
    }

    @Override
    public int getRowCount() {
        return this.shifts == null ? 0 : this.shifts.length;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 6) {
            return JPanel.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 6;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.shifts[rowIndex].getNum();
            }
            case 1: {
                return this.shifts[rowIndex].getOperDay();
            }
            case 2: {
                return this.timeFormatter.format(this.shifts[rowIndex].getStartTime());
            }
            case 3: {
                if (this.shifts[rowIndex].getState() == 0) {
                    return " - ";
                }
                return this.timeFormatter.format(this.shifts[rowIndex].getCloseTime());
            }
            case 4: {
                return this.shifts[rowIndex].getCoutPayments();
            }
            case 5: {
                return this.df1.format(this.shifts[rowIndex].getSum() / 100L);
            }
        }
        return LocBundle.getMessage((String)"rma.model.unknown");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void notifyListeners() {
        for (TableModelListener item : this.listeners) {
            item.tableChanged(new TableModelEvent(this));
        }
    }
}

