/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import rmai18n.LocBundle;
import ru.softlogic.rma.persistence.Record;
import ru.softlogic.rma.utils.StateUtil;
import ru.softlogic.rma.utils.SumFormatter;

public class PaymentTableModel
implements TableModel {
    private String[] names;
    private Record[] records;
    private SimpleDateFormat sdf;
    private Set<TableModelListener> listeners;
    private boolean isAbsControlUsed;
    private boolean useShifts;

    public PaymentTableModel(boolean isAbsControlUsed) {
        this.isAbsControlUsed = isAbsControlUsed;
        this.initModel();
        this.sdf = new SimpleDateFormat("HH:mm:ss dd.MM.yy");
        this.listeners = new HashSet<TableModelListener>();
    }

    public void setUseShifts(boolean flag) {
        this.useShifts = flag;
    }

    public void setRecords(Record[] records) {
        this.records = records;
        this.notifyListeners();
    }

    public Record[] getRecords() {
        return this.records;
    }

    @Override
    public int getRowCount() {
        return this.records == null ? 0 : this.records.length;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Record rec = this.records[rowIndex];
        switch (columnIndex) {
            case 0: {
                return String.valueOf(rec.getId());
            }
            case 1: {
                return this.sdf.format(rec.getCreated());
            }
            case 2: {
                return new Integer(rec.getDoc());
            }
            case 3: {
                return rec.getServiceName();
            }
            case 4: {
                return rec.getAccount();
            }
            case 5: {
                return SumFormatter.format(rec.getSumIncome());
            }
            case 6: {
                return SumFormatter.format(rec.getSumOutcome());
            }
            case 7: {
                return SumFormatter.format(rec.getSumComm());
            }
            case 8: {
                return StateUtil.formatSubstate(rec.getState(), rec.getSubstate());
            }
            case 9: {
                return StateUtil.formatFinal(rec.getFinalStatus());
            }
            case 10: {
                return rec.getNumShift();
            }
            case 11: {
                return StateUtil.formatAsbState(rec.getAbsState());
            }
            case 12: {
                return rec.getCrc();
            }
        }
        return LocBundle.getMessage((String)"rma.model.unknown");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    private void notifyListeners() {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(new TableModelEvent(this));
        }
    }

    public void setAbsControlUsed(boolean isUsed) {
        this.isAbsControlUsed = isUsed;
        this.initModel();
        this.notifyListeners();
    }

    public void initModel() {
        ArrayList<String> namesLst = new ArrayList<String>();
        namesLst.add("Id");
        namesLst.add(LocBundle.getMessage((String)"rma.model.paydata"));
        namesLst.add(LocBundle.getMessage((String)"rma.model.paycheck"));
        namesLst.add(LocBundle.getMessage((String)"rma.model.payserv"));
        namesLst.add(LocBundle.getMessage((String)"rma.model.paynumb"));
        namesLst.add(LocBundle.getMessage((String)"rma.model.payinput"));
        namesLst.add(LocBundle.getMessage((String)"rma.model.payout"));
        namesLst.add(LocBundle.getMessage((String)"rma.model.paycomm"));
        namesLst.add(LocBundle.getMessage((String)"rma.model.paystat"));
        namesLst.add(LocBundle.getMessage((String)"rma.model.payfinal"));
        if (this.useShifts) {
            namesLst.add(LocBundle.getMessage((String)"rma.model.numshift"));
            if (this.isAbsControlUsed) {
                namesLst.add(LocBundle.getMessage((String)"rma.model.paystatabs"));
                namesLst.add(LocBundle.getMessage((String)"rma.model.paycontrol"));
            }
        }
        this.names = namesLst.toArray(new String[namesLst.size()]);
    }
}

