/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.rma.model;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import rmai18n.LocBundle;
import ru.softlogic.rma.connector.model.CommissionStep;
import ru.softlogic.rma.utils.SumFormatter;

public class CommissionTableModel
implements TableModel {
    private String[] names = new String[]{LocBundle.getMessage((String)"rma.model.sumfrom"), "%", LocBundle.getMessage((String)"rma.model.sumfix"), "Min", "Max"};
    private TreeSet<CommissionStep> steps;
    private CommissionStep[] stepArray;
    private Set<TableModelListener> listeners = new HashSet<TableModelListener>();

    public void setSteps(TreeSet<CommissionStep> steps) {
        this.steps = steps;
        this.stepArray = steps == null ? null : steps.toArray(new CommissionStep[steps.size()]);
        for (TableModelListener l : this.listeners) {
            l.tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public int getRowCount() {
        return this.steps == null ? 0 : this.steps.size();
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CommissionStep step = this.stepArray[rowIndex];
        switch (columnIndex) {
            case 0: {
                return SumFormatter.format(step.getSum());
            }
            case 1: {
                return SumFormatter.format(step.getPercentValue());
            }
            case 2: {
                return SumFormatter.format(step.getFixedValue());
            }
            case 3: {
                return step.getMin() == 0 ? "" : SumFormatter.format(step.getMin());
            }
            case 4: {
                return step.getMax() == 0 ? "" : SumFormatter.format(step.getMax());
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }
}

